/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.Signal;
import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.SingleThreadEventExecutor;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DefaultPromiseTest {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultPromiseTest.class);
    private static int stackOverflowDepth;

    @BeforeClass
    public static void beforeClass() {
        try {
            DefaultPromiseTest.findStackOverflowDepth();
            throw new IllegalStateException("Expected StackOverflowError but didn't get it?!");
        }
        catch (StackOverflowError e) {
            logger.debug("StackOverflowError depth: {}", (Object)stackOverflowDepth);
            return;
        }
    }

    private static void findStackOverflowDepth() {
        ++stackOverflowDepth;
        DefaultPromiseTest.findStackOverflowDepth();
    }

    private static int stackOverflowTestDepth() {
        return Math.max(stackOverflowDepth << 1, stackOverflowDepth);
    }

    @Test
    public void testCancelDoesNotScheduleWhenNoListeners() {
        EventExecutor executor = (EventExecutor)Mockito.mock(EventExecutor.class);
        Mockito.when((Object)executor.inEventLoop()).thenReturn((Object)false);
        DefaultPromise promise = new DefaultPromise(executor);
        Assert.assertTrue((boolean)promise.cancel(false));
        ((EventExecutor)Mockito.verify((Object)executor, (VerificationMode)Mockito.never())).execute((Runnable)Mockito.any(Runnable.class));
        Assert.assertTrue((boolean)promise.isCancelled());
    }

    @Test
    public void testSuccessDoesNotScheduleWhenNoListeners() {
        EventExecutor executor = (EventExecutor)Mockito.mock(EventExecutor.class);
        Mockito.when((Object)executor.inEventLoop()).thenReturn((Object)false);
        Object value = new Object();
        DefaultPromise promise = new DefaultPromise(executor);
        promise.setSuccess(value);
        ((EventExecutor)Mockito.verify((Object)executor, (VerificationMode)Mockito.never())).execute((Runnable)Mockito.any(Runnable.class));
        Assert.assertSame((Object)value, (Object)promise.getNow());
    }

    @Test
    public void testFailureDoesNotScheduleWhenNoListeners() {
        EventExecutor executor = (EventExecutor)Mockito.mock(EventExecutor.class);
        Mockito.when((Object)executor.inEventLoop()).thenReturn((Object)false);
        Exception cause = new Exception();
        DefaultPromise promise = new DefaultPromise(executor);
        promise.setFailure((Throwable)cause);
        ((EventExecutor)Mockito.verify((Object)executor, (VerificationMode)Mockito.never())).execute((Runnable)Mockito.any(Runnable.class));
        Assert.assertSame((Object)cause, (Object)promise.cause());
    }

    @Test(expected=CancellationException.class)
    public void testCancellationExceptionIsThrownWhenBlockingGet() throws InterruptedException, ExecutionException {
        DefaultPromise promise = new DefaultPromise((EventExecutor)ImmediateEventExecutor.INSTANCE);
        Assert.assertTrue((boolean)promise.cancel(false));
        promise.get();
    }

    @Test(expected=CancellationException.class)
    public void testCancellationExceptionIsThrownWhenBlockingGetWithTimeout() throws InterruptedException, ExecutionException, TimeoutException {
        DefaultPromise promise = new DefaultPromise((EventExecutor)ImmediateEventExecutor.INSTANCE);
        Assert.assertTrue((boolean)promise.cancel(false));
        promise.get(1L, TimeUnit.SECONDS);
    }

    @Test
    public void testCancellationExceptionIsReturnedAsCause() throws InterruptedException, ExecutionException, TimeoutException {
        DefaultPromise promise = new DefaultPromise((EventExecutor)ImmediateEventExecutor.INSTANCE);
        Assert.assertTrue((boolean)promise.cancel(false));
        Assert.assertThat((Object)promise.cause(), (Matcher)Matchers.instanceOf(CancellationException.class));
    }

    @Test
    public void testStackOverflowWithImmediateEventExecutorA() throws Exception {
        DefaultPromiseTest.testStackOverFlowChainedFuturesA(DefaultPromiseTest.stackOverflowTestDepth(), (EventExecutor)ImmediateEventExecutor.INSTANCE, true);
        DefaultPromiseTest.testStackOverFlowChainedFuturesA(DefaultPromiseTest.stackOverflowTestDepth(), (EventExecutor)ImmediateEventExecutor.INSTANCE, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoStackOverflowWithDefaultEventExecutorA() throws Exception {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            DefaultEventExecutor executor = new DefaultEventExecutor((Executor)executorService);
            try {
                DefaultPromiseTest.testStackOverFlowChainedFuturesA(DefaultPromiseTest.stackOverflowTestDepth(), (EventExecutor)executor, true);
                DefaultPromiseTest.testStackOverFlowChainedFuturesA(DefaultPromiseTest.stackOverflowTestDepth(), (EventExecutor)executor, false);
            }
            finally {
                executor.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            executorService.shutdown();
        }
    }

    @Test
    public void testNoStackOverflowWithImmediateEventExecutorB() throws Exception {
        DefaultPromiseTest.testStackOverFlowChainedFuturesB(DefaultPromiseTest.stackOverflowTestDepth(), (EventExecutor)ImmediateEventExecutor.INSTANCE, true);
        DefaultPromiseTest.testStackOverFlowChainedFuturesB(DefaultPromiseTest.stackOverflowTestDepth(), (EventExecutor)ImmediateEventExecutor.INSTANCE, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoStackOverflowWithDefaultEventExecutorB() throws Exception {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            DefaultEventExecutor executor = new DefaultEventExecutor((Executor)executorService);
            try {
                DefaultPromiseTest.testStackOverFlowChainedFuturesB(DefaultPromiseTest.stackOverflowTestDepth(), (EventExecutor)executor, true);
                DefaultPromiseTest.testStackOverFlowChainedFuturesB(DefaultPromiseTest.stackOverflowTestDepth(), (EventExecutor)executor, false);
            }
            finally {
                executor.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            executorService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListenerNotifyOrder() throws Exception {
        TestEventExecutor executor = new TestEventExecutor();
        try {
            final LinkedBlockingQueue listeners = new LinkedBlockingQueue();
            int runs = 100000;
            for (int i = 0; i < runs; ++i) {
                DefaultPromise promise = new DefaultPromise((EventExecutor)executor);
                FutureListener<Void> listener1 = new FutureListener<Void>(){

                    public void operationComplete(Future<Void> future) throws Exception {
                        listeners.add(this);
                    }
                };
                FutureListener<Void> listener2 = new FutureListener<Void>(){

                    public void operationComplete(Future<Void> future) throws Exception {
                        listeners.add(this);
                    }
                };
                FutureListener<Void> listener4 = new FutureListener<Void>(){

                    public void operationComplete(Future<Void> future) throws Exception {
                        listeners.add(this);
                    }
                };
                FutureListener<Void> listener3 = new FutureListener<Void>((FutureListener)listener4){
                    final /* synthetic */ FutureListener val$listener4;
                    {
                        this.val$listener4 = futureListener;
                    }

                    public void operationComplete(Future<Void> future) throws Exception {
                        listeners.add(this);
                        future.addListener((GenericFutureListener)this.val$listener4);
                    }
                };
                GlobalEventExecutor.INSTANCE.execute(new Runnable((Promise)promise){
                    final /* synthetic */ Promise val$promise;
                    {
                        this.val$promise = promise;
                    }

                    @Override
                    public void run() {
                        this.val$promise.setSuccess(null);
                    }
                });
                promise.addListener((GenericFutureListener)listener1).addListener((GenericFutureListener)listener2).addListener((GenericFutureListener)listener3);
                Assert.assertSame((String)("Fail 1 during run " + i + " / " + runs), (Object)listener1, listeners.take());
                Assert.assertSame((String)("Fail 2 during run " + i + " / " + runs), (Object)listener2, listeners.take());
                Assert.assertSame((String)("Fail 3 during run " + i + " / " + runs), (Object)listener3, listeners.take());
                Assert.assertSame((String)("Fail 4 during run " + i + " / " + runs), (Object)listener4, listeners.take());
                Assert.assertTrue((String)("Fail during run " + i + " / " + runs), (boolean)listeners.isEmpty());
            }
        }
        finally {
            executor.shutdownGracefully(0L, 0L, TimeUnit.SECONDS).sync();
        }
    }

    @Test
    public void testListenerNotifyLater() throws Exception {
        DefaultPromiseTest.testListenerNotifyLater(1);
        DefaultPromiseTest.testListenerNotifyLater(2);
    }

    @Test(timeout=2000L)
    public void testPromiseListenerAddWhenCompleteFailure() throws Exception {
        DefaultPromiseTest.testPromiseListenerAddWhenComplete(DefaultPromiseTest.fakeException());
    }

    @Test(timeout=2000L)
    public void testPromiseListenerAddWhenCompleteSuccess() throws Exception {
        DefaultPromiseTest.testPromiseListenerAddWhenComplete(null);
    }

    @Test(timeout=2000L)
    public void testLateListenerIsOrderedCorrectlySuccess() throws InterruptedException {
        DefaultPromiseTest.testLateListenerIsOrderedCorrectly(null);
    }

    @Test(timeout=2000L)
    public void testLateListenerIsOrderedCorrectlyFailure() throws InterruptedException {
        DefaultPromiseTest.testLateListenerIsOrderedCorrectly(DefaultPromiseTest.fakeException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSignalRace() {
        long wait = TimeUnit.NANOSECONDS.convert(10L, TimeUnit.SECONDS);
        TestEventExecutor executor = null;
        try {
            executor = new TestEventExecutor();
            int numberOfAttempts = 4096;
            HashMap<Thread, DefaultPromise> promises = new HashMap<Thread, DefaultPromise>();
            for (int i = 0; i < 4096; ++i) {
                final DefaultPromise defaultPromise = new DefaultPromise((EventExecutor)executor);
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        defaultPromise.setSuccess(null);
                    }
                });
                promises.put(thread, defaultPromise);
            }
            for (Map.Entry entry : promises.entrySet()) {
                ((Thread)entry.getKey()).start();
                long start = System.nanoTime();
                ((DefaultPromise)entry.getValue()).awaitUninterruptibly(wait, TimeUnit.NANOSECONDS);
                Assert.assertThat((Object)(System.nanoTime() - start), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(wait)));
            }
        }
        finally {
            if (executor != null) {
                executor.shutdownGracefully();
            }
        }
    }

    @Test
    public void signalUncancellableCompletionValue() {
        DefaultPromise promise = new DefaultPromise((EventExecutor)ImmediateEventExecutor.INSTANCE);
        promise.setSuccess((Object)Signal.valueOf(DefaultPromise.class, (String)"UNCANCELLABLE"));
        Assert.assertTrue((boolean)promise.isDone());
        Assert.assertTrue((boolean)promise.isSuccess());
    }

    @Test
    public void signalSuccessCompletionValue() {
        DefaultPromise promise = new DefaultPromise((EventExecutor)ImmediateEventExecutor.INSTANCE);
        promise.setSuccess((Object)Signal.valueOf(DefaultPromise.class, (String)"SUCCESS"));
        Assert.assertTrue((boolean)promise.isDone());
        Assert.assertTrue((boolean)promise.isSuccess());
    }

    @Test
    public void setUncancellableGetNow() {
        DefaultPromise promise = new DefaultPromise((EventExecutor)ImmediateEventExecutor.INSTANCE);
        Assert.assertNull((Object)promise.getNow());
        Assert.assertTrue((boolean)promise.setUncancellable());
        Assert.assertNull((Object)promise.getNow());
        Assert.assertFalse((boolean)promise.isDone());
        Assert.assertFalse((boolean)promise.isSuccess());
        promise.setSuccess((Object)"success");
        Assert.assertTrue((boolean)promise.isDone());
        Assert.assertTrue((boolean)promise.isSuccess());
        Assert.assertEquals((Object)"success", (Object)promise.getNow());
    }

    private static void testStackOverFlowChainedFuturesA(int promiseChainLength, final EventExecutor executor, boolean runTestInExecutorThread) throws InterruptedException {
        DefaultPromise[] p = new DefaultPromise[promiseChainLength];
        CountDownLatch latch = new CountDownLatch(promiseChainLength);
        if (runTestInExecutorThread) {
            executor.execute(new Runnable((Promise[])p, latch){
                final /* synthetic */ Promise[] val$p;
                final /* synthetic */ CountDownLatch val$latch;
                {
                    this.val$p = promiseArray;
                    this.val$latch = countDownLatch;
                }

                @Override
                public void run() {
                    DefaultPromiseTest.testStackOverFlowChainedFuturesA(executor, this.val$p, this.val$latch);
                }
            });
        } else {
            DefaultPromiseTest.testStackOverFlowChainedFuturesA(executor, p, latch);
        }
        Assert.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        for (int i = 0; i < p.length; ++i) {
            Assert.assertTrue((String)("index " + i), (boolean)p[i].isSuccess());
        }
    }

    private static void testStackOverFlowChainedFuturesA(EventExecutor executor, final Promise<Void>[] p, final CountDownLatch latch) {
        for (int i = 0; i < p.length; ++i) {
            final int finalI = i;
            p[i] = new DefaultPromise(executor);
            p[i].addListener((GenericFutureListener)new FutureListener<Void>(){

                public void operationComplete(Future<Void> future) throws Exception {
                    if (finalI + 1 < p.length) {
                        p[finalI + 1].setSuccess(null);
                    }
                    latch.countDown();
                }
            });
        }
        p[0].setSuccess(null);
    }

    private static void testStackOverFlowChainedFuturesB(int promiseChainLength, final EventExecutor executor, boolean runTestInExecutorThread) throws InterruptedException {
        DefaultPromise[] p = new DefaultPromise[promiseChainLength];
        CountDownLatch latch = new CountDownLatch(promiseChainLength);
        if (runTestInExecutorThread) {
            executor.execute(new Runnable((Promise[])p, latch){
                final /* synthetic */ Promise[] val$p;
                final /* synthetic */ CountDownLatch val$latch;
                {
                    this.val$p = promiseArray;
                    this.val$latch = countDownLatch;
                }

                @Override
                public void run() {
                    DefaultPromiseTest.testStackOverFlowChainedFuturesA(executor, this.val$p, this.val$latch);
                }
            });
        } else {
            DefaultPromiseTest.testStackOverFlowChainedFuturesA(executor, p, latch);
        }
        Assert.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        for (int i = 0; i < p.length; ++i) {
            Assert.assertTrue((String)("index " + i), (boolean)p[i].isSuccess());
        }
    }

    private static void testStackOverFlowChainedFuturesB(EventExecutor executor, final Promise<Void>[] p, final CountDownLatch latch) {
        for (int i = 0; i < p.length; ++i) {
            final int finalI = i;
            p[i] = new DefaultPromise(executor);
            p[i].addListener((GenericFutureListener)new FutureListener<Void>(){

                public void operationComplete(Future<Void> future) throws Exception {
                    future.addListener((GenericFutureListener)new FutureListener<Void>(){

                        public void operationComplete(Future<Void> future) throws Exception {
                            if (finalI + 1 < p.length) {
                                p[finalI + 1].setSuccess(null);
                            }
                            latch.countDown();
                        }
                    });
                }
            });
        }
        p[0].setSuccess(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testLateListenerIsOrderedCorrectly(Throwable cause) throws InterruptedException {
        TestEventExecutor executor = new TestEventExecutor();
        try {
            final AtomicInteger state = new AtomicInteger();
            final CountDownLatch latch1 = new CountDownLatch(1);
            final CountDownLatch latch2 = new CountDownLatch(2);
            DefaultPromise promise = new DefaultPromise((EventExecutor)executor);
            promise.addListener((GenericFutureListener)new FutureListener<Void>(){

                public void operationComplete(Future<Void> future) throws Exception {
                    Assert.assertTrue((boolean)state.compareAndSet(0, 1));
                }
            });
            if (cause == null) {
                promise.setSuccess(null);
            } else {
                promise.setFailure(cause);
            }
            promise.addListener((GenericFutureListener)new FutureListener<Void>(){

                public void operationComplete(Future<Void> future) throws Exception {
                    Assert.assertTrue((boolean)state.compareAndSet(1, 2));
                    latch1.countDown();
                }
            });
            latch1.await();
            Assert.assertEquals((long)2L, (long)state.get());
            executor.execute(new Runnable((Promise)promise, state, latch2){
                final /* synthetic */ Promise val$promise;
                final /* synthetic */ AtomicInteger val$state;
                final /* synthetic */ CountDownLatch val$latch2;
                {
                    this.val$promise = promise;
                    this.val$state = atomicInteger;
                    this.val$latch2 = countDownLatch;
                }

                @Override
                public void run() {
                    this.val$promise.addListener((GenericFutureListener)new FutureListener<Void>(){

                        public void operationComplete(Future<Void> future) throws Exception {
                            Assert.assertTrue((boolean)val$state.compareAndSet(2, 3));
                            val$latch2.countDown();
                        }
                    });
                }
            });
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    Assert.assertEquals((long)3L, (long)state.get());
                    latch2.countDown();
                }
            });
            latch2.await();
        }
        finally {
            executor.shutdownGracefully(0L, 0L, TimeUnit.SECONDS).sync();
        }
    }

    private static void testPromiseListenerAddWhenComplete(Throwable cause) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        DefaultPromise promise = new DefaultPromise((EventExecutor)ImmediateEventExecutor.INSTANCE);
        promise.addListener((GenericFutureListener)new FutureListener<Void>((Promise)promise, latch){
            final /* synthetic */ Promise val$promise;
            final /* synthetic */ CountDownLatch val$latch;
            {
                this.val$promise = promise;
                this.val$latch = countDownLatch;
            }

            public void operationComplete(Future<Void> future) throws Exception {
                this.val$promise.addListener((GenericFutureListener)new FutureListener<Void>(){

                    public void operationComplete(Future<Void> future) throws Exception {
                        val$latch.countDown();
                    }
                });
            }
        });
        if (cause == null) {
            promise.setSuccess(null);
        } else {
            promise.setFailure(cause);
        }
        latch.await();
    }

    private static void testListenerNotifyLater(final int numListenersBefore) throws Exception {
        TestEventExecutor executor = new TestEventExecutor();
        int expectedCount = numListenersBefore + 2;
        final CountDownLatch latch = new CountDownLatch(expectedCount);
        FutureListener<Void> listener = new FutureListener<Void>(){

            public void operationComplete(Future<Void> future) throws Exception {
                latch.countDown();
            }
        };
        DefaultPromise promise = new DefaultPromise((EventExecutor)executor);
        executor.execute(new Runnable((Promise)promise, (FutureListener)listener){
            final /* synthetic */ Promise val$promise;
            final /* synthetic */ FutureListener val$listener;
            {
                this.val$promise = promise;
                this.val$listener = futureListener;
            }

            @Override
            public void run() {
                for (int i = 0; i < numListenersBefore; ++i) {
                    this.val$promise.addListener((GenericFutureListener)this.val$listener);
                }
                this.val$promise.setSuccess(null);
                GlobalEventExecutor.INSTANCE.execute(new Runnable(){

                    @Override
                    public void run() {
                        val$promise.addListener((GenericFutureListener)val$listener);
                    }
                });
                this.val$promise.addListener((GenericFutureListener)this.val$listener);
            }
        });
        Assert.assertTrue((String)("Should have notified " + expectedCount + " listeners"), (boolean)latch.await(5L, TimeUnit.SECONDS));
        executor.shutdownGracefully().sync();
    }

    private static RuntimeException fakeException() {
        return new RuntimeException("fake exception");
    }

    private static final class TestEventExecutor
    extends SingleThreadEventExecutor {
        TestEventExecutor() {
            super(null, Executors.defaultThreadFactory(), true);
        }

        protected void run() {
            do {
                Runnable task;
                if ((task = this.takeTask()) == null) continue;
                task.run();
                this.updateLastExecutionTime();
            } while (!this.confirmShutdown());
        }
    }
}

