/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FailedFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.SucceededFuture;
import io.netty.util.concurrent.TaskScheduler;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class AbstractEventExecutor
extends AbstractExecutorService
implements EventExecutor {
    private final Future succeededFuture = new SucceededFuture(this);
    private final TaskScheduler scheduler;

    protected AbstractEventExecutor(TaskScheduler scheduler) {
        if (scheduler == null) {
            throw new NullPointerException("scheduler");
        }
        this.scheduler = scheduler;
    }

    @Override
    public EventExecutor next() {
        return this;
    }

    @Override
    public Promise newPromise() {
        return new DefaultPromise(this);
    }

    @Override
    public Future newSucceededFuture() {
        return this.succeededFuture;
    }

    @Override
    public Future newFailedFuture(Throwable cause) {
        return new FailedFuture(this, cause);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.scheduler.schedule((EventExecutor)this, command, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.scheduler.schedule((EventExecutor)this, callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduler.scheduleAtFixedRate(this, command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.scheduler.scheduleWithFixedDelay(this, command, initialDelay, delay, unit);
    }
}

