/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.logging.InternalLogger;
import io.netty.logging.InternalLoggerFactory;
import java.io.BufferedReader;
import java.io.FileReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public final class NetworkConstants {
    public static final InetAddress LOCALHOST;
    public static final NetworkInterface LOOPBACK_IF;
    public static final int SOMAXCONN;
    private static final InternalLogger logger;

    private NetworkConstants() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        NetworkInterface loopbackInterface;
        logger = InternalLoggerFactory.getInstance(NetworkConstants.class);
        InetAddress localhost = null;
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            try {
                localhost = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
            }
            catch (UnknownHostException e1) {
                try {
                    localhost = InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1});
                }
                catch (UnknownHostException e2) {
                    logger.error("Failed to resolve localhost - Incorrect network configuration?", e2);
                }
            }
        }
        LOCALHOST = localhost;
        try {
            loopbackInterface = NetworkInterface.getByInetAddress(LOCALHOST);
        }
        catch (SocketException e) {
            loopbackInterface = null;
        }
        if (loopbackInterface == null) {
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    NetworkInterface networkInterface = interfaces.nextElement();
                    if (!networkInterface.isLoopback()) continue;
                    loopbackInterface = networkInterface;
                    break;
                }
            }
            catch (SocketException e) {
                logger.error("Failed to enumerate network interfaces", e);
            }
        }
        LOOPBACK_IF = loopbackInterface;
        int somaxconn = 3072;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader("/proc/sys/net/core/somaxconn"));
            somaxconn = Integer.parseInt(in.readLine());
        }
        catch (Exception exception) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        SOMAXCONN = somaxconn;
    }
}

