/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.buffer.UnpooledHeapByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.FixedLengthFrameDecoder;
import io.netty.util.internal.PlatformDependent;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;

public class ByteToMessageDecoderTest {
    @Test
    public void testRemoveItself() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ByteToMessageDecoder(){
            private boolean removed;

            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
                Assert.assertFalse((boolean)this.removed);
                in.readByte();
                ctx.pipeline().remove((ChannelHandler)this);
                this.removed = true;
            }
        }});
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])new byte[]{97, 98, 99});
        channel.writeInbound(new Object[]{buf.copy()});
        ByteBuf b = (ByteBuf)channel.readInbound();
        Assert.assertEquals((Object)b, (Object)buf.skipBytes(1));
        b.release();
        buf.release();
    }

    @Test
    public void testRemoveItselfWriteBuffer() {
        final ByteBuf buf = Unpooled.buffer().writeBytes(new byte[]{97, 98, 99});
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ByteToMessageDecoder(){
            private boolean removed;

            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
                Assert.assertFalse((boolean)this.removed);
                in.readByte();
                ctx.pipeline().remove((ChannelHandler)this);
                buf.writeByte(100);
                this.removed = true;
            }
        }});
        channel.writeInbound(new Object[]{buf.copy()});
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])new byte[]{98, 99});
        ByteBuf b = (ByteBuf)channel.readInbound();
        Assert.assertEquals((Object)expected, (Object)b);
        expected.release();
        buf.release();
        b.release();
    }

    @Test
    public void testInternalBufferClearReadAll() {
        ByteBuf buf = Unpooled.buffer().writeBytes(new byte[]{97});
        EmbeddedChannel channel = this.newInternalBufferTestChannel();
        Assert.assertFalse((boolean)channel.writeInbound(new Object[]{buf}));
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testInternalBufferClearReadPartly() {
        ByteBuf buf = Unpooled.buffer().writeBytes(new byte[]{97, 98});
        EmbeddedChannel channel = this.newInternalBufferTestChannel();
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{buf}));
        Assert.assertTrue((boolean)channel.finish());
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])new byte[]{98});
        ByteBuf b = (ByteBuf)channel.readInbound();
        Assert.assertEquals((Object)expected, (Object)b);
        Assert.assertNull((Object)channel.readInbound());
        expected.release();
        b.release();
    }

    private EmbeddedChannel newInternalBufferTestChannel() {
        return new EmbeddedChannel(new ChannelHandler[]{new ByteToMessageDecoder(){

            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
                ByteBuf byteBuf = this.internalBuffer();
                Assert.assertEquals((long)1L, (long)byteBuf.refCnt());
                in.readByte();
                ctx.pipeline().remove((ChannelHandler)this);
            }

            protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
                ByteToMessageDecoderTest.assertCumulationReleased(this.internalBuffer());
            }
        }});
    }

    @Test
    public void handlerRemovedWillNotReleaseBufferIfDecodeInProgress() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ByteToMessageDecoder(){

            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
                ctx.pipeline().remove((ChannelHandler)this);
                Assert.assertTrue((in.refCnt() != 0 ? 1 : 0) != 0);
            }

            protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
                ByteToMessageDecoderTest.assertCumulationReleased(this.internalBuffer());
            }
        }});
        byte[] bytes = new byte[1024];
        PlatformDependent.threadLocalRandom().nextBytes(bytes);
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])bytes)}));
        Assert.assertTrue((boolean)channel.finishAndReleaseAll());
    }

    private static void assertCumulationReleased(ByteBuf byteBuf) {
        Assert.assertTrue((String)("unexpected value: " + byteBuf), (byteBuf == null || byteBuf == Unpooled.EMPTY_BUFFER || byteBuf.refCnt() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFireChannelReadCompleteOnInactive() throws InterruptedException {
        final LinkedBlockingDeque queue = new LinkedBlockingDeque();
        ByteBuf buf = Unpooled.buffer().writeBytes(new byte[]{97, 98});
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ByteToMessageDecoder(){

            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
                int readable = in.readableBytes();
                Assert.assertTrue((readable > 0 ? 1 : 0) != 0);
                in.skipBytes(readable);
            }

            protected void decodeLast(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
                Assert.assertFalse((boolean)in.isReadable());
                out.add("data");
            }
        }, new ChannelInboundHandlerAdapter(){

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                queue.add(3);
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                queue.add(1);
            }

            public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                if (!ctx.channel().isActive()) {
                    queue.add(2);
                }
            }
        }});
        Assert.assertFalse((boolean)channel.writeInbound(new Object[]{buf}));
        channel.finish();
        Assert.assertEquals((long)1L, (long)((Integer)queue.take()).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)queue.take()).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)queue.take()).intValue());
        Assert.assertTrue((boolean)queue.isEmpty());
    }

    @Test
    public void testRemoveWhileInCallDecode() {
        final Object upgradeMessage = new Object();
        final ByteToMessageDecoder decoder = new ByteToMessageDecoder(){

            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
                Assert.assertEquals((long)97L, (long)in.readByte());
                out.add(upgradeMessage);
            }
        };
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{decoder, new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                if (msg == upgradeMessage) {
                    ctx.pipeline().remove((ChannelHandler)decoder);
                    return;
                }
                ctx.fireChannelRead(msg);
            }
        }});
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])new byte[]{97, 98, 99});
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{buf.copy()}));
        ByteBuf b = (ByteBuf)channel.readInbound();
        Assert.assertEquals((Object)b, (Object)buf.skipBytes(1));
        Assert.assertFalse((boolean)channel.finish());
        buf.release();
        b.release();
    }

    @Test
    public void testDecodeLastEmptyBuffer() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ByteToMessageDecoder(){

            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
                int readable = in.readableBytes();
                Assert.assertTrue((readable > 0 ? 1 : 0) != 0);
                out.add(in.readBytes(readable));
            }
        }});
        byte[] bytes = new byte[1024];
        PlatformDependent.threadLocalRandom().nextBytes(bytes);
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])bytes)}));
        ByteToMessageDecoderTest.assertBuffer(Unpooled.wrappedBuffer((byte[])bytes), (ByteBuf)channel.readInbound());
        Assert.assertNull((Object)channel.readInbound());
        Assert.assertFalse((boolean)channel.finish());
        Assert.assertNull((Object)channel.readInbound());
    }

    @Test
    public void testDecodeLastNonEmptyBuffer() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ByteToMessageDecoder(){
            private boolean decodeLast;

            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
                int readable = in.readableBytes();
                Assert.assertTrue((readable > 0 ? 1 : 0) != 0);
                if (!this.decodeLast && readable == 1) {
                    return;
                }
                out.add(in.readBytes(this.decodeLast ? readable : readable - 1));
            }

            protected void decodeLast(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
                Assert.assertFalse((boolean)this.decodeLast);
                this.decodeLast = true;
                super.decodeLast(ctx, in, out);
            }
        }});
        byte[] bytes = new byte[1024];
        PlatformDependent.threadLocalRandom().nextBytes(bytes);
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])bytes)}));
        ByteToMessageDecoderTest.assertBuffer(Unpooled.wrappedBuffer((byte[])bytes, (int)0, (int)(bytes.length - 1)), (ByteBuf)channel.readInbound());
        Assert.assertNull((Object)channel.readInbound());
        Assert.assertTrue((boolean)channel.finish());
        ByteToMessageDecoderTest.assertBuffer(Unpooled.wrappedBuffer((byte[])bytes, (int)(bytes.length - 1), (int)1), (ByteBuf)channel.readInbound());
        Assert.assertNull((Object)channel.readInbound());
    }

    private static void assertBuffer(ByteBuf expected, ByteBuf buffer) {
        try {
            Assert.assertEquals((Object)expected, (Object)buffer);
        }
        finally {
            buffer.release();
            expected.release();
        }
    }

    @Test
    public void testReadOnlyBuffer() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ByteToMessageDecoder(){

            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            }
        }});
        Assert.assertFalse((boolean)channel.writeInbound(new Object[]{Unpooled.buffer((int)8).writeByte(1).asReadOnly()}));
        Assert.assertFalse((boolean)channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{2})}));
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void releaseWhenMergeCumulateThrows() {
        WriteFailingByteBuf oldCumulation = new WriteFailingByteBuf(1, 64);
        oldCumulation.writeZero(1);
        ByteBuf in = Unpooled.buffer().writeZero(12);
        Throwable thrown = null;
        try {
            ByteToMessageDecoder.MERGE_CUMULATOR.cumulate((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (ByteBuf)oldCumulation, in);
        }
        catch (Throwable t) {
            thrown = t;
        }
        Assert.assertSame((Object)oldCumulation.writeError(), (Object)thrown);
        Assert.assertEquals((long)0L, (long)in.refCnt());
        Assert.assertEquals((long)1L, (long)oldCumulation.refCnt());
        oldCumulation.release();
    }

    @Test
    public void releaseWhenMergeCumulateThrowsInExpand() {
        this.releaseWhenMergeCumulateThrowsInExpand(1, true);
        this.releaseWhenMergeCumulateThrowsInExpand(2, true);
        this.releaseWhenMergeCumulateThrowsInExpand(3, false);
    }

    private void releaseWhenMergeCumulateThrowsInExpand(int untilFailure, boolean shouldFail) {
        ByteBuf oldCumulation = UnpooledByteBufAllocator.DEFAULT.heapBuffer(8, 8).writeZero(1);
        final WriteFailingByteBuf newCumulation = new WriteFailingByteBuf(untilFailure, 16);
        AbstractByteBufAllocator allocator = new AbstractByteBufAllocator(false){

            public boolean isDirectBufferPooled() {
                return false;
            }

            protected ByteBuf newHeapBuffer(int initialCapacity, int maxCapacity) {
                return newCumulation;
            }

            protected ByteBuf newDirectBuffer(int initialCapacity, int maxCapacity) {
                throw new UnsupportedOperationException();
            }
        };
        ByteBuf in = Unpooled.buffer().writeZero(12);
        Throwable thrown = null;
        try {
            ByteToMessageDecoder.MERGE_CUMULATOR.cumulate((ByteBufAllocator)allocator, oldCumulation, in);
        }
        catch (Throwable t) {
            thrown = t;
        }
        Assert.assertEquals((long)0L, (long)in.refCnt());
        if (shouldFail) {
            Assert.assertSame((Object)newCumulation.writeError(), (Object)thrown);
            Assert.assertEquals((long)1L, (long)oldCumulation.refCnt());
            oldCumulation.release();
            Assert.assertEquals((long)0L, (long)newCumulation.refCnt());
        } else {
            Assert.assertNull((Object)thrown);
            Assert.assertEquals((long)0L, (long)oldCumulation.refCnt());
            Assert.assertEquals((long)1L, (long)newCumulation.refCnt());
            newCumulation.release();
        }
    }

    @Test
    public void releaseWhenCompositeCumulateThrows() {
        final Error error = new Error();
        CompositeByteBuf cumulation = new CompositeByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, false, 64){

            public CompositeByteBuf addComponent(boolean increaseWriterIndex, ByteBuf buffer) {
                throw error;
            }

            public CompositeByteBuf addFlattenedComponents(boolean increaseWriterIndex, ByteBuf buffer) {
                throw error;
            }
        }.writeZero(1);
        ByteBuf in = Unpooled.buffer().writeZero(12);
        try {
            ByteToMessageDecoder.COMPOSITE_CUMULATOR.cumulate((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (ByteBuf)cumulation, in);
            Assert.fail();
        }
        catch (Error expected) {
            Assert.assertSame((Object)error, (Object)expected);
            Assert.assertEquals((long)0L, (long)in.refCnt());
            cumulation.release();
        }
    }

    @Test
    public void testDoesNotOverRead() {
        class ReadInterceptingHandler
        extends ChannelOutboundHandlerAdapter {
            private int readsTriggered;

            ReadInterceptingHandler() {
            }

            public void read(ChannelHandlerContext ctx) throws Exception {
                ++this.readsTriggered;
                super.read(ctx);
            }
        }
        ReadInterceptingHandler interceptor = new ReadInterceptingHandler();
        EmbeddedChannel channel = new EmbeddedChannel();
        channel.config().setAutoRead(false);
        channel.pipeline().addLast(new ChannelHandler[]{interceptor, new FixedLengthFrameDecoder(3)});
        Assert.assertEquals((long)0L, (long)interceptor.readsTriggered);
        channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{0, 1})});
        Assert.assertEquals((long)1L, (long)interceptor.readsTriggered);
        channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{2}), Unpooled.wrappedBuffer((byte[])new byte[]{3, 4, 5})});
        Assert.assertEquals((long)1L, (long)interceptor.readsTriggered);
        channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{6, 7, 8}), Unpooled.wrappedBuffer((byte[])new byte[]{9})});
        Assert.assertEquals((long)1L, (long)interceptor.readsTriggered);
        channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{10, 11}), Unpooled.wrappedBuffer((byte[])new byte[]{12})});
        Assert.assertEquals((long)1L, (long)interceptor.readsTriggered);
        channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{13})});
        Assert.assertEquals((long)2L, (long)interceptor.readsTriggered);
        channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{14})});
        Assert.assertEquals((long)2L, (long)interceptor.readsTriggered);
        for (int i = 0; i < 5; ++i) {
            ByteBuf read = (ByteBuf)channel.readInbound();
            Assert.assertEquals((long)(i * 3 + 0), (long)read.getByte(0));
            Assert.assertEquals((long)(i * 3 + 1), (long)read.getByte(1));
            Assert.assertEquals((long)(i * 3 + 2), (long)read.getByte(2));
            read.release();
        }
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testDisorder() {
        ByteToMessageDecoder decoder = new ByteToMessageDecoder(){
            int count;

            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
                out.add(in.readByte());
                if (++this.count >= 4) {
                    ctx.pipeline().remove((ChannelHandler)this);
                }
            }
        };
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{decoder});
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5})}));
        Assert.assertEquals((Object)1, (Object)channel.readInbound());
        Assert.assertEquals((Object)2, (Object)channel.readInbound());
        Assert.assertEquals((Object)3, (Object)channel.readInbound());
        Assert.assertEquals((Object)4, (Object)channel.readInbound());
        ByteBuf buffer5 = (ByteBuf)channel.readInbound();
        Assert.assertEquals((long)5L, (long)buffer5.readByte());
        Assert.assertFalse((boolean)buffer5.isReadable());
        Assert.assertTrue((boolean)buffer5.release());
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testDecodeLast() {
        final AtomicBoolean removeHandler = new AtomicBoolean();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ByteToMessageDecoder(){

            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
                if (removeHandler.get()) {
                    ctx.pipeline().remove((ChannelHandler)this);
                }
            }
        }});
        byte[] bytes = new byte[1024];
        PlatformDependent.threadLocalRandom().nextBytes(bytes);
        Assert.assertFalse((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])bytes)}));
        Assert.assertNull((Object)channel.readInbound());
        removeHandler.set(true);
        channel.pipeline().fireUserEventTriggered((Object)ChannelInputShutdownEvent.INSTANCE);
        Assert.assertTrue((boolean)channel.finish());
        ByteToMessageDecoderTest.assertBuffer(Unpooled.wrappedBuffer((byte[])bytes), (ByteBuf)channel.readInbound());
        Assert.assertNull((Object)channel.readInbound());
    }

    static class WriteFailingByteBuf
    extends UnpooledHeapByteBuf {
        private final Error error = new Error();
        private int untilFailure;

        WriteFailingByteBuf(int untilFailure, int capacity) {
            super((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, capacity, capacity);
            this.untilFailure = untilFailure;
        }

        public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
            if (--this.untilFailure <= 0) {
                throw this.error;
            }
            return super.setBytes(index, src, srcIndex, length);
        }

        Error writeError() {
            return this.error;
        }
    }
}

