/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.util.CharsetUtil;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LengthFieldPrependerTest {
    private ByteBuf msg;

    @Before
    public void setUp() throws Exception {
        this.msg = Unpooled.copiedBuffer((CharSequence)"A", (Charset)CharsetUtil.ISO_8859_1);
    }

    @Test
    public void testPrependLength() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LengthFieldPrepender(4)});
        ch.writeOutbound(new Object[]{this.msg});
        ByteBuf buf = (ByteBuf)ch.readOutbound();
        Assert.assertEquals((long)4L, (long)buf.readableBytes());
        Assert.assertEquals((long)this.msg.readableBytes(), (long)buf.readInt());
        buf.release();
        buf = (ByteBuf)ch.readOutbound();
        Assert.assertSame((Object)buf, (Object)this.msg);
        buf.release();
    }

    @Test
    public void testPrependLengthIncludesLengthFieldLength() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LengthFieldPrepender(4, true)});
        ch.writeOutbound(new Object[]{this.msg});
        ByteBuf buf = (ByteBuf)ch.readOutbound();
        Assert.assertEquals((long)4L, (long)buf.readableBytes());
        Assert.assertEquals((long)5L, (long)buf.readInt());
        buf.release();
        buf = (ByteBuf)ch.readOutbound();
        Assert.assertSame((Object)buf, (Object)this.msg);
        buf.release();
    }

    @Test
    public void testPrependAdjustedLength() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LengthFieldPrepender(4, -1)});
        ch.writeOutbound(new Object[]{this.msg});
        ByteBuf buf = (ByteBuf)ch.readOutbound();
        Assert.assertEquals((long)4L, (long)buf.readableBytes());
        Assert.assertEquals((long)(this.msg.readableBytes() - 1), (long)buf.readInt());
        buf.release();
        buf = (ByteBuf)ch.readOutbound();
        Assert.assertSame((Object)buf, (Object)this.msg);
        buf.release();
    }

    @Test
    public void testAdjustedLengthLessThanZero() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LengthFieldPrepender(4, -2)});
        try {
            ch.writeOutbound(new Object[]{this.msg});
            Assert.fail((String)(EncoderException.class.getSimpleName() + " must be raised."));
        }
        catch (EncoderException encoderException) {
            // empty catch block
        }
    }

    @Test
    public void testPrependLengthInLittleEndian() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LengthFieldPrepender(ByteOrder.LITTLE_ENDIAN, 4, 0, false)});
        ch.writeOutbound(new Object[]{this.msg});
        ByteBuf buf = (ByteBuf)ch.readOutbound();
        Assert.assertEquals((long)4L, (long)buf.readableBytes());
        byte[] writtenBytes = new byte[buf.readableBytes()];
        buf.getBytes(0, writtenBytes);
        Assert.assertEquals((long)1L, (long)writtenBytes[0]);
        Assert.assertEquals((long)0L, (long)writtenBytes[1]);
        Assert.assertEquals((long)0L, (long)writtenBytes[2]);
        Assert.assertEquals((long)0L, (long)writtenBytes[3]);
        buf.release();
        buf = (ByteBuf)ch.readOutbound();
        Assert.assertSame((Object)buf, (Object)this.msg);
        buf.release();
        Assert.assertFalse((String)"The channel must have been completely read", (boolean)ch.finish());
    }
}

