/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import com.ning.compress.lzf.LZFEncoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.AbstractDecoderTest;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.compression.LzfDecoder;
import org.junit.Test;

public class LzfDecoderTest
extends AbstractDecoderTest {
    @Override
    public void initChannel() {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new LzfDecoder()});
    }

    @Test
    public void testUnexpectedBlockIdentifier() throws Exception {
        this.expected.expect(DecompressionException.class);
        this.expected.expectMessage("unexpected block identifier");
        ByteBuf in = Unpooled.buffer();
        in.writeShort(4660);
        in.writeByte(0);
        in.writeShort(0);
        this.channel.writeInbound(new Object[]{in});
    }

    @Test
    public void testUnknownTypeOfChunk() throws Exception {
        this.expected.expect(DecompressionException.class);
        this.expected.expectMessage("unknown type of chunk");
        ByteBuf in = Unpooled.buffer();
        in.writeByte(90);
        in.writeByte(86);
        in.writeByte(255);
        in.writeInt(0);
        this.channel.writeInbound(new Object[]{in});
    }

    @Override
    protected byte[] compress(byte[] data) throws Exception {
        return LZFEncoder.encode((byte[])data);
    }
}

