/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.protobuf;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProtobufVarint32LengthFieldPrependerTest {
    private EmbeddedChannel ch;

    @Before
    public void setUp() {
        this.ch = new EmbeddedChannel(new ChannelHandler[]{new ProtobufVarint32LengthFieldPrepender()});
    }

    @Test
    public void testSize1Varint() {
        boolean size = true;
        int num = 10;
        Assert.assertThat((Object)ProtobufVarint32LengthFieldPrepender.computeRawVarint32Size((int)10), (Matcher)Is.is((Object)1));
        byte[] buf = new byte[11];
        buf[0] = 10;
        for (int i = 1; i < 11; ++i) {
            buf[i] = 1;
        }
        Assert.assertTrue((boolean)this.ch.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])buf, (int)1, (int)(buf.length - 1))}));
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])buf);
        ByteBuf actual = (ByteBuf)this.ch.readOutbound();
        Assert.assertThat((Object)expected, (Matcher)Is.is((Object)actual));
        Assert.assertFalse((boolean)this.ch.finish());
        expected.release();
        actual.release();
    }

    @Test
    public void testSize2Varint() {
        int size = 2;
        int num = 266;
        Assert.assertThat((Object)ProtobufVarint32LengthFieldPrepender.computeRawVarint32Size((int)266), (Matcher)Is.is((Object)2));
        byte[] buf = new byte[268];
        buf[0] = -118;
        buf[1] = 2;
        for (int i = 2; i < 268; ++i) {
            buf[i] = 1;
        }
        Assert.assertTrue((boolean)this.ch.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])buf, (int)2, (int)(buf.length - 2))}));
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])buf);
        ByteBuf actual = (ByteBuf)this.ch.readOutbound();
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)expected));
        Assert.assertFalse((boolean)this.ch.finish());
        expected.release();
        actual.release();
    }

    @Test
    public void testSize3Varint() {
        int size = 3;
        int num = 16384;
        Assert.assertThat((Object)ProtobufVarint32LengthFieldPrepender.computeRawVarint32Size((int)16384), (Matcher)Is.is((Object)3));
        byte[] buf = new byte[16387];
        buf[0] = -128;
        buf[1] = -128;
        buf[2] = 1;
        for (int i = 3; i < 16387; ++i) {
            buf[i] = 1;
        }
        Assert.assertTrue((boolean)this.ch.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])buf, (int)3, (int)(buf.length - 3))}));
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])buf);
        ByteBuf actual = (ByteBuf)this.ch.readOutbound();
        Assert.assertThat((Object)expected, (Matcher)Is.is((Object)actual));
        Assert.assertFalse((boolean)this.ch.finish());
        expected.release();
        actual.release();
    }

    @Test
    public void testSize4Varint() {
        int size = 4;
        int num = 0x200000;
        Assert.assertThat((Object)ProtobufVarint32LengthFieldPrepender.computeRawVarint32Size((int)0x200000), (Matcher)Is.is((Object)4));
        byte[] buf = new byte[0x200004];
        buf[0] = -128;
        buf[1] = -128;
        buf[2] = -128;
        buf[3] = 1;
        for (int i = 4; i < 0x200004; ++i) {
            buf[i] = 1;
        }
        Assert.assertTrue((boolean)this.ch.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])buf, (int)4, (int)(buf.length - 4))}));
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])buf);
        ByteBuf actual = (ByteBuf)this.ch.readOutbound();
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)expected));
        Assert.assertFalse((boolean)this.ch.finish());
        expected.release();
        actual.release();
    }

    @Test
    public void testTinyEncode() {
        byte[] b = new byte[]{4, 1, 1, 1, 1};
        Assert.assertTrue((boolean)this.ch.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])b, (int)1, (int)(b.length - 1))}));
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])b);
        ByteBuf actual = (ByteBuf)this.ch.readOutbound();
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)expected));
        Assert.assertFalse((boolean)this.ch.finish());
        expected.release();
        actual.release();
    }

    @Test
    public void testRegularDecode() {
        byte[] b = new byte[2048];
        for (int i = 2; i < 2048; ++i) {
            b[i] = 1;
        }
        b[0] = -2;
        b[1] = 15;
        Assert.assertTrue((boolean)this.ch.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])b, (int)2, (int)(b.length - 2))}));
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])b);
        ByteBuf actual = (ByteBuf)this.ch.readOutbound();
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)expected));
        Assert.assertFalse((boolean)this.ch.finish());
        expected.release();
        actual.release();
    }
}

