/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.marshalling;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.marshalling.MarshallingDecoder;
import io.netty.handler.codec.marshalling.RiverCompatibleMarshallingDecoderTest;
import org.junit.Assert;

public class RiverMarshallingDecoderTest
extends RiverCompatibleMarshallingDecoderTest {
    @Override
    protected ByteBuf input(byte[] input) {
        ByteBuf length = Unpooled.buffer((int)4);
        length.writeInt(input.length);
        return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{length, Unpooled.wrappedBuffer((byte[])input)});
    }

    @Override
    protected ChannelHandler createDecoder(int maxObjectSize) {
        return new MarshallingDecoder(this.createProvider(this.createMarshallerFactory(), this.createMarshallingConfig()), maxObjectSize);
    }

    @Override
    protected void onTooBigFrame(EmbeddedChannel ch, ByteBuf input) {
        try {
            ch.writeInbound(new Object[]{input});
            Assert.fail();
        }
        catch (CodecException e) {
            Assert.assertEquals(TooLongFrameException.class, ((Object)((Object)e)).getClass());
        }
    }
}

