/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.json;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.json.JsonObjectDecoder;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Test;

public class JsonObjectDecoderTest {
    @Test
    public void testJsonObjectOverMultipleWrites() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new JsonObjectDecoder()});
        String objectPart1 = "{ \"firstname\": \"John";
        String objectPart2 = "\" ,\n \"surname\" :";
        String objectPart3 = "\"Doe\", age:22   \n}";
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)("  \n\n  " + objectPart1), (Charset)CharsetUtil.UTF_8)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)objectPart2, (Charset)CharsetUtil.UTF_8)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)(objectPart3 + "   \n\n  \n"), (Charset)CharsetUtil.UTF_8)});
        ByteBuf res = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)(objectPart1 + objectPart2 + objectPart3), (Object)res.toString(CharsetUtil.UTF_8));
        res.release();
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testMultipleJsonObjectsOverMultipleWrites() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new JsonObjectDecoder()});
        String objectPart1 = "{\"name\":\"Jo";
        String objectPart2 = "hn\"}{\"name\":\"John\"}{\"name\":\"Jo";
        String objectPart3 = "hn\"}";
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)objectPart1, (Charset)CharsetUtil.UTF_8)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)objectPart2, (Charset)CharsetUtil.UTF_8)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)objectPart3, (Charset)CharsetUtil.UTF_8)});
        for (int i = 0; i < 3; ++i) {
            ByteBuf res = (ByteBuf)ch.readInbound();
            Assert.assertEquals((Object)"{\"name\":\"John\"}", (Object)res.toString(CharsetUtil.UTF_8));
            res.release();
        }
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testJsonArrayOverMultipleWrites() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new JsonObjectDecoder()});
        String arrayPart1 = "[{\"test";
        String arrayPart2 = "case\"  : \"\\\"}]Escaped dou\\\"ble quotes \\\" in JSON str\\\"ing\"";
        String arrayPart3 = "  }\n\n    , ";
        String arrayPart4 = "{\"testcase\" : \"Streaming string me";
        String arrayPart5 = "ssage\"} ]";
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)("   " + arrayPart1), (Charset)CharsetUtil.UTF_8)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)arrayPart2, (Charset)CharsetUtil.UTF_8)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)arrayPart3, (Charset)CharsetUtil.UTF_8)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)arrayPart4, (Charset)CharsetUtil.UTF_8)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)(arrayPart5 + "      "), (Charset)CharsetUtil.UTF_8)});
        ByteBuf res = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)(arrayPart1 + arrayPart2 + arrayPart3 + arrayPart4 + arrayPart5), (Object)res.toString(CharsetUtil.UTF_8));
        res.release();
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testStreamJsonArrayOverMultipleWrites1() {
        String[] array = new String[]{"   [{\"test", "case\"  : \"\\\"}]Escaped dou\\\"ble quotes \\\" in JSON str\\\"ing\"", "  }\n\n    , ", "{\"testcase\" : \"Streaming string me", "ssage\"} ]      "};
        String[] result = new String[]{"{\"testcase\"  : \"\\\"}]Escaped dou\\\"ble quotes \\\" in JSON str\\\"ing\"  }", "{\"testcase\" : \"Streaming string message\"}"};
        JsonObjectDecoderTest.doTestStreamJsonArrayOverMultipleWrites(2, array, result);
    }

    @Test
    public void testStreamJsonArrayOverMultipleWrites2() {
        String[] array = new String[]{"   [{\"test", "case\"  : \"\\\"}]Escaped dou\\\"ble quotes \\\" in JSON str\\\"ing\"", "  }\n\n    , {\"test", "case\" : \"Streaming string me", "ssage\"} ]      "};
        String[] result = new String[]{"{\"testcase\"  : \"\\\"}]Escaped dou\\\"ble quotes \\\" in JSON str\\\"ing\"  }", "{\"testcase\" : \"Streaming string message\"}"};
        JsonObjectDecoderTest.doTestStreamJsonArrayOverMultipleWrites(2, array, result);
    }

    @Test
    public void testStreamJsonArrayOverMultipleWrites3() {
        String[] array = new String[]{"   [{\"test", "case\"  : \"\\\"}]Escaped dou\\\"ble quotes \\\" in JSON str\\\"ing\"", "  }\n\n    , [{\"test", "case\" : \"Streaming string me", "ssage\"}] ]      "};
        String[] result = new String[]{"{\"testcase\"  : \"\\\"}]Escaped dou\\\"ble quotes \\\" in JSON str\\\"ing\"  }", "[{\"testcase\" : \"Streaming string message\"}]"};
        JsonObjectDecoderTest.doTestStreamJsonArrayOverMultipleWrites(2, array, result);
    }

    private static void doTestStreamJsonArrayOverMultipleWrites(int indexDataAvailable, String[] array, String[] result) {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new JsonObjectDecoder(true)});
        boolean dataAvailable = false;
        for (String part : array) {
            dataAvailable = ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)part, (Charset)CharsetUtil.UTF_8)});
            if (indexDataAvailable > 0) {
                Assert.assertFalse((boolean)dataAvailable);
            } else {
                Assert.assertTrue((boolean)dataAvailable);
            }
            --indexDataAvailable;
        }
        for (String part : result) {
            ByteBuf res = (ByteBuf)ch.readInbound();
            Assert.assertEquals((Object)part, (Object)res.toString(CharsetUtil.UTF_8));
            res.release();
        }
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testSingleByteStream() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new JsonObjectDecoder()});
        String json = "{\"foo\" : {\"bar\" : [{},{}]}}";
        for (byte c : json.getBytes(CharsetUtil.UTF_8)) {
            ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])new byte[]{c})});
        }
        ByteBuf res = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)json, (Object)res.toString(CharsetUtil.UTF_8));
        res.release();
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testBackslashInString1() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new JsonObjectDecoder()});
        String json = "{\"foo\" : \"bar\\\"\"}";
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)json, (Charset)CharsetUtil.UTF_8)});
        ByteBuf res = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)json, (Object)res.toString(CharsetUtil.UTF_8));
        res.release();
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testBackslashInString2() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new JsonObjectDecoder()});
        String json = "{\"foo\" : \"bar\\\\\"}";
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)json, (Charset)CharsetUtil.UTF_8)});
        ByteBuf res = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)json, (Object)res.toString(CharsetUtil.UTF_8));
        res.release();
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testBackslashInString3() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new JsonObjectDecoder()});
        String json = "{\"foo\" : \"bar\\\\\\\"\"}";
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)json, (Charset)CharsetUtil.UTF_8)});
        ByteBuf res = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)json, (Object)res.toString(CharsetUtil.UTF_8));
        res.release();
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testMultipleJsonObjectsInOneWrite() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new JsonObjectDecoder()});
        String object1 = "{\"key\" : \"value1\"}";
        String object2 = "{\"key\" : \"value2\"}";
        String object3 = "{\"key\" : \"value3\"}";
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)(object1 + object2 + object3), (Charset)CharsetUtil.UTF_8)});
        ByteBuf res = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)object1, (Object)res.toString(CharsetUtil.UTF_8));
        res.release();
        res = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)object2, (Object)res.toString(CharsetUtil.UTF_8));
        res.release();
        res = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)object3, (Object)res.toString(CharsetUtil.UTF_8));
        res.release();
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test(expected=CorruptedFrameException.class)
    public void testNonJsonContent1() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new JsonObjectDecoder()});
        try {
            ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"  b [1,2,3]", (Charset)CharsetUtil.UTF_8)});
        }
        finally {
            Assert.assertFalse((boolean)ch.finish());
        }
        Assert.fail();
    }

    @Test(expected=CorruptedFrameException.class)
    public void testNonJsonContent2() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new JsonObjectDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"  [1,2,3]  ", (Charset)CharsetUtil.UTF_8)});
        ByteBuf res = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)"[1,2,3]", (Object)res.toString(CharsetUtil.UTF_8));
        res.release();
        try {
            ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)" a {\"key\" : 10}", (Charset)CharsetUtil.UTF_8)});
        }
        finally {
            Assert.assertFalse((boolean)ch.finish());
        }
        Assert.fail();
    }

    @Test(expected=TooLongFrameException.class)
    public void testMaxObjectLength() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new JsonObjectDecoder(6)});
        try {
            ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"[2,4,5]", (Charset)CharsetUtil.UTF_8)});
        }
        finally {
            Assert.assertFalse((boolean)ch.finish());
        }
        Assert.fail();
    }

    @Test
    public void testOneJsonObjectPerWrite() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new JsonObjectDecoder()});
        String object1 = "{\"key\" : \"value1\"}";
        String object2 = "{\"key\" : \"value2\"}";
        String object3 = "{\"key\" : \"value3\"}";
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)object1, (Charset)CharsetUtil.UTF_8)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)object2, (Charset)CharsetUtil.UTF_8)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)object3, (Charset)CharsetUtil.UTF_8)});
        ByteBuf res = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)object1, (Object)res.toString(CharsetUtil.UTF_8));
        res.release();
        res = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)object2, (Object)res.toString(CharsetUtil.UTF_8));
        res.release();
        res = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)object3, (Object)res.toString(CharsetUtil.UTF_8));
        res.release();
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testSpecialJsonCharsInString() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new JsonObjectDecoder()});
        String object = "{ \"key\" : \"[]{}}\\\"}}'}\"}";
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)object, (Charset)CharsetUtil.UTF_8)});
        ByteBuf res = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)object, (Object)res.toString(CharsetUtil.UTF_8));
        res.release();
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testStreamArrayElementsSimple() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new JsonObjectDecoder(Integer.MAX_VALUE, true)});
        String array = "[  12, \"bla\"  , 13.4   \t  ,{\"key0\" : [1,2], \"key1\" : 12, \"key2\" : {}} , true, false, null, [\"bla\", {}, [1,2,3]] ]";
        String object = "{\"bla\" : \"blub\"}";
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)array, (Charset)CharsetUtil.UTF_8)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)object, (Charset)CharsetUtil.UTF_8)});
        ByteBuf res = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)"12", (Object)res.toString(CharsetUtil.UTF_8));
        res.release();
        res = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)"\"bla\"", (Object)res.toString(CharsetUtil.UTF_8));
        res.release();
        res = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)"13.4", (Object)res.toString(CharsetUtil.UTF_8));
        res.release();
        res = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)"{\"key0\" : [1,2], \"key1\" : 12, \"key2\" : {}}", (Object)res.toString(CharsetUtil.UTF_8));
        res.release();
        res = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)"true", (Object)res.toString(CharsetUtil.UTF_8));
        res.release();
        res = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)"false", (Object)res.toString(CharsetUtil.UTF_8));
        res.release();
        res = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)"null", (Object)res.toString(CharsetUtil.UTF_8));
        res.release();
        res = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)"[\"bla\", {}, [1,2,3]]", (Object)res.toString(CharsetUtil.UTF_8));
        res.release();
        res = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)object, (Object)res.toString(CharsetUtil.UTF_8));
        res.release();
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testCorruptedFrameException() {
        String part1 = "{\"a\":{\"b\":{\"c\":{ \"d\":\"27301\", \"med\":\"d\", \"path\":\"27310\"} }, \"status\":\"OK\" } }{\"";
        String part2 = "a\":{\"b\":{\"c\":{\"ory\":[{\"competi\":[{\"event\":[{\"externalI\":{\"external\":[{\"id\":\"O\"} ]";
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new JsonObjectDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"{\"a\":{\"b\":{\"c\":{ \"d\":\"27301\", \"med\":\"d\", \"path\":\"27310\"} }, \"status\":\"OK\" } }{\"", (Charset)CharsetUtil.UTF_8)});
        ByteBuf res = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)"{\"a\":{\"b\":{\"c\":{ \"d\":\"27301\", \"med\":\"d\", \"path\":\"27310\"} }, \"status\":\"OK\" } }", (Object)res.toString(CharsetUtil.UTF_8));
        res.release();
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"a\":{\"b\":{\"c\":{\"ory\":[{\"competi\":[{\"event\":[{\"externalI\":{\"external\":[{\"id\":\"O\"} ]", (Charset)CharsetUtil.UTF_8)});
        res = (ByteBuf)ch.readInbound();
        Assert.assertNull((Object)res);
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"}}]}]}]}}}}", (Charset)CharsetUtil.UTF_8)});
        res = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)"{\"a\":{\"b\":{\"c\":{\"ory\":[{\"competi\":[{\"event\":[{\"externalI\":{\"external\":[{\"id\":\"O\"} ]}}]}]}]}}}}", (Object)res.toString(CharsetUtil.UTF_8));
        res.release();
        Assert.assertFalse((boolean)ch.finish());
    }
}

