/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.handler.codec.CharSequenceValueConverter;
import io.netty.util.AsciiString;
import org.junit.Assert;
import org.junit.Test;

public class CharSequenceValueConverterTest {
    private final CharSequenceValueConverter converter = CharSequenceValueConverter.INSTANCE;

    @Test
    public void testBoolean() {
        Assert.assertTrue((boolean)this.converter.convertToBoolean(this.converter.convertBoolean(true)));
        Assert.assertFalse((boolean)this.converter.convertToBoolean(this.converter.convertBoolean(false)));
    }

    @Test
    public void testByteFromAsciiString() {
        Assert.assertEquals((long)127L, (long)this.converter.convertToByte((CharSequence)AsciiString.of((CharSequence)"127")));
    }

    @Test(expected=NumberFormatException.class)
    public void testByteFromEmptyAsciiString() {
        this.converter.convertToByte((CharSequence)AsciiString.EMPTY_STRING);
    }

    @Test
    public void testByte() {
        Assert.assertEquals((long)127L, (long)this.converter.convertToByte(this.converter.convertByte((byte)127)));
    }

    @Test
    public void testChar() {
        Assert.assertEquals((long)65535L, (long)this.converter.convertToChar(this.converter.convertChar('\uffff')));
    }

    @Test
    public void testDouble() {
        Assert.assertEquals((double)Double.MAX_VALUE, (double)this.converter.convertToDouble(this.converter.convertDouble(Double.MAX_VALUE)), (double)0.0);
    }

    @Test
    public void testFloat() {
        Assert.assertEquals((float)Float.MAX_VALUE, (float)this.converter.convertToFloat(this.converter.convertFloat(Float.MAX_VALUE)), (float)0.0f);
    }

    @Test
    public void testInt() {
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)this.converter.convertToInt(this.converter.convertInt(Integer.MAX_VALUE)));
    }

    @Test
    public void testShort() {
        Assert.assertEquals((long)32767L, (long)this.converter.convertToShort(this.converter.convertShort((short)Short.MAX_VALUE)));
    }

    @Test
    public void testLong() {
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.converter.convertToLong(this.converter.convertLong(Long.MAX_VALUE)));
    }

    @Test
    public void testTimeMillis() {
        long millis = System.currentTimeMillis() / 1000L * 1000L;
        Assert.assertEquals((long)millis, (long)this.converter.convertToTimeMillis(this.converter.convertTimeMillis(millis)));
    }
}

