/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.AbstractDecoderTest;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.compression.Lz4FrameDecoder;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import net.jpountz.lz4.LZ4BlockOutputStream;
import org.junit.Test;

public class Lz4FrameDecoderTest
extends AbstractDecoderTest {
    private static final byte[] DATA = new byte[]{76, 90, 52, 66, 108, 111, 99, 107, 22, 5, 0, 0, 0, 5, 0, 0, 0, -122, -28, 121, 15, 78, 101, 116, 116, 121, 76, 90, 52, 66, 108, 111, 99, 107, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    @Override
    public void initChannel() {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new Lz4FrameDecoder(true)});
    }

    @Test
    public void testUnexpectedBlockIdentifier() throws Exception {
        this.expected.expect(DecompressionException.class);
        this.expected.expectMessage("unexpected block identifier");
        byte[] data = Arrays.copyOf(DATA, DATA.length);
        data[1] = 0;
        ByteBuf in = Unpooled.wrappedBuffer((byte[])data);
        this.channel.writeInbound(new Object[]{in});
    }

    @Test
    public void testInvalidCompressedLength() throws Exception {
        this.expected.expect(DecompressionException.class);
        this.expected.expectMessage("invalid compressedLength");
        byte[] data = Arrays.copyOf(DATA, DATA.length);
        data[12] = -1;
        ByteBuf in = Unpooled.wrappedBuffer((byte[])data);
        this.channel.writeInbound(new Object[]{in});
    }

    @Test
    public void testInvalidDecompressedLength() throws Exception {
        this.expected.expect(DecompressionException.class);
        this.expected.expectMessage("invalid decompressedLength");
        byte[] data = Arrays.copyOf(DATA, DATA.length);
        data[16] = -1;
        ByteBuf in = Unpooled.wrappedBuffer((byte[])data);
        this.channel.writeInbound(new Object[]{in});
    }

    @Test
    public void testDecompressedAndCompressedLengthMismatch() throws Exception {
        this.expected.expect(DecompressionException.class);
        this.expected.expectMessage("mismatch");
        byte[] data = Arrays.copyOf(DATA, DATA.length);
        data[13] = 1;
        ByteBuf in = Unpooled.wrappedBuffer((byte[])data);
        this.channel.writeInbound(new Object[]{in});
    }

    @Test
    public void testUnexpectedBlockType() throws Exception {
        this.expected.expect(DecompressionException.class);
        this.expected.expectMessage("unexpected blockType");
        byte[] data = Arrays.copyOf(DATA, DATA.length);
        data[8] = 54;
        ByteBuf in = Unpooled.wrappedBuffer((byte[])data);
        this.channel.writeInbound(new Object[]{in});
    }

    @Test
    public void testMismatchingChecksum() throws Exception {
        this.expected.expect(DecompressionException.class);
        this.expected.expectMessage("mismatching checksum");
        byte[] data = Arrays.copyOf(DATA, DATA.length);
        data[17] = 1;
        ByteBuf in = Unpooled.wrappedBuffer((byte[])data);
        this.channel.writeInbound(new Object[]{in});
    }

    @Test
    public void testChecksumErrorOfLastBlock() throws Exception {
        this.expected.expect(DecompressionException.class);
        this.expected.expectMessage("checksum error");
        byte[] data = Arrays.copyOf(DATA, DATA.length);
        data[44] = 1;
        Lz4FrameDecoderTest.tryDecodeAndCatchBufLeaks(this.channel, Unpooled.wrappedBuffer((byte[])data));
    }

    @Override
    protected byte[] compress(byte[] data) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int size = 0x2000001;
        LZ4BlockOutputStream lz4Os = new LZ4BlockOutputStream((OutputStream)os, rand.nextInt(size - 64) + 64);
        lz4Os.write(data);
        lz4Os.close();
        return os.toByteArray();
    }
}

