/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.ReplayingDecoderByteBuf;
import io.netty.util.internal.PlatformDependent;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;

public class ReplayingDecoderTest {
    @Test
    public void testLineProtocol() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LineDecoder()});
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{65})});
        Assert.assertNull((Object)ch.readInbound());
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{66})});
        Assert.assertNull((Object)ch.readInbound());
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{67})});
        Assert.assertNull((Object)ch.readInbound());
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{10})});
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])new byte[]{65, 66, 67});
        ByteBuf buf2 = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)buf, (Object)buf2);
        buf.release();
        buf2.release();
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{65})});
        Assert.assertNull((Object)ch.readInbound());
        ch.finish();
        Assert.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testReplacement() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new BloatedLineDecoder()});
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{65, 66})});
        Assert.assertNull((Object)ch.readInbound());
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{67, 10})});
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])new byte[]{65, 66, 67});
        ByteBuf buf2 = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)buf, (Object)buf2);
        buf.release();
        buf2.release();
        ch.finish();
        Assert.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testSingleDecode() throws Exception {
        LineDecoder decoder = new LineDecoder();
        decoder.setSingleDecode(true);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{decoder});
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{67, 10, 66, 10})});
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])new byte[]{67});
        ByteBuf buf2 = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)buf, (Object)buf2);
        buf.release();
        buf2.release();
        Assert.assertNull((String)"Must be null as it must only decode one frame", (Object)ch.readInbound());
        ch.read();
        ch.finish();
        buf = Unpooled.wrappedBuffer((byte[])new byte[]{66});
        buf2 = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)buf, (Object)buf2);
        buf.release();
        buf2.release();
        Assert.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testRemoveItself() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ReplayingDecoder(){
            private boolean removed;

            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
                Assert.assertFalse((boolean)this.removed);
                in.readByte();
                ctx.pipeline().remove((ChannelHandler)this);
                this.removed = true;
            }
        }});
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])new byte[]{97, 98, 99});
        channel.writeInbound(new Object[]{buf.copy()});
        ByteBuf b = (ByteBuf)channel.readInbound();
        Assert.assertEquals((Object)b, (Object)buf.skipBytes(1));
        b.release();
        buf.release();
    }

    @Test
    public void testRemoveItselfWithReplayError() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ReplayingDecoder(){
            private boolean removed;

            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
                Assert.assertFalse((boolean)this.removed);
                ctx.pipeline().remove((ChannelHandler)this);
                in.readBytes(1000);
                this.removed = true;
            }
        }});
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])new byte[]{97, 98, 99});
        channel.writeInbound(new Object[]{buf.copy()});
        ByteBuf b = (ByteBuf)channel.readInbound();
        Assert.assertEquals((String)"Expect to have still all bytes in the buffer", (Object)b, (Object)buf);
        b.release();
        buf.release();
    }

    @Test
    public void testRemoveItselfWriteBuffer() {
        final ByteBuf buf = Unpooled.buffer().writeBytes(new byte[]{97, 98, 99});
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ReplayingDecoder(){
            private boolean removed;

            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
                Assert.assertFalse((boolean)this.removed);
                in.readByte();
                ctx.pipeline().remove((ChannelHandler)this);
                buf.writeByte(100);
                this.removed = true;
            }
        }});
        channel.writeInbound(new Object[]{buf.copy()});
        ByteBuf b = (ByteBuf)channel.readInbound();
        Assert.assertEquals((Object)b, (Object)Unpooled.wrappedBuffer((byte[])new byte[]{98, 99}));
        b.release();
        buf.release();
    }

    @Test
    public void testFireChannelReadCompleteOnInactive() throws InterruptedException {
        final LinkedBlockingDeque queue = new LinkedBlockingDeque();
        ByteBuf buf = Unpooled.buffer().writeBytes(new byte[]{97, 98});
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ReplayingDecoder<Integer>(){

            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
                int readable = in.readableBytes();
                Assert.assertTrue((readable > 0 ? 1 : 0) != 0);
                in.skipBytes(readable);
                out.add("data");
            }

            protected void decodeLast(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
                Assert.assertFalse((boolean)in.isReadable());
                out.add("data");
            }
        }, new ChannelInboundHandlerAdapter(){

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                queue.add(3);
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                queue.add(1);
            }

            public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                if (!ctx.channel().isActive()) {
                    queue.add(2);
                }
            }
        }});
        Assert.assertFalse((boolean)channel.writeInbound(new Object[]{buf}));
        channel.finish();
        Assert.assertEquals((long)1L, (long)((Integer)queue.take()).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)queue.take()).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)queue.take()).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)queue.take()).intValue());
        Assert.assertTrue((boolean)queue.isEmpty());
    }

    @Test
    public void testChannelInputShutdownEvent() {
        final AtomicReference error = new AtomicReference();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ReplayingDecoder<Integer>(Integer.valueOf(0)){
            private boolean decoded;

            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
                if (!(in instanceof ReplayingDecoderByteBuf)) {
                    error.set(new AssertionError((Object)("in must be of type " + ReplayingDecoderByteBuf.class + " but was " + in.getClass())));
                    return;
                }
                if (!this.decoded) {
                    this.decoded = true;
                    in.readByte();
                    this.state(1);
                } else {
                    in.skipBytes(Integer.MAX_VALUE);
                }
            }
        }});
        Assert.assertFalse((boolean)channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{0, 1})}));
        channel.pipeline().fireUserEventTriggered((Object)ChannelInputShutdownEvent.INSTANCE);
        Assert.assertFalse((boolean)channel.finishAndReleaseAll());
        Error err = (Error)error.get();
        if (err != null) {
            throw err;
        }
    }

    @Test
    public void handlerRemovedWillNotReleaseBufferIfDecodeInProgress() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ReplayingDecoder<Integer>(){

            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
                ctx.pipeline().remove((ChannelHandler)this);
                Assert.assertTrue((in.refCnt() != 0 ? 1 : 0) != 0);
            }

            protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
                ReplayingDecoderTest.assertCumulationReleased(this.internalBuffer());
            }
        }});
        byte[] bytes = new byte[1024];
        PlatformDependent.threadLocalRandom().nextBytes(bytes);
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])bytes)}));
        Assert.assertTrue((boolean)channel.finishAndReleaseAll());
    }

    private static void assertCumulationReleased(ByteBuf byteBuf) {
        Assert.assertTrue((String)("unexpected value: " + byteBuf), (byteBuf == null || byteBuf == Unpooled.EMPTY_BUFFER || byteBuf.refCnt() == 0 ? 1 : 0) != 0);
    }

    private static final class BloatedLineDecoder
    extends ChannelInboundHandlerAdapter {
        private BloatedLineDecoder() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            ctx.pipeline().replace((ChannelHandler)this, "less-bloated", (ChannelHandler)new LineDecoder());
            ctx.pipeline().fireChannelRead(msg);
        }
    }

    private static final class LineDecoder
    extends ReplayingDecoder<Void> {
        LineDecoder() {
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
            ByteBuf msg = in.readBytes(in.bytesBefore((byte)10));
            out.add(msg);
            in.skipBytes(1);
        }
    }
}

