/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.DefaultByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.MessageAggregator;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class MessageAggregatorTest {
    private static ByteBufHolder message(String string) {
        return new DefaultByteBufHolder(Unpooled.copiedBuffer((CharSequence)string, (Charset)CharsetUtil.US_ASCII));
    }

    @Test
    public void testReadFlowManagement() throws Exception {
        ReadCounter counter = new ReadCounter();
        ByteBufHolder first = MessageAggregatorTest.message("first");
        ByteBufHolder chunk = MessageAggregatorTest.message("chunk");
        ByteBufHolder last = MessageAggregatorTest.message("last");
        MockMessageAggregator agg = (MockMessageAggregator)((Object)Mockito.spy(MockMessageAggregator.class));
        Mockito.when((Object)agg.isStartMessage(first)).thenReturn((Object)true);
        Mockito.when((Object)agg.isContentMessage(chunk)).thenReturn((Object)true);
        Mockito.when((Object)agg.isContentMessage(last)).thenReturn((Object)true);
        Mockito.when((Object)agg.isLastContentMessage(last)).thenReturn((Object)true);
        EmbeddedChannel embedded = new EmbeddedChannel(new ChannelHandler[]{counter, agg});
        embedded.config().setAutoRead(false);
        Assert.assertFalse((boolean)embedded.writeInbound(new Object[]{first}));
        Assert.assertFalse((boolean)embedded.writeInbound(new Object[]{chunk}));
        Assert.assertTrue((boolean)embedded.writeInbound(new Object[]{last}));
        Assert.assertEquals((long)3L, (long)counter.value);
        DefaultByteBufHolder all = new DefaultByteBufHolder(Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{first.content().retain(), chunk.content().retain(), last.content().retain()}));
        ByteBufHolder out = (ByteBufHolder)embedded.readInbound();
        Assert.assertEquals((Object)all, (Object)out);
        Assert.assertTrue((all.release() && out.release() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)embedded.finish());
    }

    static abstract class MockMessageAggregator
    extends MessageAggregator<ByteBufHolder, ByteBufHolder, ByteBufHolder, ByteBufHolder> {
        protected MockMessageAggregator() {
            super(1024);
        }

        protected ByteBufHolder beginAggregation(ByteBufHolder start, ByteBuf content) throws Exception {
            return start.replace(content);
        }
    }

    private static final class ReadCounter
    extends ChannelOutboundHandlerAdapter {
        int value;

        private ReadCounter() {
        }

        public void read(ChannelHandlerContext ctx) throws Exception {
            ++this.value;
            ctx.read();
        }
    }
}

