/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.compression.JdkZlibDecoder;
import io.netty.handler.codec.compression.JdkZlibEncoder;
import io.netty.handler.codec.compression.ZlibDecoder;
import io.netty.handler.codec.compression.ZlibEncoder;
import io.netty.handler.codec.compression.ZlibTest;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Queue;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class JdkZlibTest
extends ZlibTest {
    @Override
    protected ZlibEncoder createEncoder(ZlibWrapper wrapper) {
        return new JdkZlibEncoder(wrapper);
    }

    @Override
    protected ZlibDecoder createDecoder(ZlibWrapper wrapper) {
        return new JdkZlibDecoder(wrapper);
    }

    @Override
    @Test(expected=DecompressionException.class)
    public void testZLIB_OR_NONE3() throws Exception {
        super.testZLIB_OR_NONE3();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcatenatedStreamsReadFirstOnly() throws IOException {
        EmbeddedChannel chDecoderGZip = new EmbeddedChannel(new ChannelHandler[]{this.createDecoder(ZlibWrapper.GZIP)});
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream("/multiple.gz"));
            Assert.assertTrue((boolean)chDecoderGZip.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])bytes)}));
            Queue messages = chDecoderGZip.inboundMessages();
            Assert.assertEquals((long)1L, (long)messages.size());
            ByteBuf msg = (ByteBuf)messages.poll();
            Assert.assertEquals((Object)"a", (Object)msg.toString(CharsetUtil.UTF_8));
            ReferenceCountUtil.release((Object)msg);
        }
        finally {
            Assert.assertFalse((boolean)chDecoderGZip.finish());
            chDecoderGZip.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcatenatedStreamsReadFully() throws IOException {
        EmbeddedChannel chDecoderGZip = new EmbeddedChannel(new ChannelHandler[]{new JdkZlibDecoder(true)});
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream("/multiple.gz"));
            Assert.assertTrue((boolean)chDecoderGZip.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])bytes)}));
            Queue messages = chDecoderGZip.inboundMessages();
            Assert.assertEquals((long)2L, (long)messages.size());
            for (String s : Arrays.asList("a", "b")) {
                ByteBuf msg = (ByteBuf)messages.poll();
                Assert.assertEquals((Object)s, (Object)msg.toString(CharsetUtil.UTF_8));
                ReferenceCountUtil.release((Object)msg);
            }
        }
        finally {
            Assert.assertFalse((boolean)chDecoderGZip.finish());
            chDecoderGZip.close();
        }
    }
}

