/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.bytes;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.bytes.ByteArrayDecoder;
import io.netty.util.internal.EmptyArrays;
import java.util.Random;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ByteArrayDecoderTest {
    private EmbeddedChannel ch;

    @Before
    public void setUp() {
        this.ch = new EmbeddedChannel(new ChannelHandler[]{new ByteArrayDecoder()});
    }

    @Test
    public void testDecode() {
        byte[] b = new byte[2048];
        new Random().nextBytes(b);
        this.ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])b)});
        Assert.assertThat((Object)((byte[])this.ch.readInbound()), (Matcher)Is.is((Object)b));
    }

    @Test
    public void testDecodeEmpty() {
        this.ch.writeInbound(new Object[]{Unpooled.EMPTY_BUFFER});
        Assert.assertThat((Object)((byte[])this.ch.readInbound()), (Matcher)Is.is((Object)EmptyArrays.EMPTY_BYTES));
    }

    @Test
    public void testDecodeOtherType() {
        String str = "Meep!";
        this.ch.writeInbound(new Object[]{str});
        Assert.assertThat((Object)this.ch.readInbound(), (Matcher)Is.is((Object)str));
    }
}

