/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.ZlibDecoder;
import io.netty.handler.codec.compression.ZlibEncoder;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.PlatformDependent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.junit.Assert;
import org.junit.Test;

public abstract class ZlibTest {
    private static final byte[] BYTES_SMALL = new byte[128];
    private static final byte[] BYTES_LARGE = new byte[0x100000];
    private static final byte[] BYTES_LARGE2 = "<!--?xml version=\"1.0\" encoding=\"ISO-8859-1\"?-->\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\"><head>\n    <title>Apache Tomcat</title>\n</head>\n\n<body>\n<h1>It works !</h1>\n\n<p>If you're seeing this page via a web browser, it means you've setup Tomcat successfully. Congratulations!</p>\n \n<p>This is the default Tomcat home page. It can be found on the local filesystem at: <code>/var/lib/tomcat7/webapps/ROOT/index.html</code></p>\n\n<p>Tomcat7 veterans might be pleased to learn that this system instance of Tomcat is installed with <code>CATALINA_HOME</code> in <code>/usr/share/tomcat7</code> and <code>CATALINA_BASE</code> in <code>/var/lib/tomcat7</code>, following the rules from <code>/usr/share/doc/tomcat7-common/RUNNING.txt.gz</code>.</p>\n\n<p>You might consider installing the following packages, if you haven't already done so:</p>\n\n<p><b>tomcat7-docs</b>: This package installs a web application that allows to browse the Tomcat 7 documentation locally. Once installed, you can access it by clicking <a href=\"docs/\">here</a>.</p>\n\n<p><b>tomcat7-examples</b>: This package installs a web application that allows to access the Tomcat 7 Servlet and JSP examples. Once installed, you can access it by clicking <a href=\"examples/\">here</a>.</p>\n\n<p><b>tomcat7-admin</b>: This package installs two web applications that can help managing this Tomcat instance. Once installed, you can access the <a href=\"manager/html\">manager webapp</a> and the <a href=\"host-manager/html\">host-manager webapp</a>.</p><p>\n\n</p><p>NOTE: For security reasons, using the manager webapp is restricted to users with role \"manager\". The host-manager webapp is restricted to users with role \"admin\". Users are defined in <code>/etc/tomcat7/tomcat-users.xml</code>.</p>\n\n\n\n</body></html>".getBytes(CharsetUtil.UTF_8);

    protected abstract ZlibEncoder createEncoder(ZlibWrapper var1);

    protected abstract ZlibDecoder createDecoder(ZlibWrapper var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGZIP2() throws Exception {
        byte[] bytes = "message".getBytes(CharsetUtil.UTF_8);
        ByteBuf data = Unpooled.wrappedBuffer((byte[])bytes);
        ByteBuf deflatedData = Unpooled.wrappedBuffer((byte[])ZlibTest.gzip(bytes));
        EmbeddedChannel chDecoderGZip = new EmbeddedChannel(new ChannelHandler[]{this.createDecoder(ZlibWrapper.GZIP)});
        try {
            chDecoderGZip.writeInbound(new Object[]{deflatedData});
            Assert.assertTrue((boolean)chDecoderGZip.finish());
            ByteBuf buf = (ByteBuf)chDecoderGZip.readInbound();
            Assert.assertEquals((Object)buf, (Object)data);
            Assert.assertNull((Object)chDecoderGZip.readInbound());
            data.release();
            buf.release();
        }
        finally {
            ZlibTest.dispose(chDecoderGZip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCompress0(ZlibWrapper encoderWrapper, ZlibWrapper decoderWrapper, ByteBuf data) throws Exception {
        EmbeddedChannel chEncoder = new EmbeddedChannel(new ChannelHandler[]{this.createEncoder(encoderWrapper)});
        EmbeddedChannel chDecoderZlib = new EmbeddedChannel(new ChannelHandler[]{this.createDecoder(decoderWrapper)});
        try {
            Object msg;
            ByteBuf buf;
            ByteBuf deflatedData;
            chEncoder.writeOutbound(new Object[]{data.retain()});
            chEncoder.flush();
            data.resetReaderIndex();
            while ((deflatedData = (ByteBuf)chEncoder.readOutbound()) != null) {
                chDecoderZlib.writeInbound(new Object[]{deflatedData});
            }
            byte[] decompressed = new byte[data.readableBytes()];
            int offset = 0;
            while ((buf = (ByteBuf)chDecoderZlib.readInbound()) != null) {
                int length = buf.readableBytes();
                buf.readBytes(decompressed, offset, length);
                buf.release();
                if ((offset += length) != decompressed.length) continue;
                break;
            }
            Assert.assertEquals((Object)data, (Object)Unpooled.wrappedBuffer((byte[])decompressed));
            Assert.assertNull((Object)chDecoderZlib.readInbound());
            Assert.assertTrue((boolean)chEncoder.finish());
            while ((msg = chEncoder.readOutbound()) != null) {
                ReferenceCountUtil.release((Object)msg);
            }
            Assert.assertFalse((boolean)chDecoderZlib.finish());
            data.release();
        }
        finally {
            ZlibTest.dispose(chEncoder);
            ZlibTest.dispose(chDecoderZlib);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCompressNone(ZlibWrapper encoderWrapper, ZlibWrapper decoderWrapper) throws Exception {
        EmbeddedChannel chEncoder = new EmbeddedChannel(new ChannelHandler[]{this.createEncoder(encoderWrapper)});
        EmbeddedChannel chDecoderZlib = new EmbeddedChannel(new ChannelHandler[]{this.createDecoder(decoderWrapper)});
        try {
            ByteBuf buf;
            ByteBuf deflatedData;
            Assert.assertTrue((boolean)chEncoder.finish());
            while ((deflatedData = (ByteBuf)chEncoder.readOutbound()) != null) {
                chDecoderZlib.writeInbound(new Object[]{deflatedData});
            }
            boolean decoded = false;
            while ((buf = (ByteBuf)chDecoderZlib.readInbound()) != null) {
                buf.release();
                decoded = true;
            }
            Assert.assertFalse((String)"should decode nothing", (boolean)decoded);
            Assert.assertFalse((boolean)chDecoderZlib.finish());
        }
        finally {
            ZlibTest.dispose(chEncoder);
            ZlibTest.dispose(chDecoderZlib);
        }
    }

    private static void dispose(EmbeddedChannel ch) {
        if (ch.finish()) {
            Object msg;
            while ((msg = ch.readInbound()) != null) {
                ReferenceCountUtil.release((Object)msg);
            }
            while ((msg = ch.readOutbound()) != null) {
                ReferenceCountUtil.release((Object)msg);
            }
        }
    }

    private void testDecompressOnly(ZlibWrapper decoderWrapper, byte[] compressed, byte[] data) throws Exception {
        ByteBuf buf;
        EmbeddedChannel chDecoder = new EmbeddedChannel(new ChannelHandler[]{this.createDecoder(decoderWrapper)});
        chDecoder.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])compressed)});
        Assert.assertTrue((boolean)chDecoder.finish());
        ByteBuf decoded = Unpooled.buffer((int)data.length);
        while ((buf = (ByteBuf)chDecoder.readInbound()) != null) {
            decoded.writeBytes(buf);
            buf.release();
        }
        Assert.assertEquals((Object)Unpooled.copiedBuffer((byte[])data), (Object)decoded);
        decoded.release();
    }

    private void testCompressSmall(ZlibWrapper encoderWrapper, ZlibWrapper decoderWrapper) throws Exception {
        this.testCompress0(encoderWrapper, decoderWrapper, Unpooled.wrappedBuffer((byte[])BYTES_SMALL));
        this.testCompress0(encoderWrapper, decoderWrapper, Unpooled.directBuffer((int)BYTES_SMALL.length).writeBytes(BYTES_SMALL));
    }

    private void testCompressLarge(ZlibWrapper encoderWrapper, ZlibWrapper decoderWrapper) throws Exception {
        this.testCompress0(encoderWrapper, decoderWrapper, Unpooled.wrappedBuffer((byte[])BYTES_LARGE));
        this.testCompress0(encoderWrapper, decoderWrapper, Unpooled.directBuffer((int)BYTES_LARGE.length).writeBytes(BYTES_LARGE));
    }

    @Test
    public void testZLIB() throws Exception {
        this.testCompressNone(ZlibWrapper.ZLIB, ZlibWrapper.ZLIB);
        this.testCompressSmall(ZlibWrapper.ZLIB, ZlibWrapper.ZLIB);
        this.testCompressLarge(ZlibWrapper.ZLIB, ZlibWrapper.ZLIB);
        this.testDecompressOnly(ZlibWrapper.ZLIB, ZlibTest.deflate(BYTES_LARGE2), BYTES_LARGE2);
    }

    @Test
    public void testNONE() throws Exception {
        this.testCompressNone(ZlibWrapper.NONE, ZlibWrapper.NONE);
        this.testCompressSmall(ZlibWrapper.NONE, ZlibWrapper.NONE);
        this.testCompressLarge(ZlibWrapper.NONE, ZlibWrapper.NONE);
    }

    @Test
    public void testGZIP() throws Exception {
        this.testCompressNone(ZlibWrapper.GZIP, ZlibWrapper.GZIP);
        this.testCompressSmall(ZlibWrapper.GZIP, ZlibWrapper.GZIP);
        this.testCompressLarge(ZlibWrapper.GZIP, ZlibWrapper.GZIP);
        this.testDecompressOnly(ZlibWrapper.GZIP, ZlibTest.gzip(BYTES_LARGE2), BYTES_LARGE2);
    }

    @Test
    public void testGZIPCompressOnly() throws Exception {
        this.testGZIPCompressOnly0(null);
        this.testGZIPCompressOnly0(EmptyArrays.EMPTY_BYTES);
        this.testGZIPCompressOnly0(BYTES_SMALL);
        this.testGZIPCompressOnly0(BYTES_LARGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testGZIPCompressOnly0(byte[] data) throws IOException {
        ByteBuf buf;
        EmbeddedChannel chEncoder = new EmbeddedChannel(new ChannelHandler[]{this.createEncoder(ZlibWrapper.GZIP)});
        if (data != null) {
            chEncoder.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])data)});
        }
        Assert.assertTrue((boolean)chEncoder.finish());
        ByteBuf encoded = Unpooled.buffer();
        while ((buf = (ByteBuf)chEncoder.readOutbound()) != null) {
            encoded.writeBytes(buf);
            buf.release();
        }
        ByteBuf decoded = Unpooled.buffer();
        GZIPInputStream stream = new GZIPInputStream((InputStream)new ByteBufInputStream(encoded, true));
        try {
            int readBytes;
            byte[] buf2 = new byte[8192];
            while ((readBytes = stream.read(buf2)) >= 0) {
                decoded.writeBytes(buf2, 0, readBytes);
            }
        }
        finally {
            stream.close();
        }
        if (data != null) {
            Assert.assertEquals((Object)Unpooled.wrappedBuffer((byte[])data), (Object)decoded);
        } else {
            Assert.assertFalse((boolean)decoded.isReadable());
        }
        decoded.release();
    }

    @Test
    public void testZLIB_OR_NONE() throws Exception {
        this.testCompressNone(ZlibWrapper.NONE, ZlibWrapper.ZLIB_OR_NONE);
        this.testCompressSmall(ZlibWrapper.NONE, ZlibWrapper.ZLIB_OR_NONE);
        this.testCompressLarge(ZlibWrapper.NONE, ZlibWrapper.ZLIB_OR_NONE);
    }

    @Test
    public void testZLIB_OR_NONE2() throws Exception {
        this.testCompressNone(ZlibWrapper.ZLIB, ZlibWrapper.ZLIB_OR_NONE);
        this.testCompressSmall(ZlibWrapper.ZLIB, ZlibWrapper.ZLIB_OR_NONE);
        this.testCompressLarge(ZlibWrapper.ZLIB, ZlibWrapper.ZLIB_OR_NONE);
    }

    @Test
    public void testZLIB_OR_NONE3() throws Exception {
        this.testCompressNone(ZlibWrapper.GZIP, ZlibWrapper.ZLIB_OR_NONE);
        this.testCompressSmall(ZlibWrapper.GZIP, ZlibWrapper.ZLIB_OR_NONE);
        this.testCompressLarge(ZlibWrapper.GZIP, ZlibWrapper.ZLIB_OR_NONE);
    }

    private static byte[] gzip(byte[] bytes) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream stream = new GZIPOutputStream(out);
        stream.write(bytes);
        stream.close();
        return out.toByteArray();
    }

    private static byte[] deflate(byte[] bytes) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DeflaterOutputStream stream = new DeflaterOutputStream(out);
        ((OutputStream)stream).write(bytes);
        ((OutputStream)stream).close();
        return out.toByteArray();
    }

    static {
        Random rand = PlatformDependent.threadLocalRandom();
        rand.nextBytes(BYTES_SMALL);
        rand.nextBytes(BYTES_LARGE);
    }
}

