/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.compression.SnappyFrameDecoder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SnappyFrameDecoderTest {
    private EmbeddedChannel channel;

    @Before
    public void initChannel() {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new SnappyFrameDecoder()});
    }

    @After
    public void tearDown() {
        Assert.assertFalse((boolean)this.channel.finishAndReleaseAll());
    }

    @Test(expected=DecompressionException.class)
    public void testReservedUnskippableChunkTypeCausesError() throws Exception {
        ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{3, 1, 0, 0, 0});
        this.channel.writeInbound(new Object[]{in});
    }

    @Test(expected=DecompressionException.class)
    public void testInvalidStreamIdentifierLength() throws Exception {
        ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{-128, 5, 0, 0, 110, 101, 116, 116, 121});
        this.channel.writeInbound(new Object[]{in});
    }

    @Test(expected=DecompressionException.class)
    public void testInvalidStreamIdentifierValue() throws Exception {
        ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{-1, 6, 0, 0, 115, 110, 101, 116, 116, 121});
        this.channel.writeInbound(new Object[]{in});
    }

    @Test(expected=DecompressionException.class)
    public void testReservedSkippableBeforeStreamIdentifier() throws Exception {
        ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{-127, 6, 0, 0, 115, 110, 101, 116, 116, 121});
        this.channel.writeInbound(new Object[]{in});
    }

    @Test(expected=DecompressionException.class)
    public void testUncompressedDataBeforeStreamIdentifier() throws Exception {
        ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{1, 5, 0, 0, 110, 101, 116, 116, 121});
        this.channel.writeInbound(new Object[]{in});
    }

    @Test(expected=DecompressionException.class)
    public void testCompressedDataBeforeStreamIdentifier() throws Exception {
        ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{0, 5, 0, 0, 110, 101, 116, 116, 121});
        this.channel.writeInbound(new Object[]{in});
    }

    @Test
    public void testReservedSkippableSkipsInput() throws Exception {
        ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89, -127, 5, 0, 0, 110, 101, 116, 116, 121});
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{in}));
        Assert.assertNull((Object)this.channel.readInbound());
        Assert.assertFalse((boolean)in.isReadable());
    }

    @Test
    public void testUncompressedDataAppendsToOut() throws Exception {
        ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89, 1, 9, 0, 0, 0, 0, 0, 0, 110, 101, 116, 116, 121});
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{in}));
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])new byte[]{110, 101, 116, 116, 121});
        ByteBuf actual = (ByteBuf)this.channel.readInbound();
        Assert.assertEquals((Object)expected, (Object)actual);
        expected.release();
        actual.release();
    }

    @Test
    public void testCompressedDataDecodesAndAppendsToOut() throws Exception {
        ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89, 0, 11, 0, 0, 0, 0, 0, 0, 5, 16, 110, 101, 116, 116, 121});
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{in}));
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])new byte[]{110, 101, 116, 116, 121});
        ByteBuf actual = (ByteBuf)this.channel.readInbound();
        Assert.assertEquals((Object)expected, (Object)actual);
        expected.release();
        actual.release();
    }

    @Test(expected=DecompressionException.class)
    public void testInvalidChecksumThrowsException() throws Exception {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new SnappyFrameDecoder(true)});
        try {
            ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89, 1, 9, 0, 0, 0, 0, 0, 0, 110, 101, 116, 116, 121});
            channel.writeInbound(new Object[]{in});
        }
        finally {
            channel.finishAndReleaseAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidChecksumDoesNotThrowException() throws Exception {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new SnappyFrameDecoder(true)});
        try {
            ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89, 1, 9, 0, 0, 111, -104, -126, -94, 110, 101, 116, 116, 121});
            Assert.assertTrue((boolean)channel.writeInbound(new Object[]{in}));
            ByteBuf expected = Unpooled.wrappedBuffer((byte[])new byte[]{110, 101, 116, 116, 121});
            ByteBuf actual = (ByteBuf)channel.readInbound();
            Assert.assertEquals((Object)expected, (Object)actual);
            expected.release();
            actual.release();
        }
        finally {
            channel.finishAndReleaseAll();
        }
    }
}

