/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.TooLongFrameException;
import org.junit.Assert;
import org.junit.Test;

public class LengthFieldBasedFrameDecoderTest {
    @Test
    public void testDiscardTooLongFrame1() {
        ByteBuf buf = Unpooled.buffer();
        buf.writeInt(32);
        for (int i = 0; i < 32; ++i) {
            buf.writeByte(i);
        }
        buf.writeInt(1);
        buf.writeByte(97);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(16, 0, 4)});
        try {
            channel.writeInbound(new Object[]{buf});
            Assert.fail();
        }
        catch (TooLongFrameException tooLongFrameException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)channel.finish());
        ByteBuf b = (ByteBuf)channel.readInbound();
        Assert.assertEquals((long)5L, (long)b.readableBytes());
        Assert.assertEquals((long)1L, (long)b.readInt());
        Assert.assertEquals((long)97L, (long)b.readByte());
        b.release();
        Assert.assertNull((Object)channel.readInbound());
        channel.finish();
    }

    @Test
    public void testDiscardTooLongFrame2() {
        ByteBuf buf = Unpooled.buffer();
        buf.writeInt(32);
        for (int i = 0; i < 32; ++i) {
            buf.writeByte(i);
        }
        buf.writeInt(1);
        buf.writeByte(97);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(16, 0, 4)});
        try {
            channel.writeInbound(new Object[]{buf.readRetainedSlice(14)});
            Assert.fail();
        }
        catch (TooLongFrameException tooLongFrameException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{buf.readRetainedSlice(buf.readableBytes())}));
        Assert.assertTrue((boolean)channel.finish());
        ByteBuf b = (ByteBuf)channel.readInbound();
        Assert.assertEquals((long)5L, (long)b.readableBytes());
        Assert.assertEquals((long)1L, (long)b.readInt());
        Assert.assertEquals((long)97L, (long)b.readByte());
        b.release();
        Assert.assertNull((Object)channel.readInbound());
        channel.finish();
        buf.release();
    }
}

