/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.handler.codec.CharSequenceValueConverter;
import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.ValueConverter;
import io.netty.util.AsciiString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;

public class DefaultHeadersTest {
    private static TestDefaultHeaders newInstance() {
        return new TestDefaultHeaders();
    }

    @Test
    public void addShouldIncreaseAndRemoveShouldDecreaseTheSize() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        Assert.assertEquals((long)0L, (long)headers.size());
        headers.add(AsciiString.of((CharSequence)"name1"), new CharSequence[]{AsciiString.of((CharSequence)"value1"), AsciiString.of((CharSequence)"value2")});
        Assert.assertEquals((long)2L, (long)headers.size());
        headers.add(AsciiString.of((CharSequence)"name2"), new CharSequence[]{AsciiString.of((CharSequence)"value3"), AsciiString.of((CharSequence)"value4")});
        Assert.assertEquals((long)4L, (long)headers.size());
        headers.add(AsciiString.of((CharSequence)"name3"), AsciiString.of((CharSequence)"value5"));
        Assert.assertEquals((long)5L, (long)headers.size());
        headers.remove(AsciiString.of((CharSequence)"name3"));
        Assert.assertEquals((long)4L, (long)headers.size());
        headers.remove(AsciiString.of((CharSequence)"name1"));
        Assert.assertEquals((long)2L, (long)headers.size());
        headers.remove(AsciiString.of((CharSequence)"name2"));
        Assert.assertEquals((long)0L, (long)headers.size());
        Assert.assertTrue((boolean)headers.isEmpty());
    }

    @Test
    public void afterClearHeadersShouldBeEmpty() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        headers.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value2"));
        Assert.assertEquals((long)2L, (long)headers.size());
        headers.clear();
        Assert.assertEquals((long)0L, (long)headers.size());
        Assert.assertTrue((boolean)headers.isEmpty());
        Assert.assertFalse((boolean)headers.contains(AsciiString.of((CharSequence)"name1")));
        Assert.assertFalse((boolean)headers.contains(AsciiString.of((CharSequence)"name2")));
    }

    @Test
    public void removingANameForASecondTimeShouldReturnFalse() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        headers.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value2"));
        Assert.assertTrue((boolean)headers.remove(AsciiString.of((CharSequence)"name2")));
        Assert.assertFalse((boolean)headers.remove(AsciiString.of((CharSequence)"name2")));
    }

    @Test
    public void multipleValuesPerNameShouldBeAllowed() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value1"));
        headers.add(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value2"));
        headers.add(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value3"));
        Assert.assertEquals((long)3L, (long)headers.size());
        List values = headers.getAll(AsciiString.of((CharSequence)"name"));
        Assert.assertEquals((long)3L, (long)values.size());
        Assert.assertTrue((boolean)values.containsAll(Arrays.asList(AsciiString.of((CharSequence)"value1"), AsciiString.of((CharSequence)"value2"), AsciiString.of((CharSequence)"value3"))));
    }

    @Test
    public void multipleValuesPerNameIteratorWithOtherNames() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        headers.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value2"));
        headers.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value4"));
        headers.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value3"));
        Assert.assertEquals((long)4L, (long)headers.size());
        ArrayList values = new ArrayList();
        Iterator itr = headers.valueIterator(AsciiString.of((CharSequence)"name1"));
        while (itr.hasNext()) {
            values.add(itr.next());
            itr.remove();
        }
        Assert.assertEquals((long)3L, (long)values.size());
        Assert.assertEquals((long)1L, (long)headers.size());
        Assert.assertFalse((boolean)headers.isEmpty());
        Assert.assertTrue((boolean)values.containsAll(Arrays.asList(AsciiString.of((CharSequence)"value1"), AsciiString.of((CharSequence)"value2"), AsciiString.of((CharSequence)"value3"))));
        itr = headers.valueIterator(AsciiString.of((CharSequence)"name1"));
        Assert.assertFalse((boolean)itr.hasNext());
        itr = headers.valueIterator(AsciiString.of((CharSequence)"name2"));
        Assert.assertTrue((boolean)itr.hasNext());
        Assert.assertEquals((Object)AsciiString.of((CharSequence)"value4"), itr.next());
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void multipleValuesPerNameIterator() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        headers.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value2"));
        Assert.assertEquals((long)2L, (long)headers.size());
        ArrayList values = new ArrayList();
        Iterator itr = headers.valueIterator(AsciiString.of((CharSequence)"name1"));
        while (itr.hasNext()) {
            values.add(itr.next());
            itr.remove();
        }
        Assert.assertEquals((long)2L, (long)values.size());
        Assert.assertEquals((long)0L, (long)headers.size());
        Assert.assertTrue((boolean)headers.isEmpty());
        Assert.assertTrue((boolean)values.containsAll(Arrays.asList(AsciiString.of((CharSequence)"value1"), AsciiString.of((CharSequence)"value2"))));
        itr = headers.valueIterator(AsciiString.of((CharSequence)"name1"));
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test(expected=IllegalStateException.class)
    public void valuesItrRemoveThrowsWhenEmpty() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        Assert.assertEquals((long)0L, (long)headers.size());
        Assert.assertTrue((boolean)headers.isEmpty());
        Iterator itr = headers.valueIterator(AsciiString.of((CharSequence)"name"));
        itr.remove();
    }

    @Test
    public void valuesItrRemoveThrowsAfterLastElement() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value1"));
        Assert.assertEquals((long)1L, (long)headers.size());
        ArrayList values = new ArrayList();
        Iterator itr = headers.valueIterator(AsciiString.of((CharSequence)"name"));
        while (itr.hasNext()) {
            values.add(itr.next());
            itr.remove();
        }
        Assert.assertEquals((long)1L, (long)values.size());
        Assert.assertEquals((long)0L, (long)headers.size());
        Assert.assertTrue((boolean)headers.isEmpty());
        Assert.assertTrue((boolean)values.contains(AsciiString.of((CharSequence)"value1")));
        try {
            itr.remove();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void multipleValuesPerNameIteratorEmpty() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        ArrayList values = new ArrayList();
        Iterator itr = headers.valueIterator(AsciiString.of((CharSequence)"name"));
        while (itr.hasNext()) {
            values.add(itr.next());
        }
        Assert.assertEquals((long)0L, (long)values.size());
        try {
            itr.next();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testContains() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.addBoolean(AsciiString.of((CharSequence)"boolean"), true);
        Assert.assertTrue((boolean)headers.containsBoolean(AsciiString.of((CharSequence)"boolean"), true));
        Assert.assertFalse((boolean)headers.containsBoolean(AsciiString.of((CharSequence)"boolean"), false));
        headers.addLong(AsciiString.of((CharSequence)"long"), Long.MAX_VALUE);
        Assert.assertTrue((boolean)headers.containsLong(AsciiString.of((CharSequence)"long"), Long.MAX_VALUE));
        Assert.assertFalse((boolean)headers.containsLong(AsciiString.of((CharSequence)"long"), Long.MIN_VALUE));
        headers.addInt(AsciiString.of((CharSequence)"int"), Integer.MIN_VALUE);
        Assert.assertTrue((boolean)headers.containsInt(AsciiString.of((CharSequence)"int"), Integer.MIN_VALUE));
        Assert.assertFalse((boolean)headers.containsInt(AsciiString.of((CharSequence)"int"), Integer.MAX_VALUE));
        headers.addShort(AsciiString.of((CharSequence)"short"), (short)Short.MAX_VALUE);
        Assert.assertTrue((boolean)headers.containsShort(AsciiString.of((CharSequence)"short"), (short)Short.MAX_VALUE));
        Assert.assertFalse((boolean)headers.containsShort(AsciiString.of((CharSequence)"short"), (short)Short.MIN_VALUE));
        headers.addChar(AsciiString.of((CharSequence)"char"), '\uffff');
        Assert.assertTrue((boolean)headers.containsChar(AsciiString.of((CharSequence)"char"), '\uffff'));
        Assert.assertFalse((boolean)headers.containsChar(AsciiString.of((CharSequence)"char"), '\u0000'));
        headers.addByte(AsciiString.of((CharSequence)"byte"), (byte)127);
        Assert.assertTrue((boolean)headers.containsByte(AsciiString.of((CharSequence)"byte"), (byte)127));
        Assert.assertFalse((boolean)headers.containsLong(AsciiString.of((CharSequence)"byte"), -128L));
        headers.addDouble(AsciiString.of((CharSequence)"double"), Double.MAX_VALUE);
        Assert.assertTrue((boolean)headers.containsDouble(AsciiString.of((CharSequence)"double"), Double.MAX_VALUE));
        Assert.assertFalse((boolean)headers.containsDouble(AsciiString.of((CharSequence)"double"), Double.MIN_VALUE));
        headers.addFloat(AsciiString.of((CharSequence)"float"), Float.MAX_VALUE);
        Assert.assertTrue((boolean)headers.containsFloat(AsciiString.of((CharSequence)"float"), Float.MAX_VALUE));
        Assert.assertFalse((boolean)headers.containsFloat(AsciiString.of((CharSequence)"float"), Float.MIN_VALUE));
        long millis = System.currentTimeMillis();
        headers.addTimeMillis(AsciiString.of((CharSequence)"millis"), millis);
        Assert.assertTrue((boolean)headers.containsTimeMillis(AsciiString.of((CharSequence)"millis"), millis));
        Assert.assertFalse((boolean)headers.containsTimeMillis(AsciiString.of((CharSequence)"millis"), 0L));
        headers.addObject(AsciiString.of((CharSequence)"object"), "Hello World");
        Assert.assertTrue((boolean)headers.containsObject(AsciiString.of((CharSequence)"object"), "Hello World"));
        Assert.assertFalse((boolean)headers.containsObject(AsciiString.of((CharSequence)"object"), ""));
        headers.add(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value"));
        Assert.assertTrue((boolean)headers.contains(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value")));
        Assert.assertFalse((boolean)headers.contains(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value1")));
    }

    @Test
    public void testCopy() throws Exception {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.addBoolean(AsciiString.of((CharSequence)"boolean"), true);
        headers.addLong(AsciiString.of((CharSequence)"long"), Long.MAX_VALUE);
        headers.addInt(AsciiString.of((CharSequence)"int"), Integer.MIN_VALUE);
        headers.addShort(AsciiString.of((CharSequence)"short"), (short)Short.MAX_VALUE);
        headers.addChar(AsciiString.of((CharSequence)"char"), '\uffff');
        headers.addByte(AsciiString.of((CharSequence)"byte"), (byte)127);
        headers.addDouble(AsciiString.of((CharSequence)"double"), Double.MAX_VALUE);
        headers.addFloat(AsciiString.of((CharSequence)"float"), Float.MAX_VALUE);
        long millis = System.currentTimeMillis();
        headers.addTimeMillis(AsciiString.of((CharSequence)"millis"), millis);
        headers.addObject(AsciiString.of((CharSequence)"object"), "Hello World");
        headers.add(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value"));
        headers = (TestDefaultHeaders)DefaultHeadersTest.newInstance().add((Headers)headers);
        Assert.assertTrue((boolean)headers.containsBoolean(AsciiString.of((CharSequence)"boolean"), true));
        Assert.assertFalse((boolean)headers.containsBoolean(AsciiString.of((CharSequence)"boolean"), false));
        Assert.assertTrue((boolean)headers.containsLong(AsciiString.of((CharSequence)"long"), Long.MAX_VALUE));
        Assert.assertFalse((boolean)headers.containsLong(AsciiString.of((CharSequence)"long"), Long.MIN_VALUE));
        Assert.assertTrue((boolean)headers.containsInt(AsciiString.of((CharSequence)"int"), Integer.MIN_VALUE));
        Assert.assertFalse((boolean)headers.containsInt(AsciiString.of((CharSequence)"int"), Integer.MAX_VALUE));
        Assert.assertTrue((boolean)headers.containsShort(AsciiString.of((CharSequence)"short"), (short)Short.MAX_VALUE));
        Assert.assertFalse((boolean)headers.containsShort(AsciiString.of((CharSequence)"short"), (short)Short.MIN_VALUE));
        Assert.assertTrue((boolean)headers.containsChar(AsciiString.of((CharSequence)"char"), '\uffff'));
        Assert.assertFalse((boolean)headers.containsChar(AsciiString.of((CharSequence)"char"), '\u0000'));
        Assert.assertTrue((boolean)headers.containsByte(AsciiString.of((CharSequence)"byte"), (byte)127));
        Assert.assertFalse((boolean)headers.containsLong(AsciiString.of((CharSequence)"byte"), -128L));
        Assert.assertTrue((boolean)headers.containsDouble(AsciiString.of((CharSequence)"double"), Double.MAX_VALUE));
        Assert.assertFalse((boolean)headers.containsDouble(AsciiString.of((CharSequence)"double"), Double.MIN_VALUE));
        Assert.assertTrue((boolean)headers.containsFloat(AsciiString.of((CharSequence)"float"), Float.MAX_VALUE));
        Assert.assertFalse((boolean)headers.containsFloat(AsciiString.of((CharSequence)"float"), Float.MIN_VALUE));
        Assert.assertTrue((boolean)headers.containsTimeMillis(AsciiString.of((CharSequence)"millis"), millis));
        Assert.assertFalse((boolean)headers.containsTimeMillis(AsciiString.of((CharSequence)"millis"), 0L));
        Assert.assertTrue((boolean)headers.containsObject(AsciiString.of((CharSequence)"object"), "Hello World"));
        Assert.assertFalse((boolean)headers.containsObject(AsciiString.of((CharSequence)"object"), ""));
        Assert.assertTrue((boolean)headers.contains(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value")));
        Assert.assertFalse((boolean)headers.contains(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value1")));
    }

    @Test
    public void canMixConvertedAndNormalValues() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value"));
        headers.addInt(AsciiString.of((CharSequence)"name"), 100);
        headers.addBoolean(AsciiString.of((CharSequence)"name"), false);
        Assert.assertEquals((long)3L, (long)headers.size());
        Assert.assertTrue((boolean)headers.contains(AsciiString.of((CharSequence)"name")));
        Assert.assertTrue((boolean)headers.contains(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value")));
        Assert.assertTrue((boolean)headers.containsInt(AsciiString.of((CharSequence)"name"), 100));
        Assert.assertTrue((boolean)headers.containsBoolean(AsciiString.of((CharSequence)"name"), false));
    }

    @Test
    public void testGetAndRemove() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        headers.add(AsciiString.of((CharSequence)"name2"), new CharSequence[]{AsciiString.of((CharSequence)"value2"), AsciiString.of((CharSequence)"value3")});
        headers.add(AsciiString.of((CharSequence)"name3"), new CharSequence[]{AsciiString.of((CharSequence)"value4"), AsciiString.of((CharSequence)"value5"), AsciiString.of((CharSequence)"value6")});
        Assert.assertEquals((Object)AsciiString.of((CharSequence)"value1"), (Object)headers.getAndRemove(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"defaultvalue")));
        Assert.assertEquals((Object)AsciiString.of((CharSequence)"value2"), (Object)headers.getAndRemove(AsciiString.of((CharSequence)"name2")));
        Assert.assertNull((Object)headers.getAndRemove(AsciiString.of((CharSequence)"name2")));
        Assert.assertEquals(Arrays.asList(AsciiString.of((CharSequence)"value4"), AsciiString.of((CharSequence)"value5"), AsciiString.of((CharSequence)"value6")), (Object)headers.getAllAndRemove(AsciiString.of((CharSequence)"name3")));
        Assert.assertEquals((long)0L, (long)headers.size());
        Assert.assertNull((Object)headers.getAndRemove(AsciiString.of((CharSequence)"noname")));
        Assert.assertEquals((Object)AsciiString.of((CharSequence)"defaultvalue"), (Object)headers.getAndRemove(AsciiString.of((CharSequence)"noname"), AsciiString.of((CharSequence)"defaultvalue")));
    }

    @Test
    public void whenNameContainsMultipleValuesGetShouldReturnTheFirst() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name1"), new CharSequence[]{AsciiString.of((CharSequence)"value1"), AsciiString.of((CharSequence)"value2")});
        Assert.assertEquals((Object)AsciiString.of((CharSequence)"value1"), (Object)headers.get(AsciiString.of((CharSequence)"name1")));
    }

    @Test
    public void getWithDefaultValueWorks() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        Assert.assertEquals((Object)AsciiString.of((CharSequence)"value1"), (Object)headers.get(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"defaultvalue")));
        Assert.assertEquals((Object)AsciiString.of((CharSequence)"defaultvalue"), (Object)headers.get(AsciiString.of((CharSequence)"noname"), AsciiString.of((CharSequence)"defaultvalue")));
    }

    @Test
    public void setShouldOverWritePreviousValue() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.set(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value1"));
        headers.set(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value2"));
        Assert.assertEquals((long)1L, (long)headers.size());
        Assert.assertEquals((long)1L, (long)headers.getAll(AsciiString.of((CharSequence)"name")).size());
        Assert.assertEquals((Object)AsciiString.of((CharSequence)"value2"), headers.getAll(AsciiString.of((CharSequence)"name")).get(0));
        Assert.assertEquals((Object)AsciiString.of((CharSequence)"value2"), (Object)headers.get(AsciiString.of((CharSequence)"name")));
    }

    @Test
    public void setAllShouldOverwriteSomeAndLeaveOthersUntouched() {
        TestDefaultHeaders h1 = DefaultHeadersTest.newInstance();
        h1.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        h1.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value2"));
        h1.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value3"));
        h1.add(AsciiString.of((CharSequence)"name3"), AsciiString.of((CharSequence)"value4"));
        TestDefaultHeaders h2 = DefaultHeadersTest.newInstance();
        h2.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value5"));
        h2.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value6"));
        h2.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value7"));
        TestDefaultHeaders expected = DefaultHeadersTest.newInstance();
        expected.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value5"));
        expected.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value6"));
        expected.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value7"));
        expected.add(AsciiString.of((CharSequence)"name3"), AsciiString.of((CharSequence)"value4"));
        h1.setAll((Headers)h2);
        Assert.assertEquals((Object)((Object)expected), (Object)((Object)h1));
    }

    @Test
    public void headersWithSameNamesAndValuesShouldBeEquivalent() {
        TestDefaultHeaders headers1 = DefaultHeadersTest.newInstance();
        headers1.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        headers1.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value2"));
        headers1.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value3"));
        TestDefaultHeaders headers2 = DefaultHeadersTest.newInstance();
        headers2.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        headers2.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value2"));
        headers2.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value3"));
        Assert.assertEquals((Object)((Object)headers1), (Object)((Object)headers2));
        Assert.assertEquals((Object)((Object)headers2), (Object)((Object)headers1));
        Assert.assertEquals((Object)((Object)headers1), (Object)((Object)headers1));
        Assert.assertEquals((Object)((Object)headers2), (Object)((Object)headers2));
        Assert.assertEquals((long)headers1.hashCode(), (long)headers2.hashCode());
        Assert.assertEquals((long)headers1.hashCode(), (long)headers1.hashCode());
        Assert.assertEquals((long)headers2.hashCode(), (long)headers2.hashCode());
    }

    @Test
    public void emptyHeadersShouldBeEqual() {
        TestDefaultHeaders headers1 = DefaultHeadersTest.newInstance();
        TestDefaultHeaders headers2 = DefaultHeadersTest.newInstance();
        Assert.assertNotSame((Object)((Object)headers1), (Object)((Object)headers2));
        Assert.assertEquals((Object)((Object)headers1), (Object)((Object)headers2));
        Assert.assertEquals((long)headers1.hashCode(), (long)headers2.hashCode());
    }

    @Test
    public void headersWithSameNamesButDifferentValuesShouldNotBeEquivalent() {
        TestDefaultHeaders headers1 = DefaultHeadersTest.newInstance();
        headers1.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        TestDefaultHeaders headers2 = DefaultHeadersTest.newInstance();
        headers1.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value2"));
        Assert.assertNotEquals((Object)((Object)headers1), (Object)((Object)headers2));
    }

    @Test
    public void subsetOfHeadersShouldNotBeEquivalent() {
        TestDefaultHeaders headers1 = DefaultHeadersTest.newInstance();
        headers1.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        headers1.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value2"));
        TestDefaultHeaders headers2 = DefaultHeadersTest.newInstance();
        headers1.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        Assert.assertNotEquals((Object)((Object)headers1), (Object)((Object)headers2));
    }

    @Test
    public void headersWithDifferentNamesAndValuesShouldNotBeEquivalent() {
        TestDefaultHeaders h1 = DefaultHeadersTest.newInstance();
        h1.set(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        TestDefaultHeaders h2 = DefaultHeadersTest.newInstance();
        h2.set(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value2"));
        Assert.assertNotEquals((Object)((Object)h1), (Object)((Object)h2));
        Assert.assertNotEquals((Object)((Object)h2), (Object)((Object)h1));
        Assert.assertEquals((Object)((Object)h1), (Object)((Object)h1));
        Assert.assertEquals((Object)((Object)h2), (Object)((Object)h2));
    }

    @Test(expected=NoSuchElementException.class)
    public void iterateEmptyHeadersShouldThrow() {
        Iterator iterator = DefaultHeadersTest.newInstance().iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.next();
    }

    @Test
    public void iteratorShouldReturnAllNameValuePairs() {
        TestDefaultHeaders headers1 = DefaultHeadersTest.newInstance();
        headers1.add(AsciiString.of((CharSequence)"name1"), new CharSequence[]{AsciiString.of((CharSequence)"value1"), AsciiString.of((CharSequence)"value2")});
        headers1.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value3"));
        headers1.add(AsciiString.of((CharSequence)"name3"), new CharSequence[]{AsciiString.of((CharSequence)"value4"), AsciiString.of((CharSequence)"value5"), AsciiString.of((CharSequence)"value6")});
        headers1.add(AsciiString.of((CharSequence)"name1"), new CharSequence[]{AsciiString.of((CharSequence)"value7"), AsciiString.of((CharSequence)"value8")});
        Assert.assertEquals((long)8L, (long)headers1.size());
        TestDefaultHeaders headers2 = DefaultHeadersTest.newInstance();
        Iterator iterator = headers1.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            headers2.add(entry.getKey(), entry.getValue());
        }
        Assert.assertEquals((Object)((Object)headers1), (Object)((Object)headers2));
    }

    @Test
    public void iteratorSetValueShouldChangeHeaderValue() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name1"), new CharSequence[]{AsciiString.of((CharSequence)"value1"), AsciiString.of((CharSequence)"value2"), AsciiString.of((CharSequence)"value3")});
        headers.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value4"));
        Assert.assertEquals((long)4L, (long)headers.size());
        Iterator iter = headers.iterator();
        while (iter.hasNext()) {
            Map.Entry header = (Map.Entry)iter.next();
            if (AsciiString.of((CharSequence)"name1").equals(header.getKey()) && AsciiString.of((CharSequence)"value2").equals(header.getValue())) {
                header.setValue(AsciiString.of((CharSequence)"updatedvalue2"));
                Assert.assertEquals((Object)AsciiString.of((CharSequence)"updatedvalue2"), header.getValue());
            }
            if (!AsciiString.of((CharSequence)"name1").equals(header.getKey()) || !AsciiString.of((CharSequence)"value3").equals(header.getValue())) continue;
            header.setValue(AsciiString.of((CharSequence)"updatedvalue3"));
            Assert.assertEquals((Object)AsciiString.of((CharSequence)"updatedvalue3"), header.getValue());
        }
        Assert.assertEquals((long)4L, (long)headers.size());
        Assert.assertTrue((boolean)headers.contains(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"updatedvalue2")));
        Assert.assertFalse((boolean)headers.contains(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value2")));
        Assert.assertTrue((boolean)headers.contains(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"updatedvalue3")));
        Assert.assertFalse((boolean)headers.contains(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value3")));
    }

    @Test
    public void testEntryEquals() {
        Map.Entry same1 = (Map.Entry)((TestDefaultHeaders)DefaultHeadersTest.newInstance().add("name", "value")).iterator().next();
        Map.Entry same2 = (Map.Entry)((TestDefaultHeaders)DefaultHeadersTest.newInstance().add("name", "value")).iterator().next();
        Assert.assertEquals((Object)same1, (Object)same2);
        Assert.assertEquals((long)same1.hashCode(), (long)same2.hashCode());
        Map.Entry nameDifferent1 = (Map.Entry)((TestDefaultHeaders)DefaultHeadersTest.newInstance().add("name1", "value")).iterator().next();
        Map.Entry nameDifferent2 = (Map.Entry)((TestDefaultHeaders)DefaultHeadersTest.newInstance().add("name2", "value")).iterator().next();
        Assert.assertNotEquals((Object)nameDifferent1, (Object)nameDifferent2);
        Assert.assertNotEquals((long)nameDifferent1.hashCode(), (long)nameDifferent2.hashCode());
        Map.Entry valueDifferent1 = (Map.Entry)((TestDefaultHeaders)DefaultHeadersTest.newInstance().add("name", "value1")).iterator().next();
        Map.Entry valueDifferent2 = (Map.Entry)((TestDefaultHeaders)DefaultHeadersTest.newInstance().add("name", "value2")).iterator().next();
        Assert.assertNotEquals((Object)valueDifferent1, (Object)valueDifferent2);
        Assert.assertNotEquals((long)valueDifferent1.hashCode(), (long)valueDifferent2.hashCode());
    }

    @Test
    public void getAllReturnsEmptyListForUnknownName() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        Assert.assertEquals((long)0L, (long)headers.getAll(AsciiString.of((CharSequence)"noname")).size());
    }

    @Test
    public void setHeadersShouldClearAndOverwrite() {
        TestDefaultHeaders headers1 = DefaultHeadersTest.newInstance();
        headers1.add(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value"));
        TestDefaultHeaders headers2 = DefaultHeadersTest.newInstance();
        headers2.add(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"newvalue"));
        headers2.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        headers1.set((Headers)headers2);
        Assert.assertEquals((Object)((Object)headers1), (Object)((Object)headers2));
    }

    @Test
    public void setAllHeadersShouldOnlyOverwriteHeaders() {
        TestDefaultHeaders headers1 = DefaultHeadersTest.newInstance();
        headers1.add(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value"));
        headers1.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        TestDefaultHeaders headers2 = DefaultHeadersTest.newInstance();
        headers2.add(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"newvalue"));
        headers2.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value2"));
        TestDefaultHeaders expected = DefaultHeadersTest.newInstance();
        expected.add(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"newvalue"));
        expected.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        expected.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value2"));
        headers1.setAll((Headers)headers2);
        Assert.assertEquals((Object)((Object)headers1), (Object)((Object)expected));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddSelf() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.add((Headers)headers);
    }

    @Test
    public void testSetSelfIsNoOp() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.add("name", "value");
        headers.set((Headers)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
    }

    @Test
    public void testToString() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        headers.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value2"));
        headers.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value3"));
        Assert.assertEquals((Object)"TestDefaultHeaders[name1: value1, name1: value2, name2: value3]", (Object)headers.toString());
        headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        headers.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value2"));
        headers.add(AsciiString.of((CharSequence)"name3"), AsciiString.of((CharSequence)"value3"));
        Assert.assertEquals((Object)"TestDefaultHeaders[name1: value1, name2: value2, name3: value3]", (Object)headers.toString());
        headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        Assert.assertEquals((Object)"TestDefaultHeaders[name1: value1]", (Object)headers.toString());
        headers = DefaultHeadersTest.newInstance();
        Assert.assertEquals((Object)"TestDefaultHeaders[]", (Object)headers.toString());
    }

    @Test
    public void testNotThrowWhenConvertFails() {
        TestDefaultHeaders headers = new TestDefaultHeaders(new ValueConverter<CharSequence>(){

            public CharSequence convertObject(Object value) {
                throw new IllegalArgumentException();
            }

            public CharSequence convertBoolean(boolean value) {
                throw new IllegalArgumentException();
            }

            public boolean convertToBoolean(CharSequence value) {
                throw new IllegalArgumentException();
            }

            public CharSequence convertByte(byte value) {
                throw new IllegalArgumentException();
            }

            public byte convertToByte(CharSequence value) {
                throw new IllegalArgumentException();
            }

            public CharSequence convertChar(char value) {
                throw new IllegalArgumentException();
            }

            public char convertToChar(CharSequence value) {
                throw new IllegalArgumentException();
            }

            public CharSequence convertShort(short value) {
                throw new IllegalArgumentException();
            }

            public short convertToShort(CharSequence value) {
                throw new IllegalArgumentException();
            }

            public CharSequence convertInt(int value) {
                throw new IllegalArgumentException();
            }

            public int convertToInt(CharSequence value) {
                throw new IllegalArgumentException();
            }

            public CharSequence convertLong(long value) {
                throw new IllegalArgumentException();
            }

            public long convertToLong(CharSequence value) {
                throw new IllegalArgumentException();
            }

            public CharSequence convertTimeMillis(long value) {
                throw new IllegalArgumentException();
            }

            public long convertToTimeMillis(CharSequence value) {
                throw new IllegalArgumentException();
            }

            public CharSequence convertFloat(float value) {
                throw new IllegalArgumentException();
            }

            public float convertToFloat(CharSequence value) {
                throw new IllegalArgumentException();
            }

            public CharSequence convertDouble(double value) {
                throw new IllegalArgumentException();
            }

            public double convertToDouble(CharSequence value) {
                throw new IllegalArgumentException();
            }
        });
        headers.set("name1", "");
        Assert.assertNull((Object)headers.getInt("name1"));
        Assert.assertEquals((long)1L, (long)headers.getInt("name1", 1));
        Assert.assertNull((Object)headers.getBoolean(""));
        Assert.assertFalse((boolean)headers.getBoolean("name1", false));
        Assert.assertNull((Object)headers.getByte("name1"));
        Assert.assertEquals((long)1L, (long)headers.getByte("name1", (byte)1));
        Assert.assertNull((Object)headers.getChar("name"));
        Assert.assertEquals((long)110L, (long)headers.getChar("name1", 'n'));
        Assert.assertNull((Object)headers.getDouble("name"));
        Assert.assertEquals((double)1.0, (double)headers.getDouble("name1", 1.0), (double)0.0);
        Assert.assertNull((Object)headers.getFloat("name"));
        Assert.assertEquals((float)Float.MAX_VALUE, (float)headers.getFloat("name1", Float.MAX_VALUE), (float)0.0f);
        Assert.assertNull((Object)headers.getLong("name"));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)headers.getLong("name1", Long.MAX_VALUE));
        Assert.assertNull((Object)headers.getShort("name"));
        Assert.assertEquals((long)32767L, (long)headers.getShort("name1", (short)Short.MAX_VALUE));
        Assert.assertNull((Object)headers.getTimeMillis("name"));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)headers.getTimeMillis("name1", Long.MAX_VALUE));
    }

    @Test
    public void testGetBooleanInvalidValue() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.set("name1", "invalid");
        headers.set("name2", new AsciiString((CharSequence)"invalid"));
        headers.set("name3", new StringBuilder("invalid"));
        Assert.assertFalse((boolean)headers.getBoolean("name1", false));
        Assert.assertFalse((boolean)headers.getBoolean("name2", false));
        Assert.assertFalse((boolean)headers.getBoolean("name3", false));
    }

    @Test
    public void testGetBooleanFalseValue() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.set("name1", "false");
        headers.set("name2", new AsciiString((CharSequence)"false"));
        headers.set("name3", new StringBuilder("false"));
        Assert.assertFalse((boolean)headers.getBoolean("name1", true));
        Assert.assertFalse((boolean)headers.getBoolean("name2", true));
        Assert.assertFalse((boolean)headers.getBoolean("name3", true));
    }

    @Test
    public void testGetBooleanTrueValue() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.set("name1", "true");
        headers.set("name2", new AsciiString((CharSequence)"true"));
        headers.set("name3", new StringBuilder("true"));
        Assert.assertTrue((boolean)headers.getBoolean("name1", false));
        Assert.assertTrue((boolean)headers.getBoolean("name2", false));
        Assert.assertTrue((boolean)headers.getBoolean("name3", false));
    }

    private static final class TestDefaultHeaders
    extends DefaultHeaders<CharSequence, CharSequence, TestDefaultHeaders> {
        TestDefaultHeaders() {
            this((ValueConverter<CharSequence>)CharSequenceValueConverter.INSTANCE);
        }

        TestDefaultHeaders(ValueConverter<CharSequence> converter) {
            super(converter);
        }
    }
}

