/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.ByteToMessageCodec;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ByteToMessageCodecTest {
    @Test(expected=IllegalStateException.class)
    public void testSharable() {
        new InvalidByteToMessageCodec();
    }

    @Test(expected=IllegalStateException.class)
    public void testSharable2() {
        new InvalidByteToMessageCodec2();
    }

    @Test
    public void testForwardPendingData() {
        ByteToMessageCodec<Integer> codec = new ByteToMessageCodec<Integer>(){

            protected void encode(ChannelHandlerContext ctx, Integer msg, ByteBuf out) throws Exception {
                out.writeInt(msg.intValue());
            }

            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
                if (in.readableBytes() >= 4) {
                    out.add(in.readInt());
                }
            }
        };
        ByteBuf buffer = Unpooled.buffer();
        buffer.writeInt(1);
        buffer.writeByte(48);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{codec});
        Assert.assertTrue((boolean)ch.writeInbound(new Object[]{buffer}));
        ch.pipeline().remove((ChannelHandler)codec);
        Assert.assertTrue((boolean)ch.finish());
        Assert.assertEquals((Object)1, (Object)ch.readInbound());
        ByteBuf buf = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)Unpooled.wrappedBuffer((byte[])new byte[]{48}), (Object)buf);
        buf.release();
        Assert.assertNull((Object)ch.readInbound());
        Assert.assertNull((Object)ch.readOutbound());
    }

    @ChannelHandler.Sharable
    private static final class InvalidByteToMessageCodec2
    extends ByteToMessageCodec<Integer> {
        InvalidByteToMessageCodec2() {
            super(Integer.class, true);
        }

        protected void encode(ChannelHandlerContext ctx, Integer msg, ByteBuf out) throws Exception {
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        }
    }

    @ChannelHandler.Sharable
    private static final class InvalidByteToMessageCodec
    extends ByteToMessageCodec<Integer> {
        InvalidByteToMessageCodec() {
            super(true);
        }

        protected void encode(ChannelHandlerContext ctx, Integer msg, ByteBuf out) throws Exception {
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        }
    }
}

