/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.handler.codec.AsciiString;
import io.netty.handler.codec.TextHeaderProcessor;
import io.netty.handler.codec.TextHeaders;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.PlatformDependent;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TimeZone;

public class DefaultTextHeaders
implements TextHeaders {
    private static final int INITIAL_VALUELIST_CAPACITY = 2;
    private static final int BUCKET_SIZE = 17;
    private final HeaderEntry[] entries = new HeaderEntry[17];
    private final HeaderEntry head;
    private final boolean ignoreCase;
    int size;

    private static int index(int hash) {
        return Math.abs(hash % 17);
    }

    public DefaultTextHeaders() {
        this(true);
    }

    public DefaultTextHeaders(boolean ignoreCase) {
        this.head.before = this.head.after = (this.head = new HeaderEntry(this));
        this.ignoreCase = ignoreCase;
    }

    protected int hashCode(CharSequence name) {
        return AsciiString.caseInsensitiveHashCode(name);
    }

    protected CharSequence convertName(CharSequence name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return name;
    }

    protected CharSequence convertValue(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (value instanceof CharSequence) {
            return (CharSequence)value;
        }
        return value.toString();
    }

    protected boolean nameEquals(CharSequence a, CharSequence b) {
        return DefaultTextHeaders.equals(a, b, this.ignoreCase);
    }

    protected boolean valueEquals(CharSequence a, CharSequence b, boolean ignoreCase) {
        return DefaultTextHeaders.equals(a, b, ignoreCase);
    }

    private static boolean equals(CharSequence a, CharSequence b, boolean ignoreCase) {
        if (a == b) {
            return true;
        }
        if (a instanceof AsciiString) {
            AsciiString aa = (AsciiString)a;
            if (ignoreCase) {
                return aa.equalsIgnoreCase(b);
            }
            return aa.equals(b);
        }
        if (b instanceof AsciiString) {
            AsciiString ab = (AsciiString)b;
            if (ignoreCase) {
                return ab.equalsIgnoreCase(a);
            }
            return ab.equals(a);
        }
        if (ignoreCase) {
            return a.toString().equalsIgnoreCase(b.toString());
        }
        return a.equals(b);
    }

    @Override
    public TextHeaders add(CharSequence name, Object value) {
        name = this.convertName(name);
        CharSequence convertedVal = this.convertValue(value);
        int h = this.hashCode(name);
        int i = DefaultTextHeaders.index(h);
        this.add0(h, i, name, convertedVal);
        return this;
    }

    @Override
    public TextHeaders add(CharSequence name, Iterable<?> values) {
        name = this.convertName(name);
        if (values == null) {
            throw new NullPointerException("values");
        }
        int h = this.hashCode(name);
        int i = DefaultTextHeaders.index(h);
        for (Object v : values) {
            if (v == null) break;
            CharSequence convertedVal = this.convertValue(v);
            this.add0(h, i, name, convertedVal);
        }
        return this;
    }

    @Override
    public TextHeaders add(CharSequence name, Object ... values) {
        name = this.convertName(name);
        if (values == null) {
            throw new NullPointerException("values");
        }
        int h = this.hashCode(name);
        int i = DefaultTextHeaders.index(h);
        for (Object v : values) {
            if (v == null) break;
            CharSequence convertedVal = this.convertValue(v);
            this.add0(h, i, name, convertedVal);
        }
        return this;
    }

    private void add0(int h, int i, CharSequence name, CharSequence value) {
        HeaderEntry newEntry;
        HeaderEntry e = this.entries[i];
        this.entries[i] = newEntry = new HeaderEntry(this, h, name, value);
        newEntry.next = e;
        newEntry.addBefore(this.head);
    }

    @Override
    public TextHeaders add(TextHeaders headers) {
        if (headers == null) {
            throw new NullPointerException("headers");
        }
        this.add0(headers);
        return this;
    }

    private void add0(TextHeaders headers) {
        if (headers.isEmpty()) {
            return;
        }
        if (headers instanceof DefaultTextHeaders) {
            DefaultTextHeaders m = (DefaultTextHeaders)headers;
            HeaderEntry e = m.head.after;
            while (e != m.head) {
                CharSequence name = e.name;
                name = this.convertName(name);
                this.add(name, (Object)this.convertValue(e.value));
                e = e.after;
            }
        } else {
            for (Map.Entry<CharSequence, CharSequence> e : headers.unconvertedEntries()) {
                this.add(e.getKey(), (Object)e.getValue());
            }
        }
    }

    @Override
    public boolean remove(CharSequence name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        int h = this.hashCode(name);
        int i = DefaultTextHeaders.index(h);
        return this.remove0(h, i, name);
    }

    private boolean remove0(int h, int i, CharSequence name) {
        HeaderEntry next;
        HeaderEntry e = this.entries[i];
        if (e == null) {
            return false;
        }
        boolean removed = false;
        while (e.hash == h && this.nameEquals(e.name, name)) {
            e.remove();
            next = e.next;
            if (next == null) {
                this.entries[i] = null;
                return true;
            }
            this.entries[i] = next;
            e = next;
            removed = true;
        }
        while ((next = e.next) != null) {
            if (next.hash == h && this.nameEquals(next.name, name)) {
                e.next = next.next;
                next.remove();
                removed = true;
                continue;
            }
            e = next;
        }
        return removed;
    }

    @Override
    public TextHeaders set(CharSequence name, Object value) {
        name = this.convertName(name);
        CharSequence convertedVal = this.convertValue(value);
        int h = this.hashCode(name);
        int i = DefaultTextHeaders.index(h);
        this.remove0(h, i, name);
        this.add0(h, i, name, convertedVal);
        return this;
    }

    @Override
    public TextHeaders set(CharSequence name, Iterable<?> values) {
        name = this.convertName(name);
        if (values == null) {
            throw new NullPointerException("values");
        }
        int h = this.hashCode(name);
        int i = DefaultTextHeaders.index(h);
        this.remove0(h, i, name);
        for (Object v : values) {
            if (v == null) break;
            CharSequence convertedVal = this.convertValue(v);
            this.add0(h, i, name, convertedVal);
        }
        return this;
    }

    @Override
    public TextHeaders set(CharSequence name, Object ... values) {
        name = this.convertName(name);
        if (values == null) {
            throw new NullPointerException("values");
        }
        int h = this.hashCode(name);
        int i = DefaultTextHeaders.index(h);
        this.remove0(h, i, name);
        for (Object v : values) {
            if (v == null) break;
            CharSequence convertedVal = this.convertValue(v);
            this.add0(h, i, name, convertedVal);
        }
        return this;
    }

    @Override
    public TextHeaders set(TextHeaders headers) {
        if (headers == null) {
            throw new NullPointerException("headers");
        }
        this.clear();
        this.add0(headers);
        return this;
    }

    @Override
    public TextHeaders clear() {
        Arrays.fill(this.entries, null);
        this.head.before = this.head.after = this.head;
        this.size = 0;
        return this;
    }

    @Override
    public CharSequence getUnconverted(CharSequence name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        int h = this.hashCode(name);
        int i = DefaultTextHeaders.index(h);
        HeaderEntry e = this.entries[i];
        CharSequence value = null;
        while (e != null) {
            if (e.hash == h && this.nameEquals(e.name, name)) {
                value = e.value;
            }
            e = e.next;
        }
        if (value != null) {
            return value;
        }
        return null;
    }

    @Override
    public String get(CharSequence name) {
        CharSequence v = this.getUnconverted(name);
        if (v == null) {
            return null;
        }
        return v.toString();
    }

    @Override
    public String get(CharSequence name, String defaultValue) {
        CharSequence v = this.getUnconverted(name);
        if (v == null) {
            return defaultValue;
        }
        return v.toString();
    }

    @Override
    public Integer getInt(CharSequence name) {
        CharSequence v = this.getUnconverted(name);
        if (v == null) {
            return null;
        }
        try {
            if (v instanceof AsciiString) {
                return ((AsciiString)v).parseInt();
            }
            return Integer.parseInt(v.toString());
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @Override
    public int getInt(CharSequence name, int defaultValue) {
        CharSequence v = this.getUnconverted(name);
        if (v == null) {
            return defaultValue;
        }
        try {
            if (v instanceof AsciiString) {
                return ((AsciiString)v).parseInt();
            }
            return Integer.parseInt(v.toString());
        }
        catch (NumberFormatException ignored) {
            return defaultValue;
        }
    }

    @Override
    public Long getLong(CharSequence name) {
        CharSequence v = this.getUnconverted(name);
        if (v == null) {
            return null;
        }
        try {
            if (v instanceof AsciiString) {
                return ((AsciiString)v).parseLong();
            }
            return Long.parseLong(v.toString());
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @Override
    public long getLong(CharSequence name, long defaultValue) {
        CharSequence v = this.getUnconverted(name);
        if (v == null) {
            return defaultValue;
        }
        try {
            if (v instanceof AsciiString) {
                return ((AsciiString)v).parseLong();
            }
            return Long.parseLong(v.toString());
        }
        catch (NumberFormatException ignored) {
            return defaultValue;
        }
    }

    @Override
    public Long getTimeMillis(CharSequence name) {
        CharSequence v = this.getUnconverted(name);
        if (v == null) {
            return null;
        }
        try {
            return HttpHeaderDateFormat.get().parse(v.toString());
        }
        catch (ParseException ignored) {
            return null;
        }
    }

    @Override
    public long getTimeMillis(CharSequence name, long defaultValue) {
        CharSequence v = this.getUnconverted(name);
        if (v == null) {
            return defaultValue;
        }
        return HttpHeaderDateFormat.get().parse(v.toString(), defaultValue);
    }

    @Override
    public CharSequence getUnconvertedAndRemove(CharSequence name) {
        HeaderEntry next;
        if (name == null) {
            throw new NullPointerException("name");
        }
        int h = this.hashCode(name);
        int i = DefaultTextHeaders.index(h);
        HeaderEntry e = this.entries[i];
        if (e == null) {
            return null;
        }
        CharSequence value = null;
        while (e.hash == h && this.nameEquals(e.name, name)) {
            value = e.value;
            e.remove();
            next = e.next;
            if (next != null) {
                this.entries[i] = next;
                e = next;
                continue;
            }
            this.entries[i] = null;
            return value;
        }
        while ((next = e.next) != null) {
            if (next.hash == h && this.nameEquals(next.name, name)) {
                value = next.value;
                e.next = next.next;
                next.remove();
                continue;
            }
            e = next;
        }
        if (value != null) {
            return value;
        }
        return null;
    }

    @Override
    public String getAndRemove(CharSequence name) {
        CharSequence v = this.getUnconvertedAndRemove(name);
        if (v == null) {
            return null;
        }
        return v.toString();
    }

    @Override
    public String getAndRemove(CharSequence name, String defaultValue) {
        CharSequence v = this.getUnconvertedAndRemove(name);
        if (v == null) {
            return defaultValue;
        }
        return v.toString();
    }

    @Override
    public Integer getIntAndRemove(CharSequence name) {
        CharSequence v = this.getUnconvertedAndRemove(name);
        if (v == null) {
            return null;
        }
        try {
            if (v instanceof AsciiString) {
                return ((AsciiString)v).parseInt();
            }
            return Integer.parseInt(v.toString());
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @Override
    public int getIntAndRemove(CharSequence name, int defaultValue) {
        CharSequence v = this.getUnconvertedAndRemove(name);
        if (v == null) {
            return defaultValue;
        }
        try {
            if (v instanceof AsciiString) {
                return ((AsciiString)v).parseInt();
            }
            return Integer.parseInt(v.toString());
        }
        catch (NumberFormatException ignored) {
            return defaultValue;
        }
    }

    @Override
    public Long getLongAndRemove(CharSequence name) {
        CharSequence v = this.getUnconvertedAndRemove(name);
        if (v == null) {
            return null;
        }
        try {
            if (v instanceof AsciiString) {
                return ((AsciiString)v).parseLong();
            }
            return Long.parseLong(v.toString());
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @Override
    public long getLongAndRemove(CharSequence name, long defaultValue) {
        CharSequence v = this.getUnconvertedAndRemove(name);
        if (v == null) {
            return defaultValue;
        }
        try {
            if (v instanceof AsciiString) {
                return ((AsciiString)v).parseLong();
            }
            return Long.parseLong(v.toString());
        }
        catch (NumberFormatException ignored) {
            return defaultValue;
        }
    }

    @Override
    public Long getTimeMillisAndRemove(CharSequence name) {
        CharSequence v = this.getUnconvertedAndRemove(name);
        if (v == null) {
            return null;
        }
        try {
            return HttpHeaderDateFormat.get().parse(v.toString());
        }
        catch (ParseException ignored) {
            return null;
        }
    }

    @Override
    public long getTimeMillisAndRemove(CharSequence name, long defaultValue) {
        CharSequence v = this.getUnconvertedAndRemove(name);
        if (v == null) {
            return defaultValue;
        }
        return HttpHeaderDateFormat.get().parse(v.toString(), defaultValue);
    }

    @Override
    public List<CharSequence> getAllUnconverted(CharSequence name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        ArrayList<CharSequence> values = new ArrayList<CharSequence>(2);
        int h = this.hashCode(name);
        int i = DefaultTextHeaders.index(h);
        HeaderEntry e = this.entries[i];
        while (e != null) {
            if (e.hash == h && this.nameEquals(e.name, name)) {
                values.add(e.getValue());
            }
            e = e.next;
        }
        Collections.reverse(values);
        return values;
    }

    @Override
    public List<String> getAll(CharSequence name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        ArrayList<String> values = new ArrayList<String>(2);
        int h = this.hashCode(name);
        int i = DefaultTextHeaders.index(h);
        HeaderEntry e = this.entries[i];
        while (e != null) {
            if (e.hash == h && this.nameEquals(e.name, name)) {
                values.add(e.getValue().toString());
            }
            e = e.next;
        }
        Collections.reverse(values);
        return values;
    }

    @Override
    public List<String> getAllAndRemove(CharSequence name) {
        HeaderEntry next;
        if (name == null) {
            throw new NullPointerException("name");
        }
        int h = this.hashCode(name);
        int i = DefaultTextHeaders.index(h);
        HeaderEntry e = this.entries[i];
        if (e == null) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>(2);
        while (e.hash == h && this.nameEquals(e.name, name)) {
            values.add(e.getValue().toString());
            e.remove();
            next = e.next;
            if (next != null) {
                this.entries[i] = next;
                e = next;
                continue;
            }
            this.entries[i] = null;
            Collections.reverse(values);
            return values;
        }
        while ((next = e.next) != null) {
            if (next.hash == h && this.nameEquals(next.name, name)) {
                values.add(next.getValue().toString());
                e.next = next.next;
                next.remove();
                continue;
            }
            e = next;
        }
        Collections.reverse(values);
        return values;
    }

    @Override
    public List<CharSequence> getAllUnconvertedAndRemove(CharSequence name) {
        HeaderEntry next;
        if (name == null) {
            throw new NullPointerException("name");
        }
        int h = this.hashCode(name);
        int i = DefaultTextHeaders.index(h);
        HeaderEntry e = this.entries[i];
        if (e == null) {
            return null;
        }
        ArrayList<CharSequence> values = new ArrayList<CharSequence>(2);
        while (e.hash == h && this.nameEquals(e.name, name)) {
            values.add(e.getValue());
            e.remove();
            next = e.next;
            if (next != null) {
                this.entries[i] = next;
                e = next;
                continue;
            }
            this.entries[i] = null;
            Collections.reverse(values);
            return values;
        }
        while ((next = e.next) != null) {
            if (next.hash == h && this.nameEquals(next.name, name)) {
                values.add(next.getValue());
                e.next = next.next;
                next.remove();
                continue;
            }
            e = next;
        }
        Collections.reverse(values);
        return values;
    }

    @Override
    public List<Map.Entry<String, String>> entries() {
        int cnt = 0;
        int size = this.size();
        Map.Entry[] all = new Map.Entry[size];
        HeaderEntry e = this.head.after;
        while (e != this.head) {
            all[cnt++] = new StringHeaderEntry(e);
            e = e.after;
        }
        assert (size == cnt);
        return Arrays.asList(all);
    }

    @Override
    public List<Map.Entry<CharSequence, CharSequence>> unconvertedEntries() {
        int cnt = 0;
        int size = this.size();
        Map.Entry[] all = new Map.Entry[size];
        HeaderEntry e = this.head.after;
        while (e != this.head) {
            all[cnt++] = e;
            e = e.after;
        }
        assert (size == cnt);
        return Arrays.asList(all);
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return new StringHeaderIterator();
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> unconvertedIterator() {
        return new HeaderIterator();
    }

    @Override
    public boolean contains(CharSequence name) {
        return this.getUnconverted(name) != null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.head.after;
    }

    @Override
    public boolean contains(CharSequence name, Object value) {
        return this.contains(name, value, false);
    }

    @Override
    public boolean contains(CharSequence name, Object value, boolean ignoreCase) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        int h = this.hashCode(name);
        int i = DefaultTextHeaders.index(h);
        CharSequence convertedVal = this.convertValue(value);
        HeaderEntry e = this.entries[i];
        while (e != null) {
            if (e.hash == h && this.nameEquals(e.name, name) && this.valueEquals(e.value, convertedVal, ignoreCase)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public Set<CharSequence> unconvertedNames() {
        LinkedHashSet<CharSequence> names = new LinkedHashSet<CharSequence>(this.size());
        HeaderEntry e = this.head.after;
        while (e != this.head) {
            names.add(e.getKey());
            e = e.after;
        }
        return names;
    }

    @Override
    public Set<String> names() {
        LinkedHashSet<String> names = new LinkedHashSet<String>(this.size());
        HeaderEntry e = this.head.after;
        while (e != this.head) {
            names.add(e.getKey().toString());
            e = e.after;
        }
        return names;
    }

    @Override
    public TextHeaders forEachEntry(TextHeaderProcessor processor) {
        HeaderEntry e = this.head.after;
        try {
            while (e != this.head && processor.process(e.getKey(), e.getValue())) {
                e = e.after;
            }
        }
        catch (Exception ex) {
            PlatformDependent.throwException((Throwable)ex);
        }
        return this;
    }

    static final class HttpHeaderDateFormat {
        private static final ParsePosition parsePos = new ParsePosition(0);
        private static final FastThreadLocal<HttpHeaderDateFormat> dateFormatThreadLocal = new FastThreadLocal<HttpHeaderDateFormat>(){

            protected HttpHeaderDateFormat initialValue() {
                return new HttpHeaderDateFormat();
            }
        };
        private final DateFormat dateFormat1 = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        private final DateFormat dateFormat2 = new SimpleDateFormat("E, dd-MMM-yy HH:mm:ss z", Locale.ENGLISH);
        private final DateFormat dateFormat3 = new SimpleDateFormat("E MMM d HH:mm:ss yyyy", Locale.ENGLISH);

        static HttpHeaderDateFormat get() {
            return (HttpHeaderDateFormat)dateFormatThreadLocal.get();
        }

        private HttpHeaderDateFormat() {
            TimeZone tz = TimeZone.getTimeZone("GMT");
            this.dateFormat1.setTimeZone(tz);
            this.dateFormat2.setTimeZone(tz);
            this.dateFormat3.setTimeZone(tz);
        }

        long parse(String text) throws ParseException {
            Date date = this.dateFormat1.parse(text, parsePos);
            if (date == null) {
                date = this.dateFormat2.parse(text, parsePos);
            }
            if (date == null) {
                date = this.dateFormat3.parse(text, parsePos);
            }
            if (date == null) {
                throw new ParseException(text, 0);
            }
            return date.getTime();
        }

        long parse(String text, long defaultValue) {
            Date date = this.dateFormat1.parse(text, parsePos);
            if (date == null) {
                date = this.dateFormat2.parse(text, parsePos);
            }
            if (date == null) {
                date = this.dateFormat3.parse(text, parsePos);
            }
            if (date == null) {
                return defaultValue;
            }
            return date.getTime();
        }
    }

    private final class StringHeaderIterator
    implements Iterator<Map.Entry<String, String>> {
        private HeaderEntry current;

        private StringHeaderIterator() {
            this.current = DefaultTextHeaders.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.current.after != DefaultTextHeaders.this.head;
        }

        @Override
        public Map.Entry<String, String> next() {
            this.current = this.current.after;
            if (this.current == DefaultTextHeaders.this.head) {
                throw new NoSuchElementException();
            }
            return new StringHeaderEntry(this.current);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class HeaderIterator
    implements Iterator<Map.Entry<CharSequence, CharSequence>> {
        private HeaderEntry current;

        private HeaderIterator() {
            this.current = DefaultTextHeaders.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.current.after != DefaultTextHeaders.this.head;
        }

        @Override
        public Map.Entry<CharSequence, CharSequence> next() {
            this.current = this.current.after;
            if (this.current == DefaultTextHeaders.this.head) {
                throw new NoSuchElementException();
            }
            return this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class StringHeaderEntry
    implements Map.Entry<String, String> {
        private final Map.Entry<CharSequence, CharSequence> entry;
        private String name;
        private String value;

        StringHeaderEntry(Map.Entry<CharSequence, CharSequence> entry) {
            this.entry = entry;
        }

        @Override
        public String getKey() {
            if (this.name == null) {
                this.name = this.entry.getKey().toString();
            }
            return this.name;
        }

        @Override
        public String getValue() {
            if (this.value == null) {
                this.value = this.entry.getValue().toString();
            }
            return this.value;
        }

        @Override
        public String setValue(String value) {
            return this.entry.setValue(value).toString();
        }

        public String toString() {
            return this.entry.toString();
        }
    }

    private static final class HeaderEntry
    implements Map.Entry<CharSequence, CharSequence> {
        private final DefaultTextHeaders parent;
        final int hash;
        final CharSequence name;
        CharSequence value;
        HeaderEntry next;
        HeaderEntry before;
        HeaderEntry after;

        HeaderEntry(DefaultTextHeaders parent, int hash, CharSequence name, CharSequence value) {
            this.parent = parent;
            this.hash = hash;
            this.name = name;
            this.value = value;
        }

        HeaderEntry(DefaultTextHeaders parent) {
            this.parent = parent;
            this.hash = -1;
            this.name = null;
            this.value = null;
        }

        void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
            --this.parent.size;
        }

        void addBefore(HeaderEntry e) {
            this.after = e;
            this.before = e.before;
            this.before.after = this;
            this.after.before = this;
            ++this.parent.size;
        }

        @Override
        public CharSequence getKey() {
            return this.name;
        }

        @Override
        public CharSequence getValue() {
            return this.value;
        }

        @Override
        public CharSequence setValue(CharSequence value) {
            if (value == null) {
                throw new NullPointerException("value");
            }
            value = this.parent.convertValue(value);
            CharSequence oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public String toString() {
            return this.name.toString() + '=' + this.value.toString();
        }
    }
}

