/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.MessageList;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.TypeParameterMatcher;

public abstract class MessageToMessageEncoder<I>
extends ChannelOutboundHandlerAdapter {
    private final TypeParameterMatcher matcher;

    protected MessageToMessageEncoder() {
        this.matcher = TypeParameterMatcher.find((Object)((Object)this), MessageToMessageEncoder.class, (String)"I");
    }

    protected MessageToMessageEncoder(Class<? extends I> outboundMessageType) {
        this.matcher = TypeParameterMatcher.get(outboundMessageType);
    }

    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return this.matcher.match(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, MessageList<Object> msgs, ChannelPromise promise) throws Exception {
        MessageList out = MessageList.newInstance();
        boolean success = false;
        try {
            int size = msgs.size();
            for (int i = 0; i < size; ++i) {
                if (ctx.isRemoved()) {
                    out.add(msgs, i, size - i);
                    break;
                }
                Object m = msgs.get(i);
                if (this.acceptOutboundMessage(m)) {
                    Object cast = m;
                    try {
                        this.encode(ctx, cast, (MessageList<Object>)out);
                        continue;
                    }
                    finally {
                        ReferenceCountUtil.release((Object)cast);
                    }
                }
                out.add(m);
            }
            success = true;
        }
        catch (CodecException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new EncoderException(t);
        }
        finally {
            msgs.recycle();
            if (success) {
                ctx.write(out, promise);
            } else {
                out.releaseAllAndRecycle();
            }
        }
    }

    protected abstract void encode(ChannelHandlerContext var1, I var2, MessageList<Object> var3) throws Exception;
}

