/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.MessageBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundByteHandlerAdapter;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.OutputMessageBuf;

public abstract class ByteToMessageDecoder
extends ChannelInboundByteHandlerAdapter {
    private volatile boolean singleDecode;
    private boolean decodeWasNull;

    public void setSingleDecode(boolean singleDecode) {
        this.singleDecode = singleDecode;
    }

    public boolean isSingleDecode() {
        return this.singleDecode;
    }

    public void inboundBufferUpdated(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        this.callDecode(ctx, in);
    }

    public void channelReadSuspended(ChannelHandlerContext ctx) throws Exception {
        if (this.decodeWasNull) {
            this.decodeWasNull = false;
            if (!ctx.channel().config().isAutoRead()) {
                ctx.read();
            }
        }
        super.channelReadSuspended(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        OutputMessageBuf out = OutputMessageBuf.get();
        try {
            ByteBuf in = ctx.inboundByteBuffer();
            if (in.isReadable()) {
                this.callDecode(ctx, in);
            }
            this.decodeLast(ctx, in, (MessageBuf<Object>)out);
        }
        catch (CodecException e) {
            throw e;
        }
        catch (Throwable cause) {
            throw new DecoderException(cause);
        }
        finally {
            if (out.drainToNextInbound(ctx)) {
                ctx.fireInboundBufferUpdated();
            }
            ctx.fireChannelInactive();
        }
    }

    protected void callDecode(ChannelHandlerContext ctx, ByteBuf in) {
        boolean wasNull = false;
        OutputMessageBuf out = OutputMessageBuf.get();
        try {
            while (in.isReadable()) {
                int outSize = out.size();
                int oldInputLength = in.readableBytes();
                this.decode(ctx, in, (MessageBuf<Object>)out);
                if (outSize == out.size()) {
                    wasNull = true;
                    if (oldInputLength != in.readableBytes()) continue;
                } else {
                    wasNull = false;
                    if (oldInputLength == in.readableBytes()) {
                        throw new IllegalStateException("decode() did not read anything but decoded a message.");
                    }
                    if (!this.isSingleDecode()) continue;
                }
                break;
            }
        }
        catch (CodecException e) {
            throw e;
        }
        catch (Throwable cause) {
            throw new DecoderException(cause);
        }
        finally {
            if (out.drainToNextInbound(ctx)) {
                this.decodeWasNull = false;
                ctx.fireInboundBufferUpdated();
            } else if (wasNull) {
                this.decodeWasNull = true;
            }
        }
    }

    protected abstract void decode(ChannelHandlerContext var1, ByteBuf var2, MessageBuf<Object> var3) throws Exception;

    protected void decodeLast(ChannelHandlerContext ctx, ByteBuf in, MessageBuf<Object> out) throws Exception {
        this.decode(ctx, in, out);
    }
}

