/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.MessageBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInboundMessageHandler;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.CodecUtil;
import io.netty.handler.codec.DecoderException;

public abstract class MessageToMessageDecoder<I, O>
extends ChannelInboundHandlerAdapter
implements ChannelInboundMessageHandler<I> {
    public MessageBuf<I> newInboundBuffer(ChannelHandlerContext ctx) throws Exception {
        return Unpooled.messageBuffer();
    }

    public void inboundBufferUpdated(ChannelHandlerContext ctx) throws Exception {
        MessageBuf in = ctx.inboundMessageBuffer();
        boolean notify = false;
        while (true) {
            try {
                Object msg;
                while ((msg = in.poll()) != null) {
                    if (!this.isDecodable(msg)) {
                        ctx.nextInboundMessageBuffer().add(msg);
                        notify = true;
                        continue;
                    }
                    Object imsg = msg;
                    O omsg = this.decode(ctx, imsg);
                    if (omsg == null || !CodecUtil.unfoldAndAdd(ctx, omsg, true)) continue;
                    notify = true;
                }
            }
            catch (Throwable t) {
                if (t instanceof CodecException) {
                    ctx.fireExceptionCaught(t);
                    continue;
                }
                ctx.fireExceptionCaught((Throwable)new DecoderException(t));
                continue;
            }
            break;
        }
        if (notify) {
            ctx.fireInboundBufferUpdated();
        }
    }

    public boolean isDecodable(Object msg) throws Exception {
        return true;
    }

    public abstract O decode(ChannelHandlerContext var1, I var2) throws Exception;
}

