/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.serialization;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class CompatibleObjectEncoder
extends MessageToByteEncoder<Object> {
    private static final AttributeKey<ObjectOutputStream> OOS = new AttributeKey(CompatibleObjectEncoder.class.getName() + ".oos");
    private final int resetInterval;
    private int writtenObjects;

    public CompatibleObjectEncoder() {
        this(16);
    }

    public CompatibleObjectEncoder(int resetInterval) {
        if (resetInterval < 0) {
            throw new IllegalArgumentException("resetInterval: " + resetInterval);
        }
        this.resetInterval = resetInterval;
    }

    protected ObjectOutputStream newObjectOutputStream(OutputStream out) throws Exception {
        return new ObjectOutputStream(out);
    }

    @Override
    public boolean isEncodable(Object msg) throws Exception {
        return msg instanceof Serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(ChannelHandlerContext ctx, Object msg, ByteBuf out) throws Exception {
        ObjectOutputStream newOos;
        Attribute oosAttr = ctx.attr(OOS);
        ObjectOutputStream oos = (ObjectOutputStream)oosAttr.get();
        if (oos == null && (newOos = (ObjectOutputStream)oosAttr.setIfAbsent((Object)(oos = this.newObjectOutputStream((OutputStream)new ByteBufOutputStream(out))))) != null) {
            oos = newOos;
        }
        ObjectOutputStream objectOutputStream = oos;
        synchronized (objectOutputStream) {
            if (this.resetInterval != 0) {
                ++this.writtenObjects;
                if (this.writtenObjects % this.resetInterval == 0) {
                    oos.reset();
                    out.discardReadBytes();
                }
            }
            oos.writeObject(msg);
            oos.flush();
        }
    }
}

