/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundByteHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.CodecUtil;
import io.netty.handler.codec.DecoderException;

public abstract class ByteToMessageDecoder<O>
extends ChannelInboundHandlerAdapter
implements ChannelInboundByteHandler {
    private ChannelHandlerContext ctx;

    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        super.beforeAdd(ctx);
    }

    public ByteBuf newInboundBuffer(ChannelHandlerContext ctx) throws Exception {
        return Unpooled.dynamicBuffer();
    }

    public void inboundBufferUpdated(ChannelHandlerContext ctx) throws Exception {
        this.callDecode(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ByteBuf in = ctx.inboundByteBuffer();
        if (in.readable()) {
            this.callDecode(ctx);
        }
        try {
            if (CodecUtil.unfoldAndAdd(ctx, this.decodeLast(ctx, in), true)) {
                in.discardReadBytes();
                ctx.fireInboundBufferUpdated();
            }
        }
        catch (Throwable t) {
            if (t instanceof CodecException) {
                ctx.fireExceptionCaught(t);
            }
            ctx.fireExceptionCaught((Throwable)new DecoderException(t));
        }
        ctx.fireChannelInactive();
    }

    protected void callDecode(ChannelHandlerContext ctx) {
        ByteBuf in = ctx.inboundByteBuffer();
        boolean decoded = false;
        block2: while (true) {
            try {
                while (true) {
                    int oldInputLength = in.readableBytes();
                    O o = this.decode(ctx, in);
                    if (o == null) {
                        if (oldInputLength != in.readableBytes()) continue;
                        break block2;
                    }
                    if (oldInputLength == in.readableBytes()) {
                        throw new IllegalStateException("decode() did not read anything but decoded a message.");
                    }
                    if (!CodecUtil.unfoldAndAdd(ctx, o, true)) break block2;
                    decoded = true;
                }
            }
            catch (Throwable t) {
                if (decoded) {
                    decoded = false;
                    in.discardReadBytes();
                    ctx.fireInboundBufferUpdated();
                }
                if (t instanceof CodecException) {
                    ctx.fireExceptionCaught(t);
                    continue;
                }
                ctx.fireExceptionCaught((Throwable)new DecoderException(t));
                continue;
            }
            break;
        }
        if (decoded) {
            in.discardReadBytes();
            ctx.fireInboundBufferUpdated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(String newHandlerName, ChannelInboundByteHandler newHandler) {
        if (!this.ctx.executor().inEventLoop()) {
            throw new IllegalStateException("not in event loop");
        }
        this.ctx.pipeline().addAfter(this.ctx.name(), newHandlerName, (ChannelHandler)newHandler);
        ByteBuf in = this.ctx.inboundByteBuffer();
        try {
            if (in.readable()) {
                this.ctx.nextInboundByteBuffer().writeBytes(this.ctx.inboundByteBuffer());
                this.ctx.fireInboundBufferUpdated();
            }
        }
        finally {
            this.ctx.pipeline().remove((ChannelHandler)this);
        }
    }

    public abstract O decode(ChannelHandlerContext var1, ByteBuf var2) throws Exception;

    public O decodeLast(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        return this.decode(ctx, in);
    }
}

