/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.stomp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.stomp.LastStompContentSubframe;
import io.netty.handler.codec.stomp.StompCommand;
import io.netty.handler.codec.stomp.StompContentSubframe;
import io.netty.handler.codec.stomp.StompHeadersSubframe;
import io.netty.handler.codec.stomp.StompSubframeDecoder;
import io.netty.util.CharsetUtil;
import java.util.Arrays;
import java.util.Collection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class StompCommandDecodeTest {
    private final String rawCommand;
    private final StompCommand expectedCommand;
    private final Boolean valid;
    private EmbeddedChannel channel;

    public StompCommandDecodeTest(String rawCommand, StompCommand expectedCommand, Boolean valid) {
        this.rawCommand = rawCommand;
        this.expectedCommand = expectedCommand;
        this.valid = valid;
    }

    @Before
    public void setUp() {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new StompSubframeDecoder(true)});
    }

    @After
    public void tearDown() {
        Assert.assertFalse((boolean)this.channel.finish());
    }

    @Test
    public void testDecodeCommand() {
        byte[] frameContent = String.format("%s\n\n\u0000", this.rawCommand).getBytes(CharsetUtil.UTF_8);
        ByteBuf incoming = Unpooled.wrappedBuffer((byte[])frameContent);
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{incoming}));
        StompHeadersSubframe frame = (StompHeadersSubframe)this.channel.readInbound();
        Assert.assertNotNull((Object)frame);
        Assert.assertEquals((Object)this.expectedCommand, (Object)frame.command());
        if (this.valid.booleanValue()) {
            Assert.assertTrue((boolean)frame.decoderResult().isSuccess());
            StompContentSubframe content = (StompContentSubframe)this.channel.readInbound();
            Assert.assertSame((Object)LastStompContentSubframe.EMPTY_LAST_CONTENT, (Object)content);
            content.release();
        } else {
            Assert.assertTrue((boolean)frame.decoderResult().isFailure());
            Assert.assertNull((Object)this.channel.readInbound());
        }
    }

    @Parameterized.Parameters(name="{index}: testDecodeCommand({0}) = {1}")
    public static Collection<Object[]> stompCommands() {
        return Arrays.asList({"STOMP", StompCommand.STOMP, true}, {"CONNECT", StompCommand.CONNECT, true}, {"SEND", StompCommand.SEND, true}, {"SUBSCRIBE", StompCommand.SUBSCRIBE, true}, {"UNSUBSCRIBE", StompCommand.UNSUBSCRIBE, true}, {"ACK", StompCommand.ACK, true}, {"NACK", StompCommand.NACK, true}, {"BEGIN", StompCommand.BEGIN, true}, {"ABORT", StompCommand.ABORT, true}, {"COMMIT", StompCommand.COMMIT, true}, {"DISCONNECT", StompCommand.DISCONNECT, true}, {"INVALID", StompCommand.UNKNOWN, false}, {"disconnect", StompCommand.UNKNOWN, false});
    }
}

