/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.stomp;

import io.netty.handler.codec.stomp.DefaultStompFrame;
import io.netty.handler.codec.stomp.StompCommand;
import io.netty.handler.codec.stomp.StompFrame;
import io.netty.handler.codec.stomp.StompHeaders;
import io.netty.util.AsciiString;
import org.junit.Assert;
import org.junit.Test;

public class DefaultStompFrameTest {
    @Test
    public void testStompFrameCopy() {
        DefaultStompFrame sourceFrame = new DefaultStompFrame(StompCommand.CONNECT);
        Assert.assertTrue((boolean)sourceFrame.headers().isEmpty());
        sourceFrame.headers().set((Object)StompHeaders.HOST, (Object)"localhost");
        StompFrame copyFrame = sourceFrame.copy();
        Assert.assertEquals((Object)sourceFrame.headers(), (Object)copyFrame.headers());
        Assert.assertEquals((Object)sourceFrame.content(), (Object)copyFrame.content());
        AsciiString copyHeaderName = new AsciiString((CharSequence)"foo");
        AsciiString copyHeaderValue = new AsciiString((CharSequence)"bar");
        copyFrame.headers().set((Object)copyHeaderName, (Object)copyHeaderValue);
        Assert.assertFalse((boolean)sourceFrame.headers().contains((Object)copyHeaderName, (Object)copyHeaderValue));
        Assert.assertTrue((boolean)copyFrame.headers().contains((Object)copyHeaderName, (Object)copyHeaderValue));
        Assert.assertEquals((long)1L, (long)sourceFrame.headers().size());
        Assert.assertEquals((long)2L, (long)copyFrame.headers().size());
        Assert.assertNotEquals((Object)sourceFrame.headers(), (Object)copyFrame.headers());
        Assert.assertTrue((boolean)sourceFrame.release());
        Assert.assertTrue((boolean)copyFrame.release());
    }
}

