/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socks;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.socks.SocksAddressType;
import io.netty.handler.codec.socks.SocksCmdRequest;
import io.netty.handler.codec.socks.SocksCmdType;
import io.netty.handler.codec.socks.SocksProtocolVersion;
import io.netty.util.CharsetUtil;
import java.net.IDN;
import java.nio.CharBuffer;
import org.junit.Assert;
import org.junit.Test;

public class SocksCmdRequestTest {
    @Test
    public void testConstructorParamsAreNotNull() {
        try {
            new SocksCmdRequest(null, SocksAddressType.UNKNOWN, "", 1);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof NullPointerException));
        }
        try {
            new SocksCmdRequest(SocksCmdType.UNKNOWN, null, "", 1);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof NullPointerException));
        }
        try {
            new SocksCmdRequest(SocksCmdType.UNKNOWN, SocksAddressType.UNKNOWN, null, 1);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof NullPointerException));
        }
    }

    @Test
    public void testIPv4CorrectAddress() {
        try {
            new SocksCmdRequest(SocksCmdType.BIND, SocksAddressType.IPv4, "54.54.1111.253", 1);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testIPv6CorrectAddress() {
        try {
            new SocksCmdRequest(SocksCmdType.BIND, SocksAddressType.IPv6, "xxx:xxx:xxx", 1);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testIDNNotExceeds255CharsLimit() {
        try {
            new SocksCmdRequest(SocksCmdType.BIND, SocksAddressType.DOMAIN, "\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae", 1);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testHostNotEncodedForUnknown() {
        String asciiHost = "xn--e1aybc.xn--p1ai";
        int port = 10000;
        SocksCmdRequest rq = new SocksCmdRequest(SocksCmdType.BIND, SocksAddressType.UNKNOWN, asciiHost, port);
        Assert.assertEquals((Object)asciiHost, (Object)rq.host());
        ByteBuf buffer = Unpooled.buffer((int)16);
        rq.encodeAsByteBuf(buffer);
        buffer.resetReaderIndex();
        Assert.assertEquals((long)SocksProtocolVersion.SOCKS5.byteValue(), (long)buffer.readByte());
        Assert.assertEquals((long)SocksCmdType.BIND.byteValue(), (long)buffer.readByte());
        Assert.assertEquals((long)0L, (long)buffer.readByte());
        Assert.assertEquals((long)SocksAddressType.UNKNOWN.byteValue(), (long)buffer.readByte());
        Assert.assertFalse((boolean)buffer.isReadable());
        buffer.release();
    }

    @Test
    public void testIDNEncodeToAsciiForDomain() {
        String host = "\u0442\u0435\u0441\u0442.\u0440\u0444";
        CharBuffer asciiHost = CharBuffer.wrap(IDN.toASCII(host));
        int port = 10000;
        SocksCmdRequest rq = new SocksCmdRequest(SocksCmdType.BIND, SocksAddressType.DOMAIN, host, port);
        Assert.assertEquals((Object)host, (Object)rq.host());
        ByteBuf buffer = Unpooled.buffer((int)24);
        rq.encodeAsByteBuf(buffer);
        buffer.resetReaderIndex();
        Assert.assertEquals((long)SocksProtocolVersion.SOCKS5.byteValue(), (long)buffer.readByte());
        Assert.assertEquals((long)SocksCmdType.BIND.byteValue(), (long)buffer.readByte());
        Assert.assertEquals((long)0L, (long)buffer.readByte());
        Assert.assertEquals((long)SocksAddressType.DOMAIN.byteValue(), (long)buffer.readByte());
        Assert.assertEquals((long)((byte)asciiHost.length()), (long)buffer.readUnsignedByte());
        Assert.assertEquals((Object)asciiHost, (Object)CharBuffer.wrap(buffer.readCharSequence(asciiHost.length(), CharsetUtil.US_ASCII)));
        Assert.assertEquals((long)port, (long)buffer.readUnsignedShort());
        buffer.release();
    }

    @Test
    public void testValidPortRange() {
        try {
            new SocksCmdRequest(SocksCmdType.BIND, SocksAddressType.DOMAIN, "\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9", 0);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
        try {
            new SocksCmdRequest(SocksCmdType.BIND, SocksAddressType.DOMAIN, "\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9", 65536);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }
}

