/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socksx.v5;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.socksx.v5.Socks5AuthScheme;
import io.netty.handler.codec.socksx.v5.Socks5Request;
import io.netty.handler.codec.socksx.v5.Socks5RequestType;
import java.util.Collections;
import java.util.List;

public final class Socks5InitRequest
extends Socks5Request {
    private final List<Socks5AuthScheme> authSchemes;

    public Socks5InitRequest(List<Socks5AuthScheme> authSchemes) {
        super(Socks5RequestType.INIT);
        if (authSchemes == null) {
            throw new NullPointerException("authSchemes");
        }
        this.authSchemes = authSchemes;
    }

    public List<Socks5AuthScheme> authSchemes() {
        return Collections.unmodifiableList(this.authSchemes);
    }

    @Override
    void encodeAsByteBuf(ByteBuf byteBuf) {
        byteBuf.writeByte((int)this.protocolVersion().byteValue());
        byteBuf.writeByte(this.authSchemes.size());
        for (Socks5AuthScheme authScheme : this.authSchemes) {
            byteBuf.writeByte((int)authScheme.byteValue());
        }
    }
}

