/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socksx.v5;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.socksx.v5.Socks5AddressType;
import io.netty.handler.codec.socksx.v5.Socks5CmdStatus;
import io.netty.handler.codec.socksx.v5.Socks5Response;
import io.netty.handler.codec.socksx.v5.Socks5ResponseType;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import java.net.IDN;

public final class Socks5CmdResponse
extends Socks5Response {
    private final Socks5CmdStatus cmdStatus;
    private final Socks5AddressType addressType;
    private final String host;
    private final int port;
    private static final byte[] DOMAIN_ZEROED = new byte[]{0};
    private static final byte[] IPv4_HOSTNAME_ZEROED = new byte[]{0, 0, 0, 0};
    private static final byte[] IPv6_HOSTNAME_ZEROED = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public Socks5CmdResponse(Socks5CmdStatus cmdStatus, Socks5AddressType addressType) {
        this(cmdStatus, addressType, null, 0);
    }

    public Socks5CmdResponse(Socks5CmdStatus cmdStatus, Socks5AddressType addressType, String host, int port) {
        super(Socks5ResponseType.CMD);
        if (cmdStatus == null) {
            throw new NullPointerException("cmdStatus");
        }
        if (addressType == null) {
            throw new NullPointerException("addressType");
        }
        if (host != null) {
            switch (addressType) {
                case IPv4: {
                    if (NetUtil.isValidIpV4Address((String)host)) break;
                    throw new IllegalArgumentException(host + " is not a valid IPv4 address");
                }
                case DOMAIN: {
                    if (IDN.toASCII(host).length() <= 255) break;
                    throw new IllegalArgumentException(host + " IDN: " + IDN.toASCII(host) + " exceeds 255 char limit");
                }
                case IPv6: {
                    if (NetUtil.isValidIpV6Address((String)host)) break;
                    throw new IllegalArgumentException(host + " is not a valid IPv6 address");
                }
            }
            host = IDN.toASCII(host);
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException(port + " is not in bounds 0 <= x <= 65535");
        }
        this.cmdStatus = cmdStatus;
        this.addressType = addressType;
        this.host = host;
        this.port = port;
    }

    public Socks5CmdStatus cmdStatus() {
        return this.cmdStatus;
    }

    public Socks5AddressType addressType() {
        return this.addressType;
    }

    public String host() {
        if (this.host != null) {
            return IDN.toUnicode(this.host);
        }
        return null;
    }

    public int port() {
        return this.port;
    }

    @Override
    void encodeAsByteBuf(ByteBuf byteBuf) {
        byteBuf.writeByte((int)this.protocolVersion().byteValue());
        byteBuf.writeByte((int)this.cmdStatus.byteValue());
        byteBuf.writeByte(0);
        byteBuf.writeByte((int)this.addressType.byteValue());
        switch (this.addressType) {
            case IPv4: {
                byte[] hostContent = this.host == null ? IPv4_HOSTNAME_ZEROED : NetUtil.createByteArrayFromIpAddressString((String)this.host);
                byteBuf.writeBytes(hostContent);
                byteBuf.writeShort(this.port);
                break;
            }
            case DOMAIN: {
                byte[] hostContent = this.host == null ? DOMAIN_ZEROED : this.host.getBytes(CharsetUtil.US_ASCII);
                byteBuf.writeByte(hostContent.length);
                byteBuf.writeBytes(hostContent);
                byteBuf.writeShort(this.port);
                break;
            }
            case IPv6: {
                byte[] hostContent = this.host == null ? IPv6_HOSTNAME_ZEROED : NetUtil.createByteArrayFromIpAddressString((String)this.host);
                byteBuf.writeBytes(hostContent);
                byteBuf.writeShort(this.port);
                break;
            }
        }
    }
}

