/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.smtp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.smtp.DefaultLastSmtpContent;
import io.netty.handler.codec.smtp.DefaultSmtpContent;
import io.netty.handler.codec.smtp.SmtpRequest;
import io.netty.handler.codec.smtp.SmtpRequestEncoder;
import io.netty.handler.codec.smtp.SmtpRequests;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Test;

public class SmtpRequestEncoderTest {
    @Test
    public void testEncodeEhlo() {
        SmtpRequestEncoderTest.testEncode(SmtpRequests.ehlo((CharSequence)"localhost"), "EHLO localhost\r\n");
    }

    @Test
    public void testEncodeHelo() {
        SmtpRequestEncoderTest.testEncode(SmtpRequests.helo((CharSequence)"localhost"), "HELO localhost\r\n");
    }

    @Test
    public void testEncodeMail() {
        SmtpRequestEncoderTest.testEncode(SmtpRequests.mail((CharSequence)"me@netty.io", (CharSequence[])new CharSequence[0]), "MAIL FROM:<me@netty.io>\r\n");
    }

    @Test
    public void testEncodeMailNullSender() {
        SmtpRequestEncoderTest.testEncode(SmtpRequests.mail(null, (CharSequence[])new CharSequence[0]), "MAIL FROM:<>\r\n");
    }

    @Test
    public void testEncodeRcpt() {
        SmtpRequestEncoderTest.testEncode(SmtpRequests.rcpt((CharSequence)"me@netty.io", (CharSequence[])new CharSequence[0]), "RCPT TO:<me@netty.io>\r\n");
    }

    @Test
    public void testEncodeNoop() {
        SmtpRequestEncoderTest.testEncode(SmtpRequests.noop(), "NOOP\r\n");
    }

    @Test
    public void testEncodeRset() {
        SmtpRequestEncoderTest.testEncode(SmtpRequests.rset(), "RSET\r\n");
    }

    @Test
    public void testEncodeHelp() {
        SmtpRequestEncoderTest.testEncode(SmtpRequests.help(null), "HELP\r\n");
    }

    @Test
    public void testEncodeHelpWithArg() {
        SmtpRequestEncoderTest.testEncode(SmtpRequests.help((String)"MAIL"), "HELP MAIL\r\n");
    }

    @Test
    public void testEncodeData() {
        SmtpRequestEncoderTest.testEncode(SmtpRequests.data(), "DATA\r\n");
    }

    @Test
    public void testEncodeDataAndContent() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new SmtpRequestEncoder()});
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{SmtpRequests.data()}));
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{new DefaultSmtpContent(Unpooled.copiedBuffer((CharSequence)"Subject: Test\r\n\r\n", (Charset)CharsetUtil.US_ASCII))}));
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{new DefaultLastSmtpContent(Unpooled.copiedBuffer((CharSequence)"Test\r\n", (Charset)CharsetUtil.US_ASCII))}));
        Assert.assertTrue((boolean)channel.finish());
        Assert.assertEquals((Object)"DATA\r\nSubject: Test\r\n\r\nTest\r\n.\r\n", (Object)SmtpRequestEncoderTest.getWrittenString(channel));
    }

    @Test(expected=EncoderException.class)
    public void testThrowsIfContentExpected() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new SmtpRequestEncoder()});
        try {
            Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{SmtpRequests.data()}));
            channel.writeOutbound(new Object[]{SmtpRequests.noop()});
        }
        finally {
            channel.finishAndReleaseAll();
        }
    }

    @Test
    public void testRsetClearsContentExpectedFlag() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new SmtpRequestEncoder()});
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{SmtpRequests.data()}));
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{SmtpRequests.rset()}));
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{SmtpRequests.noop()}));
        Assert.assertTrue((boolean)channel.finish());
        Assert.assertEquals((Object)"DATA\r\nRSET\r\nNOOP\r\n", (Object)SmtpRequestEncoderTest.getWrittenString(channel));
    }

    private static String getWrittenString(EmbeddedChannel channel) {
        ByteBuf buffer;
        ByteBuf written = Unpooled.buffer();
        while ((buffer = (ByteBuf)channel.readOutbound()) != null) {
            written.writeBytes(buffer);
            buffer.release();
        }
        String writtenString = written.toString(CharsetUtil.US_ASCII);
        written.release();
        return writtenString;
    }

    private static void testEncode(SmtpRequest request, String expected) {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new SmtpRequestEncoder()});
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{request}));
        Assert.assertTrue((boolean)channel.finish());
        ByteBuf buffer = (ByteBuf)channel.readOutbound();
        Assert.assertEquals((Object)expected, (Object)buffer.toString(CharsetUtil.US_ASCII));
        buffer.release();
        Assert.assertNull((Object)channel.readOutbound());
    }
}

