/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.redis;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.redis.ArrayRedisMessage;
import io.netty.handler.codec.redis.BulkStringHeaderRedisMessage;
import io.netty.handler.codec.redis.DefaultBulkStringRedisContent;
import io.netty.handler.codec.redis.DefaultLastBulkStringRedisContent;
import io.netty.handler.codec.redis.ErrorRedisMessage;
import io.netty.handler.codec.redis.FullBulkStringRedisMessage;
import io.netty.handler.codec.redis.InlineCommandRedisMessage;
import io.netty.handler.codec.redis.IntegerRedisMessage;
import io.netty.handler.codec.redis.RedisCodecTestUtil;
import io.netty.handler.codec.redis.RedisEncoder;
import io.netty.handler.codec.redis.SimpleStringRedisMessage;
import java.util.ArrayList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RedisEncoderTest {
    private EmbeddedChannel channel;

    @Before
    public void setup() throws Exception {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new RedisEncoder()});
    }

    @After
    public void teardown() throws Exception {
        Assert.assertFalse((boolean)this.channel.finish());
    }

    @Test
    public void shouldEncodeInlineCommand() {
        InlineCommandRedisMessage msg = new InlineCommandRedisMessage("ping");
        boolean result = this.channel.writeOutbound(new Object[]{msg});
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        ByteBuf written = RedisEncoderTest.readAll(this.channel);
        Assert.assertThat((Object)RedisCodecTestUtil.bytesOf(written), (Matcher)CoreMatchers.is((Object)RedisCodecTestUtil.bytesOf("ping\r\n")));
        written.release();
    }

    @Test
    public void shouldEncodeSimpleString() {
        SimpleStringRedisMessage msg = new SimpleStringRedisMessage("simple");
        boolean result = this.channel.writeOutbound(new Object[]{msg});
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        ByteBuf written = RedisEncoderTest.readAll(this.channel);
        Assert.assertThat((Object)RedisCodecTestUtil.bytesOf(written), (Matcher)CoreMatchers.is((Object)RedisCodecTestUtil.bytesOf("+simple\r\n")));
        written.release();
    }

    @Test
    public void shouldEncodeError() {
        ErrorRedisMessage msg = new ErrorRedisMessage("error1");
        boolean result = this.channel.writeOutbound(new Object[]{msg});
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        ByteBuf written = RedisEncoderTest.readAll(this.channel);
        Assert.assertThat((Object)RedisCodecTestUtil.bytesOf(written), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)RedisCodecTestUtil.bytesOf("-error1\r\n"))));
        written.release();
    }

    @Test
    public void shouldEncodeInteger() {
        IntegerRedisMessage msg = new IntegerRedisMessage(1234L);
        boolean result = this.channel.writeOutbound(new Object[]{msg});
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        ByteBuf written = RedisEncoderTest.readAll(this.channel);
        Assert.assertThat((Object)RedisCodecTestUtil.bytesOf(written), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)RedisCodecTestUtil.bytesOf(":1234\r\n"))));
        written.release();
    }

    @Test
    public void shouldEncodeBulkStringContent() {
        BulkStringHeaderRedisMessage header = new BulkStringHeaderRedisMessage(16);
        DefaultBulkStringRedisContent body1 = new DefaultBulkStringRedisContent(RedisCodecTestUtil.byteBufOf("bulk\nstr").retain());
        DefaultLastBulkStringRedisContent body2 = new DefaultLastBulkStringRedisContent(RedisCodecTestUtil.byteBufOf("ing\ntest").retain());
        Assert.assertThat((Object)this.channel.writeOutbound(new Object[]{header}), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.channel.writeOutbound(new Object[]{body1}), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.channel.writeOutbound(new Object[]{body2}), (Matcher)CoreMatchers.is((Object)true));
        ByteBuf written = RedisEncoderTest.readAll(this.channel);
        Assert.assertThat((Object)RedisCodecTestUtil.bytesOf(written), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)RedisCodecTestUtil.bytesOf("$16\r\nbulk\nstring\ntest\r\n"))));
        written.release();
    }

    @Test
    public void shouldEncodeFullBulkString() {
        ByteBuf bulkString = RedisCodecTestUtil.byteBufOf("bulk\nstring\ntest").retain();
        int length = bulkString.readableBytes();
        FullBulkStringRedisMessage msg = new FullBulkStringRedisMessage(bulkString);
        boolean result = this.channel.writeOutbound(new Object[]{msg});
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        ByteBuf written = RedisEncoderTest.readAll(this.channel);
        Assert.assertThat((Object)RedisCodecTestUtil.bytesOf(written), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)RedisCodecTestUtil.bytesOf("$" + length + "\r\nbulk\nstring\ntest\r\n"))));
        written.release();
    }

    @Test
    public void shouldEncodeSimpleArray() {
        ArrayList<FullBulkStringRedisMessage> children = new ArrayList<FullBulkStringRedisMessage>();
        children.add(new FullBulkStringRedisMessage(RedisCodecTestUtil.byteBufOf("foo").retain()));
        children.add(new FullBulkStringRedisMessage(RedisCodecTestUtil.byteBufOf("bar").retain()));
        ArrayRedisMessage msg = new ArrayRedisMessage(children);
        boolean result = this.channel.writeOutbound(new Object[]{msg});
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        ByteBuf written = RedisEncoderTest.readAll(this.channel);
        Assert.assertThat((Object)RedisCodecTestUtil.bytesOf(written), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)RedisCodecTestUtil.bytesOf("*2\r\n$3\r\nfoo\r\n$3\r\nbar\r\n"))));
        written.release();
    }

    @Test
    public void shouldEncodeNullArray() {
        ArrayRedisMessage msg = ArrayRedisMessage.NULL_INSTANCE;
        boolean result = this.channel.writeOutbound(new Object[]{msg});
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        ByteBuf written = RedisEncoderTest.readAll(this.channel);
        Assert.assertThat((Object)RedisCodecTestUtil.bytesOf(written), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)RedisCodecTestUtil.bytesOf("*-1\r\n"))));
        written.release();
    }

    @Test
    public void shouldEncodeEmptyArray() {
        ArrayRedisMessage msg = ArrayRedisMessage.EMPTY_INSTANCE;
        boolean result = this.channel.writeOutbound(new Object[]{msg});
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        ByteBuf written = RedisEncoderTest.readAll(this.channel);
        Assert.assertThat((Object)RedisCodecTestUtil.bytesOf(written), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)RedisCodecTestUtil.bytesOf("*0\r\n"))));
        written.release();
    }

    @Test
    public void shouldEncodeNestedArray() {
        ArrayList<Object> grandChildren = new ArrayList<Object>();
        grandChildren.add(new FullBulkStringRedisMessage(RedisCodecTestUtil.byteBufOf("bar")));
        grandChildren.add(new IntegerRedisMessage(-1234L));
        ArrayList<Object> children = new ArrayList<Object>();
        children.add(new SimpleStringRedisMessage("foo"));
        children.add(new ArrayRedisMessage(grandChildren));
        ArrayRedisMessage msg = new ArrayRedisMessage(children);
        boolean result = this.channel.writeOutbound(new Object[]{msg});
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        ByteBuf written = RedisEncoderTest.readAll(this.channel);
        Assert.assertThat((Object)RedisCodecTestUtil.bytesOf(written), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)RedisCodecTestUtil.bytesOf("*2\r\n+foo\r\n*2\r\n$3\r\nbar\r\n:-1234\r\n"))));
        written.release();
    }

    private static ByteBuf readAll(EmbeddedChannel channel) {
        ByteBuf read;
        ByteBuf buf = Unpooled.buffer();
        while ((read = (ByteBuf)channel.readOutbound()) != null) {
            buf.writeBytes(read);
            read.release();
        }
        return buf;
    }
}

