/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.mqtt;

import io.netty.handler.codec.mqtt.MqttProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class MqttPropertiesTest {
    private MqttProperties createSampleProperties() {
        MqttProperties props = new MqttProperties();
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value(), Integer.valueOf(10)));
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value(), Integer.valueOf(20)));
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.PAYLOAD_FORMAT_INDICATOR.value(), Integer.valueOf(6)));
        props.add((MqttProperties.MqttProperty)new MqttProperties.StringProperty(MqttProperties.MqttPropertyType.CONTENT_TYPE.value(), "text/plain"));
        props.add((MqttProperties.MqttProperty)new MqttProperties.UserProperty("isSecret", "true"));
        props.add((MqttProperties.MqttProperty)new MqttProperties.UserProperty("tag", "firstTag"));
        props.add((MqttProperties.MqttProperty)new MqttProperties.UserProperty("tag", "secondTag"));
        return props;
    }

    @Test
    public void testGetProperty() {
        MqttProperties props = this.createSampleProperties();
        Assert.assertEquals((String)"getProperty Content Type", (Object)"text/plain", (Object)((MqttProperties.StringProperty)props.getProperty((int)MqttProperties.MqttPropertyType.CONTENT_TYPE.value())).value);
        Assert.assertEquals((String)"getProperty Subscription ID", (long)10L, (long)((Integer)((MqttProperties.IntegerProperty)props.getProperty((int)MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value())).value).intValue());
        ArrayList<MqttProperties.StringPair> expectedUserProps = new ArrayList<MqttProperties.StringPair>();
        expectedUserProps.add(new MqttProperties.StringPair("isSecret", "true"));
        expectedUserProps.add(new MqttProperties.StringPair("tag", "firstTag"));
        expectedUserProps.add(new MqttProperties.StringPair("tag", "secondTag"));
        List actualUserProps = (List)((MqttProperties.UserProperties)props.getProperty((int)MqttProperties.MqttPropertyType.USER_PROPERTY.value())).value;
        Assert.assertEquals((String)"getProperty User Properties", expectedUserProps, (Object)actualUserProps);
    }

    @Test
    public void testGetProperties() {
        MqttProperties props = this.createSampleProperties();
        Assert.assertEquals((String)"getProperties Content Type", Collections.singletonList(new MqttProperties.StringProperty(MqttProperties.MqttPropertyType.CONTENT_TYPE.value(), "text/plain")), (Object)props.getProperties(MqttProperties.MqttPropertyType.CONTENT_TYPE.value()));
        ArrayList<MqttProperties.IntegerProperty> expectedSubscriptionIds = new ArrayList<MqttProperties.IntegerProperty>();
        expectedSubscriptionIds.add(new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value(), Integer.valueOf(10)));
        expectedSubscriptionIds.add(new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value(), Integer.valueOf(20)));
        Assert.assertEquals((String)"getProperties Subscription ID", expectedSubscriptionIds, (Object)props.getProperties(MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value()));
        ArrayList<MqttProperties.UserProperty> expectedUserProps = new ArrayList<MqttProperties.UserProperty>();
        expectedUserProps.add(new MqttProperties.UserProperty("isSecret", "true"));
        expectedUserProps.add(new MqttProperties.UserProperty("tag", "firstTag"));
        expectedUserProps.add(new MqttProperties.UserProperty("tag", "secondTag"));
        List actualUserProps = props.getProperties(MqttProperties.MqttPropertyType.USER_PROPERTY.value());
        Assert.assertEquals((String)"getProperty User Properties", expectedUserProps, (Object)actualUserProps);
    }

    @Test
    public void testListAll() {
        MqttProperties props = this.createSampleProperties();
        ArrayList<Object> expectedProperties = new ArrayList<Object>();
        expectedProperties.add(new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.PAYLOAD_FORMAT_INDICATOR.value(), Integer.valueOf(6)));
        expectedProperties.add(new MqttProperties.StringProperty(MqttProperties.MqttPropertyType.CONTENT_TYPE.value(), "text/plain"));
        expectedProperties.add(new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value(), Integer.valueOf(10)));
        expectedProperties.add(new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value(), Integer.valueOf(20)));
        MqttProperties.UserProperties expectedUserProperties = new MqttProperties.UserProperties();
        expectedUserProperties.add(new MqttProperties.StringPair("isSecret", "true"));
        expectedUserProperties.add(new MqttProperties.StringPair("tag", "firstTag"));
        expectedUserProperties.add(new MqttProperties.StringPair("tag", "secondTag"));
        expectedProperties.add(expectedUserProperties);
        Assert.assertEquals((String)"listAll", expectedProperties, (Object)props.listAll());
    }
}

