/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.memcache.binary;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.memcache.binary.BinaryMemcacheObjectAggregator;
import io.netty.handler.codec.memcache.binary.BinaryMemcacheResponseDecoder;
import io.netty.handler.codec.memcache.binary.BinaryMemcacheResponseEncoder;
import io.netty.handler.codec.memcache.binary.DefaultFullBinaryMemcacheResponse;
import io.netty.handler.codec.memcache.binary.FullBinaryMemcacheResponse;
import io.netty.util.CharsetUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FullMemcacheMessageResponseTest {
    private EmbeddedChannel channel;

    @Before
    public void setup() throws Exception {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new BinaryMemcacheResponseEncoder(), new BinaryMemcacheResponseDecoder(), new BinaryMemcacheObjectAggregator(1024)});
    }

    @After
    public void teardown() throws Exception {
        Assert.assertFalse((boolean)this.channel.finish());
    }

    @Test
    public void testEncodeDecode() throws Exception {
        ByteBuf key = Unpooled.wrappedBuffer((byte[])"key".getBytes(CharsetUtil.UTF_8));
        ByteBuf content = Unpooled.wrappedBuffer((byte[])"content".getBytes(CharsetUtil.UTF_8));
        ByteBuf extras = Unpooled.wrappedBuffer((byte[])"extras".getBytes(CharsetUtil.UTF_8));
        DefaultFullBinaryMemcacheResponse resp = new DefaultFullBinaryMemcacheResponse(key, extras, content);
        Assert.assertTrue((boolean)this.channel.writeOutbound(new Object[]{resp}));
        Assert.assertEquals((long)2L, (long)this.channel.outboundMessages().size());
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{this.channel.readOutbound(), this.channel.readOutbound()}));
        FullBinaryMemcacheResponse read = (FullBinaryMemcacheResponse)this.channel.readInbound();
        Assert.assertEquals((Object)"key", (Object)read.key().toString(CharsetUtil.UTF_8));
        Assert.assertEquals((Object)"content", (Object)read.content().toString(CharsetUtil.UTF_8));
        Assert.assertEquals((Object)"extras", (Object)read.extras().toString(CharsetUtil.UTF_8));
        read.release();
    }
}

