/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.AsciiString;
import org.junit.Assert;
import org.junit.Test;

public class HttpConversionUtilTest {
    @Test
    public void setHttp2AuthorityWithoutUserInfo() {
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        HttpConversionUtil.setHttp2Authority((String)"foo", (Http2Headers)headers);
        Assert.assertEquals((Object)new AsciiString((CharSequence)"foo"), (Object)headers.authority());
    }

    @Test
    public void setHttp2AuthorityWithUserInfo() {
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        HttpConversionUtil.setHttp2Authority((String)"info@foo", (Http2Headers)headers);
        Assert.assertEquals((Object)new AsciiString((CharSequence)"foo"), (Object)headers.authority());
        HttpConversionUtil.setHttp2Authority((String)"@foo.bar", (Http2Headers)headers);
        Assert.assertEquals((Object)new AsciiString((CharSequence)"foo.bar"), (Object)headers.authority());
    }

    @Test
    public void setHttp2AuthorityNullOrEmpty() {
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        HttpConversionUtil.setHttp2Authority(null, (Http2Headers)headers);
        Assert.assertNull((Object)headers.authority());
        HttpConversionUtil.setHttp2Authority((String)"", (Http2Headers)headers);
        Assert.assertSame((Object)AsciiString.EMPTY_STRING, (Object)headers.authority());
    }

    @Test(expected=IllegalArgumentException.class)
    public void setHttp2AuthorityWithEmptyAuthority() {
        HttpConversionUtil.setHttp2Authority((String)"info@", (Http2Headers)new DefaultHttp2Headers());
    }

    @Test
    public void stripTEHeaders() {
        DefaultHttpHeaders inHeaders = new DefaultHttpHeaders();
        inHeaders.add((CharSequence)HttpHeaderNames.TE, (Object)HttpHeaderValues.GZIP);
        DefaultHttp2Headers out = new DefaultHttp2Headers();
        HttpConversionUtil.toHttp2Headers((HttpHeaders)inHeaders, (Http2Headers)out);
        Assert.assertTrue((boolean)out.isEmpty());
    }

    @Test
    public void stripTEHeadersExcludingTrailers() {
        DefaultHttpHeaders inHeaders = new DefaultHttpHeaders();
        inHeaders.add((CharSequence)HttpHeaderNames.TE, (Object)HttpHeaderValues.GZIP);
        inHeaders.add((CharSequence)HttpHeaderNames.TE, (Object)HttpHeaderValues.TRAILERS);
        DefaultHttp2Headers out = new DefaultHttp2Headers();
        HttpConversionUtil.toHttp2Headers((HttpHeaders)inHeaders, (Http2Headers)out);
        Assert.assertSame((Object)HttpHeaderValues.TRAILERS, (Object)out.get((Object)HttpHeaderNames.TE));
    }

    @Test
    public void stripTEHeadersCsvSeparatedExcludingTrailers() {
        DefaultHttpHeaders inHeaders = new DefaultHttpHeaders();
        inHeaders.add((CharSequence)HttpHeaderNames.TE, (Object)(HttpHeaderValues.GZIP + "," + HttpHeaderValues.TRAILERS));
        DefaultHttp2Headers out = new DefaultHttp2Headers();
        HttpConversionUtil.toHttp2Headers((HttpHeaders)inHeaders, (Http2Headers)out);
        Assert.assertSame((Object)HttpHeaderValues.TRAILERS, (Object)out.get((Object)HttpHeaderNames.TE));
    }

    @Test
    public void stripTEHeadersCsvSeparatedAccountsForValueSimilarToTrailers() {
        DefaultHttpHeaders inHeaders = new DefaultHttpHeaders();
        inHeaders.add((CharSequence)HttpHeaderNames.TE, (Object)(HttpHeaderValues.GZIP + "," + HttpHeaderValues.TRAILERS + "foo"));
        DefaultHttp2Headers out = new DefaultHttp2Headers();
        HttpConversionUtil.toHttp2Headers((HttpHeaders)inHeaders, (Http2Headers)out);
        Assert.assertFalse((boolean)out.contains((Object)HttpHeaderNames.TE));
    }

    @Test
    public void stripTEHeadersAccountsForValueSimilarToTrailers() {
        DefaultHttpHeaders inHeaders = new DefaultHttpHeaders();
        inHeaders.add((CharSequence)HttpHeaderNames.TE, (Object)(HttpHeaderValues.TRAILERS + "foo"));
        DefaultHttp2Headers out = new DefaultHttp2Headers();
        HttpConversionUtil.toHttp2Headers((HttpHeaders)inHeaders, (Http2Headers)out);
        Assert.assertFalse((boolean)out.contains((Object)HttpHeaderNames.TE));
    }

    @Test
    public void stripTEHeadersAccountsForOWS() {
        DefaultHttpHeaders inHeaders = new DefaultHttpHeaders();
        inHeaders.add((CharSequence)HttpHeaderNames.TE, (Object)(" " + HttpHeaderValues.TRAILERS + " "));
        DefaultHttp2Headers out = new DefaultHttp2Headers();
        HttpConversionUtil.toHttp2Headers((HttpHeaders)inHeaders, (Http2Headers)out);
        Assert.assertSame((Object)HttpHeaderValues.TRAILERS, (Object)out.get((Object)HttpHeaderNames.TE));
    }

    @Test
    public void stripConnectionHeadersAndNominees() {
        DefaultHttpHeaders inHeaders = new DefaultHttpHeaders();
        inHeaders.add((CharSequence)HttpHeaderNames.CONNECTION, (Object)"foo");
        inHeaders.add("foo", (Object)"bar");
        DefaultHttp2Headers out = new DefaultHttp2Headers();
        HttpConversionUtil.toHttp2Headers((HttpHeaders)inHeaders, (Http2Headers)out);
        Assert.assertTrue((boolean)out.isEmpty());
    }

    @Test
    public void stripConnectionNomineesWithCsv() {
        DefaultHttpHeaders inHeaders = new DefaultHttpHeaders();
        inHeaders.add((CharSequence)HttpHeaderNames.CONNECTION, (Object)"foo,  bar");
        inHeaders.add("foo", (Object)"baz");
        inHeaders.add("bar", (Object)"qux");
        inHeaders.add("hello", (Object)"world");
        DefaultHttp2Headers out = new DefaultHttp2Headers();
        HttpConversionUtil.toHttp2Headers((HttpHeaders)inHeaders, (Http2Headers)out);
        Assert.assertEquals((long)1L, (long)out.size());
        Assert.assertSame((Object)"world", (Object)out.get((Object)"hello"));
    }

    @Test
    public void addHttp2ToHttpHeadersCombinesCookies() throws Http2Exception {
        DefaultHttp2Headers inHeaders = new DefaultHttp2Headers();
        inHeaders.add((Object)"yes", (Object)"no");
        inHeaders.add((Object)HttpHeaderNames.COOKIE, (Object)"foo=bar");
        inHeaders.add((Object)HttpHeaderNames.COOKIE, (Object)"bax=baz");
        DefaultHttpHeaders outHeaders = new DefaultHttpHeaders();
        HttpConversionUtil.addHttp2ToHttpHeaders((int)5, (Http2Headers)inHeaders, (HttpHeaders)outHeaders, (HttpVersion)HttpVersion.HTTP_1_1, (boolean)false, (boolean)false);
        Assert.assertEquals((Object)"no", (Object)outHeaders.get("yes"));
        Assert.assertEquals((Object)"foo=bar; bax=baz", (Object)outHeaders.get(HttpHeaderNames.COOKIE.toString()));
    }

    @Test
    public void connectionSpecificHeadersShouldBeRemoved() {
        DefaultHttpHeaders inHeaders = new DefaultHttpHeaders();
        inHeaders.add((CharSequence)HttpHeaderNames.CONNECTION, (Object)"keep-alive");
        inHeaders.add((CharSequence)HttpHeaderNames.HOST, (Object)"example.com");
        AsciiString keepAlive = HttpHeaderNames.KEEP_ALIVE;
        inHeaders.add((CharSequence)keepAlive, (Object)"timeout=5, max=1000");
        AsciiString proxyConnection = HttpHeaderNames.PROXY_CONNECTION;
        inHeaders.add((CharSequence)proxyConnection, (Object)"timeout=5, max=1000");
        inHeaders.add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)"chunked");
        inHeaders.add((CharSequence)HttpHeaderNames.UPGRADE, (Object)"h2c");
        DefaultHttp2Headers outHeaders = new DefaultHttp2Headers();
        HttpConversionUtil.toHttp2Headers((HttpHeaders)inHeaders, (Http2Headers)outHeaders);
        Assert.assertFalse((boolean)outHeaders.contains((Object)HttpHeaderNames.CONNECTION));
        Assert.assertFalse((boolean)outHeaders.contains((Object)HttpHeaderNames.HOST));
        Assert.assertFalse((boolean)outHeaders.contains((Object)keepAlive));
        Assert.assertFalse((boolean)outHeaders.contains((Object)proxyConnection));
        Assert.assertFalse((boolean)outHeaders.contains((Object)HttpHeaderNames.TRANSFER_ENCODING));
        Assert.assertFalse((boolean)outHeaders.contains((Object)HttpHeaderNames.UPGRADE));
    }

    @Test
    public void http2ToHttpHeaderTest() throws Exception {
        DefaultHttp2Headers http2Headers = new DefaultHttp2Headers();
        http2Headers.status((CharSequence)"200");
        http2Headers.path((CharSequence)"/meow");
        http2Headers.set((Object)"cat", (Object)"meow");
        DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
        HttpConversionUtil.addHttp2ToHttpHeaders((int)3, (Http2Headers)http2Headers, (HttpHeaders)httpHeaders, (HttpVersion)HttpVersion.HTTP_1_1, (boolean)false, (boolean)true);
        Assert.assertFalse((boolean)httpHeaders.contains((CharSequence)HttpConversionUtil.ExtensionHeaderNames.PATH.text()));
        Assert.assertEquals((Object)"meow", (Object)httpHeaders.get("cat"));
        httpHeaders.clear();
        HttpConversionUtil.addHttp2ToHttpHeaders((int)3, (Http2Headers)http2Headers, (HttpHeaders)httpHeaders, (HttpVersion)HttpVersion.HTTP_1_1, (boolean)false, (boolean)false);
        Assert.assertTrue((boolean)httpHeaders.contains((CharSequence)HttpConversionUtil.ExtensionHeaderNames.PATH.text()));
        Assert.assertEquals((Object)"meow", (Object)httpHeaders.get("cat"));
    }
}

