/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.DefaultEventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class Http2StreamChannelBootstrapTest {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Http2StreamChannelBootstrapTest.class);
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();
    private volatile Channel serverConnectedChannel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStreamIsNotCreatedIfParentConnectionIsClosedConcurrently() throws Exception {
        DefaultEventLoop group = null;
        Channel serverChannel = null;
        Channel clientChannel = null;
        try {
            final CountDownLatch serverChannelLatch = new CountDownLatch(1);
            group = new DefaultEventLoop();
            LocalAddress serverAddress = new LocalAddress(this.getClass().getName());
            ServerBootstrap sb = ((ServerBootstrap)new ServerBootstrap().channel(LocalServerChannel.class)).group((EventLoopGroup)group).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    Http2StreamChannelBootstrapTest.this.serverConnectedChannel = ch;
                    ch.pipeline().addLast(new ChannelHandler[]{Http2FrameCodecBuilder.forServer().build(), Http2StreamChannelBootstrapTest.newMultiplexedHandler()});
                    serverChannelLatch.countDown();
                }
            });
            serverChannel = sb.bind((SocketAddress)serverAddress).sync().channel();
            Bootstrap cb = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(LocalChannel.class)).group((EventLoopGroup)group)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{Http2FrameCodecBuilder.forClient().build(), Http2StreamChannelBootstrapTest.newMultiplexedHandler()});
                }
            });
            clientChannel = cb.connect((SocketAddress)serverAddress).sync().channel();
            Assert.assertTrue((boolean)serverChannelLatch.await(3L, TimeUnit.SECONDS));
            final CountDownLatch closeLatch = new CountDownLatch(1);
            final Channel clientChannelToClose = clientChannel;
            group.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        closeLatch.await();
                        clientChannelToClose.close().syncUninterruptibly();
                    }
                    catch (InterruptedException e) {
                        logger.error((Throwable)e);
                    }
                }
            });
            Http2StreamChannelBootstrap bootstrap = new Http2StreamChannelBootstrap(clientChannel);
            Promise promise = clientChannel.eventLoop().newPromise();
            bootstrap.open(promise);
            MatcherAssert.assertThat((Object)promise.isDone(), (Matcher)Matchers.is((Object)false));
            closeLatch.countDown();
            this.exceptionRule.expect(ExecutionException.class);
            this.exceptionRule.expectCause(IsInstanceOf.instanceOf(ClosedChannelException.class));
            promise.get(3L, TimeUnit.SECONDS);
        }
        catch (Throwable throwable) {
            Http2StreamChannelBootstrapTest.safeClose(clientChannel);
            Http2StreamChannelBootstrapTest.safeClose(this.serverConnectedChannel);
            Http2StreamChannelBootstrapTest.safeClose(serverChannel);
            if (group != null) {
                group.shutdownGracefully(0L, 3L, TimeUnit.SECONDS);
            }
            throw throwable;
        }
        Http2StreamChannelBootstrapTest.safeClose(clientChannel);
        Http2StreamChannelBootstrapTest.safeClose(this.serverConnectedChannel);
        Http2StreamChannelBootstrapTest.safeClose(serverChannel);
        if (group != null) {
            group.shutdownGracefully(0L, 3L, TimeUnit.SECONDS);
        }
    }

    private static Http2MultiplexHandler newMultiplexedHandler() {
        return new Http2MultiplexHandler((ChannelHandler)new ChannelInitializer<Http2StreamChannel>(){

            protected void initChannel(Http2StreamChannel ch) {
            }
        });
    }

    private static void safeClose(Channel channel) {
        if (channel != null) {
            try {
                channel.close().syncUninterruptibly();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }

    @Test
    public void open0FailsPromiseOnHttp2MultiplexHandlerError() {
        Http2StreamChannelBootstrap bootstrap = new Http2StreamChannelBootstrap((Channel)Mockito.mock(Channel.class));
        Http2MultiplexHandler handler = new Http2MultiplexHandler((ChannelHandler)Mockito.mock(ChannelHandler.class));
        EventExecutor executor = (EventExecutor)Mockito.mock(EventExecutor.class);
        Mockito.when((Object)executor.inEventLoop()).thenReturn((Object)true);
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Mockito.when((Object)ctx.executor()).thenReturn((Object)executor);
        Mockito.when((Object)ctx.handler()).thenReturn((Object)handler);
        DefaultPromise promise = new DefaultPromise((EventExecutor)Mockito.mock(EventExecutor.class));
        bootstrap.open0(ctx, (Promise)promise);
        MatcherAssert.assertThat((Object)promise.isDone(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)promise.cause(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(IllegalStateException.class)));
    }
}

