/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.HpackDecoder;
import io.netty.handler.codec.http2.HpackEncoder;
import io.netty.handler.codec.http2.HpackHeaderField;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.handler.codec.http2.Http2TestUtil;
import io.netty.handler.codec.http2.TestHeaderListener;
import io.netty.util.internal.StringUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class HpackTestCase {
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(HpackHeaderField.class, (Object)new HeaderFieldDeserializer()).create();
    int maxHeaderTableSize = -1;
    boolean sensitiveHeaders;
    List<HeaderBlock> headerBlocks;

    private HpackTestCase() {
    }

    static HpackTestCase load(InputStream is) {
        InputStreamReader r = new InputStreamReader(is);
        HpackTestCase hpackTestCase = (HpackTestCase)GSON.fromJson((Reader)r, HpackTestCase.class);
        for (HeaderBlock headerBlock : hpackTestCase.headerBlocks) {
            HeaderBlock.access$002(headerBlock, StringUtil.decodeHexDump((CharSequence)headerBlock.getEncodedStr()));
        }
        return hpackTestCase;
    }

    void testCompress() throws Exception {
        HpackEncoder hpackEncoder = this.createEncoder();
        for (HeaderBlock headerBlock : this.headerBlocks) {
            byte[] actual = HpackTestCase.encode(hpackEncoder, headerBlock.getHeaders(), headerBlock.getMaxHeaderTableSize(), this.sensitiveHeaders);
            if (!Arrays.equals(actual, headerBlock.encodedBytes)) {
                throw new AssertionError((Object)("\nEXPECTED:\n" + headerBlock.getEncodedStr() + "\nACTUAL:\n" + StringUtil.toHexString((byte[])actual)));
            }
            ArrayList<HpackHeaderField> actualDynamicTable = new ArrayList<HpackHeaderField>();
            for (int index = 0; index < hpackEncoder.length(); ++index) {
                actualDynamicTable.add(hpackEncoder.getHeaderField(index));
            }
            List<HpackHeaderField> expectedDynamicTable = headerBlock.getDynamicTable();
            if (!HpackTestCase.headersEqual(expectedDynamicTable, actualDynamicTable)) {
                throw new AssertionError((Object)("\nEXPECTED DYNAMIC TABLE:\n" + expectedDynamicTable + "\nACTUAL DYNAMIC TABLE:\n" + actualDynamicTable));
            }
            if ((long)headerBlock.getTableSize() != hpackEncoder.size()) {
                throw new AssertionError((Object)("\nEXPECTED TABLE SIZE: " + headerBlock.getTableSize() + "\n ACTUAL TABLE SIZE : " + hpackEncoder.size()));
            }
        }
    }

    void testDecompress() throws Exception {
        HpackDecoder hpackDecoder = this.createDecoder();
        for (HeaderBlock headerBlock : this.headerBlocks) {
            List<HpackHeaderField> actualHeaders = HpackTestCase.decode(hpackDecoder, headerBlock.encodedBytes);
            ArrayList<HpackHeaderField> expectedHeaders = new ArrayList<HpackHeaderField>();
            for (HpackHeaderField h : headerBlock.getHeaders()) {
                expectedHeaders.add(new HpackHeaderField(h.name, h.value));
            }
            if (!HpackTestCase.headersEqual(expectedHeaders, actualHeaders)) {
                throw new AssertionError((Object)("\nEXPECTED:\n" + expectedHeaders + "\nACTUAL:\n" + actualHeaders));
            }
            ArrayList<HpackHeaderField> actualDynamicTable = new ArrayList<HpackHeaderField>();
            for (int index = 0; index < hpackDecoder.length(); ++index) {
                actualDynamicTable.add(hpackDecoder.getHeaderField(index));
            }
            List<HpackHeaderField> expectedDynamicTable = headerBlock.getDynamicTable();
            if (!HpackTestCase.headersEqual(expectedDynamicTable, actualDynamicTable)) {
                throw new AssertionError((Object)("\nEXPECTED DYNAMIC TABLE:\n" + expectedDynamicTable + "\nACTUAL DYNAMIC TABLE:\n" + actualDynamicTable));
            }
            if ((long)headerBlock.getTableSize() != hpackDecoder.size()) {
                throw new AssertionError((Object)("\nEXPECTED TABLE SIZE: " + headerBlock.getTableSize() + "\n ACTUAL TABLE SIZE : " + hpackDecoder.size()));
            }
        }
    }

    private HpackEncoder createEncoder() {
        int maxHeaderTableSize = this.maxHeaderTableSize;
        if (maxHeaderTableSize == -1) {
            maxHeaderTableSize = Integer.MAX_VALUE;
        }
        try {
            return Http2TestUtil.newTestEncoder(true, 0xFFFFFFFFL, maxHeaderTableSize);
        }
        catch (Http2Exception e) {
            throw new Error("invalid initial values!", e);
        }
    }

    private HpackDecoder createDecoder() {
        int maxHeaderTableSize = this.maxHeaderTableSize;
        if (maxHeaderTableSize == -1) {
            maxHeaderTableSize = Integer.MAX_VALUE;
        }
        return new HpackDecoder(8192L, maxHeaderTableSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] encode(HpackEncoder hpackEncoder, List<HpackHeaderField> headers, int maxHeaderTableSize, final boolean sensitive) throws Http2Exception {
        Http2Headers http2Headers = HpackTestCase.toHttp2Headers(headers);
        Http2HeadersEncoder.SensitivityDetector sensitivityDetector = new Http2HeadersEncoder.SensitivityDetector(){

            public boolean isSensitive(CharSequence name, CharSequence value) {
                return sensitive;
            }
        };
        ByteBuf buffer = Unpooled.buffer();
        try {
            if (maxHeaderTableSize != -1) {
                hpackEncoder.setMaxHeaderTableSize(buffer, (long)maxHeaderTableSize);
            }
            hpackEncoder.encodeHeaders(3, buffer, http2Headers, sensitivityDetector);
            byte[] bytes = new byte[buffer.readableBytes()];
            buffer.readBytes(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            buffer.release();
        }
    }

    private static Http2Headers toHttp2Headers(List<HpackHeaderField> inHeaders) {
        DefaultHttp2Headers headers = new DefaultHttp2Headers(false);
        for (HpackHeaderField e : inHeaders) {
            headers.add((Object)e.name, (Object)e.value);
        }
        return headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<HpackHeaderField> decode(HpackDecoder hpackDecoder, byte[] expected) throws Exception {
        ByteBuf in = Unpooled.wrappedBuffer((byte[])expected);
        try {
            ArrayList<HpackHeaderField> headers = new ArrayList<HpackHeaderField>();
            TestHeaderListener listener = new TestHeaderListener(headers);
            hpackDecoder.decode(0, in, (Http2Headers)listener, true);
            ArrayList<HpackHeaderField> arrayList = headers;
            return arrayList;
        }
        finally {
            in.release();
        }
    }

    private static String concat(List<String> l) {
        StringBuilder ret = new StringBuilder();
        for (String s : l) {
            ret.append(s);
        }
        return ret.toString();
    }

    private static boolean headersEqual(List<HpackHeaderField> expected, List<HpackHeaderField> actual) {
        if (expected.size() != actual.size()) {
            return false;
        }
        for (int i = 0; i < expected.size(); ++i) {
            if (expected.get(i).equalsForTest(actual.get(i))) continue;
            return false;
        }
        return true;
    }

    static class HeaderFieldDeserializer
    implements JsonDeserializer<HpackHeaderField> {
        HeaderFieldDeserializer() {
        }

        public HpackHeaderField deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            JsonObject jsonObject = json.getAsJsonObject();
            Set entrySet = jsonObject.entrySet();
            if (entrySet.size() != 1) {
                throw new JsonParseException("JSON Object has multiple entries: " + entrySet);
            }
            Map.Entry entry = (Map.Entry)entrySet.iterator().next();
            String name = (String)entry.getKey();
            String value = ((JsonElement)entry.getValue()).getAsString();
            return new HpackHeaderField((CharSequence)name, (CharSequence)value);
        }
    }

    static class HeaderBlock {
        private int maxHeaderTableSize = -1;
        private byte[] encodedBytes;
        private List<String> encoded;
        private List<HpackHeaderField> headers;
        private List<HpackHeaderField> dynamicTable;
        private int tableSize;

        HeaderBlock() {
        }

        private int getMaxHeaderTableSize() {
            return this.maxHeaderTableSize;
        }

        public String getEncodedStr() {
            return HpackTestCase.concat(this.encoded).replaceAll(" ", "");
        }

        public List<HpackHeaderField> getHeaders() {
            return this.headers;
        }

        public List<HpackHeaderField> getDynamicTable() {
            return this.dynamicTable;
        }

        public int getTableSize() {
            return this.tableSize;
        }

        static /* synthetic */ byte[] access$002(HeaderBlock x0, byte[] x1) {
            x0.encodedBytes = x1;
            return x1;
        }
    }
}

