/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersDecoder;
import io.netty.handler.codec.http2.HpackEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.handler.codec.http2.Http2TestUtil;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultHttp2HeadersDecoderTest {
    private DefaultHttp2HeadersDecoder decoder;

    @Before
    public void setup() {
        this.decoder = new DefaultHttp2HeadersDecoder(false);
    }

    @Test
    public void decodeShouldSucceed() throws Exception {
        ByteBuf buf = DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"), DefaultHttp2HeadersDecoderTest.b("akey"), DefaultHttp2HeadersDecoderTest.b("avalue"), Http2TestUtil.randomBytes(), Http2TestUtil.randomBytes());
        try {
            Http2Headers headers = this.decoder.decodeHeaders(0, buf);
            Assert.assertEquals((long)3L, (long)headers.size());
            Assert.assertEquals((Object)"GET", (Object)headers.method().toString());
            Assert.assertEquals((Object)"avalue", (Object)((CharSequence)headers.get((Object)new AsciiString((CharSequence)"akey"))).toString());
        }
        finally {
            buf.release();
        }
    }

    @Test(expected=Http2Exception.class)
    public void testExceedHeaderSize() throws Exception {
        int maxListSize = 100;
        this.decoder.configuration().maxHeaderListSize(100L, 100L);
        ByteBuf buf = DefaultHttp2HeadersDecoderTest.encode(Http2TestUtil.randomBytes(100), Http2TestUtil.randomBytes(1));
        try {
            this.decoder.decodeHeaders(0, buf);
            Assert.fail();
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void decodeLargerThanHeaderListSizeButLessThanGoAway() throws Exception {
        this.decoder.maxHeaderListSize(0L, 0xFFFFFFFFL);
        ByteBuf buf = DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"));
        boolean streamId = true;
        try {
            this.decoder.decodeHeaders(1, buf);
            Assert.fail();
        }
        catch (Http2Exception.HeaderListSizeException e) {
            Assert.assertEquals((long)1L, (long)e.streamId());
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void decodeLargerThanHeaderListSizeButLessThanGoAwayWithInitialDecoderSettings() throws Exception {
        ByteBuf buf = DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"), DefaultHttp2HeadersDecoderTest.b("test_header"), DefaultHttp2HeadersDecoderTest.b(String.format("%09000d", 0).replace('0', 'A')));
        boolean streamId = true;
        try {
            this.decoder.decodeHeaders(1, buf);
            Assert.fail();
        }
        catch (Http2Exception.HeaderListSizeException e) {
            Assert.assertEquals((long)1L, (long)e.streamId());
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void decodeLargerThanHeaderListSizeGoAway() throws Exception {
        this.decoder.maxHeaderListSize(0L, 0L);
        ByteBuf buf = DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"));
        boolean streamId = true;
        try {
            this.decoder.decodeHeaders(1, buf);
            Assert.fail();
        }
        catch (Http2Exception e) {
            Assert.assertEquals((Object)Http2Error.PROTOCOL_ERROR, (Object)e.error());
        }
        finally {
            buf.release();
        }
    }

    private static byte[] b(String string) {
        return string.getBytes(CharsetUtil.UTF_8);
    }

    private static ByteBuf encode(byte[] ... entries) throws Exception {
        HpackEncoder hpackEncoder = Http2TestUtil.newTestEncoder();
        ByteBuf out = Unpooled.buffer();
        DefaultHttp2Headers http2Headers = new DefaultHttp2Headers(false);
        int ix = 0;
        while (ix < entries.length) {
            http2Headers.add((Object)new AsciiString(entries[ix++], false), (Object)new AsciiString(entries[ix++], false));
        }
        hpackEncoder.encodeHeaders(3, out, (Http2Headers)http2Headers, Http2HeadersEncoder.NEVER_SENSITIVE);
        return out;
    }
}

