/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.DefaultHttp2SettingsFrame;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2MultiplexCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2SettingsAckFrame;
import io.netty.handler.codec.http2.Http2SettingsFrame;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Http2MultiplexTransportTest {
    private static final ChannelHandler DISCARD_HANDLER = new ChannelInboundHandlerAdapter(){

        public boolean isSharable() {
            return true;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            ReferenceCountUtil.release((Object)msg);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            ReferenceCountUtil.release((Object)evt);
        }
    };
    private EventLoopGroup eventLoopGroup;
    private Channel clientChannel;
    private Channel serverChannel;
    private Channel serverConnectedChannel;

    @Before
    public void setup() {
        this.eventLoopGroup = new NioEventLoopGroup();
    }

    @After
    public void teardown() {
        if (this.clientChannel != null) {
            this.clientChannel.close();
        }
        if (this.serverChannel != null) {
            this.serverChannel.close();
        }
        if (this.serverConnectedChannel != null) {
            this.serverConnectedChannel.close();
        }
        this.eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
    }

    @Test(timeout=10000L)
    public void asyncSettingsAckWithMultiplexCodec() throws InterruptedException {
        this.asyncSettingsAck0((Http2FrameCodec)new Http2MultiplexCodecBuilder(true, DISCARD_HANDLER).build(), null);
    }

    @Test(timeout=10000L)
    public void asyncSettingsAckWithMultiplexHandler() throws InterruptedException {
        this.asyncSettingsAck0(new Http2FrameCodecBuilder(true).build(), (ChannelHandler)new Http2MultiplexHandler(DISCARD_HANDLER));
    }

    private void asyncSettingsAck0(final Http2FrameCodec codec, final ChannelHandler multiplexer) throws InterruptedException {
        final CountDownLatch serverAckOneLatch = new CountDownLatch(1);
        final CountDownLatch serverAckAllLatch = new CountDownLatch(2);
        final CountDownLatch clientSettingsLatch = new CountDownLatch(2);
        final CountDownLatch serverConnectedChannelLatch = new CountDownLatch(1);
        final AtomicReference serverConnectedChannelRef = new AtomicReference();
        ServerBootstrap sb = new ServerBootstrap();
        sb.group(this.eventLoopGroup);
        sb.channel(NioServerSocketChannel.class);
        sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{codec});
                if (multiplexer != null) {
                    ch.pipeline().addLast(new ChannelHandler[]{multiplexer});
                }
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelActive(ChannelHandlerContext ctx) {
                        serverConnectedChannelRef.set(ctx.channel());
                        serverConnectedChannelLatch.countDown();
                    }

                    public void channelRead(ChannelHandlerContext ctx, Object msg) {
                        if (msg instanceof Http2SettingsAckFrame) {
                            serverAckOneLatch.countDown();
                            serverAckAllLatch.countDown();
                        }
                        ReferenceCountUtil.release((Object)msg);
                    }
                }});
            }
        });
        this.serverChannel = sb.bind((SocketAddress)new InetSocketAddress(NetUtil.LOCALHOST, 0)).awaitUninterruptibly().channel();
        Bootstrap bs = new Bootstrap();
        bs.group(this.eventLoopGroup);
        bs.channel(NioSocketChannel.class);
        bs.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{Http2MultiplexCodecBuilder.forClient((ChannelHandler)DISCARD_HANDLER).autoAckSettingsFrame(false).build()});
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) {
                        if (msg instanceof Http2SettingsFrame) {
                            clientSettingsLatch.countDown();
                        }
                        ReferenceCountUtil.release((Object)msg);
                    }
                }});
            }
        });
        this.clientChannel = bs.connect(this.serverChannel.localAddress()).awaitUninterruptibly().channel();
        serverConnectedChannelLatch.await();
        this.serverConnectedChannel = (Channel)serverConnectedChannelRef.get();
        this.serverConnectedChannel.writeAndFlush((Object)new DefaultHttp2SettingsFrame(new Http2Settings().maxConcurrentStreams(10L))).sync();
        clientSettingsLatch.await();
        Assert.assertFalse((boolean)serverAckOneLatch.await(300L, TimeUnit.MILLISECONDS));
        this.clientChannel.writeAndFlush((Object)Http2SettingsAckFrame.INSTANCE).sync();
        this.clientChannel.writeAndFlush((Object)Http2SettingsAckFrame.INSTANCE).sync();
        serverAckAllLatch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testFlushNotDiscarded() throws InterruptedException {
        final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);
        try {
            ServerBootstrap sb = new ServerBootstrap();
            sb.group(this.eventLoopGroup);
            sb.channel(NioServerSocketChannel.class);
            sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new Http2FrameCodecBuilder(true).build()});
                    ch.pipeline().addLast(new ChannelHandler[]{new Http2MultiplexHandler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                        public void channelRead(final ChannelHandlerContext ctx, Object msg) {
                            if (msg instanceof Http2HeadersFrame && ((Http2HeadersFrame)msg).isEndStream()) {
                                executorService.schedule(new Runnable(){

                                    @Override
                                    public void run() {
                                        ctx.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers(), false)).addListener((GenericFutureListener)new ChannelFutureListener(){

                                            public void operationComplete(ChannelFuture future) {
                                                ctx.write((Object)new DefaultHttp2DataFrame(Unpooled.copiedBuffer((CharSequence)"Hello World", (Charset)CharsetUtil.US_ASCII), true));
                                                ctx.channel().eventLoop().execute(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        ctx.flush();
                                                    }
                                                });
                                            }
                                        });
                                    }
                                }, 500L, TimeUnit.MILLISECONDS);
                            }
                            ReferenceCountUtil.release((Object)msg);
                        }
                    })});
                }
            });
            this.serverChannel = sb.bind((SocketAddress)new InetSocketAddress(NetUtil.LOCALHOST, 0)).syncUninterruptibly().channel();
            final CountDownLatch latch = new CountDownLatch(1);
            Bootstrap bs = new Bootstrap();
            bs.group(this.eventLoopGroup);
            bs.channel(NioSocketChannel.class);
            bs.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new Http2FrameCodecBuilder(false).build()});
                    ch.pipeline().addLast(new ChannelHandler[]{new Http2MultiplexHandler(DISCARD_HANDLER)});
                }
            });
            this.clientChannel = bs.connect(this.serverChannel.localAddress()).syncUninterruptibly().channel();
            Http2StreamChannelBootstrap h2Bootstrap = new Http2StreamChannelBootstrap(this.clientChannel);
            h2Bootstrap.handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void channelRead(ChannelHandlerContext ctx, Object msg) {
                    if (msg instanceof Http2DataFrame && ((Http2DataFrame)msg).isEndStream()) {
                        latch.countDown();
                    }
                    ReferenceCountUtil.release((Object)msg);
                }
            });
            Http2StreamChannel streamChannel = (Http2StreamChannel)h2Bootstrap.open().syncUninterruptibly().getNow();
            streamChannel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers(), true)).syncUninterruptibly();
            latch.await();
        }
        finally {
            executorService.shutdown();
        }
    }
}

