/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.Http2Settings;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Http2SettingsTest {
    private Http2Settings settings;

    @Before
    public void setup() {
        this.settings = new Http2Settings();
    }

    @Test
    public void standardSettingsShouldBeNotSet() {
        Assert.assertEquals((long)0L, (long)this.settings.size());
        Assert.assertNull((Object)this.settings.headerTableSize());
        Assert.assertNull((Object)this.settings.initialWindowSize());
        Assert.assertNull((Object)this.settings.maxConcurrentStreams());
        Assert.assertNull((Object)this.settings.pushEnabled());
        Assert.assertNull((Object)this.settings.maxFrameSize());
        Assert.assertNull((Object)this.settings.maxHeaderListSize());
    }

    @Test
    public void standardSettingsShouldBeSet() {
        this.settings.initialWindowSize(1);
        this.settings.maxConcurrentStreams(2L);
        this.settings.pushEnabled(true);
        this.settings.headerTableSize(3L);
        this.settings.maxFrameSize(0xFFFFFF);
        this.settings.maxHeaderListSize(4L);
        Assert.assertEquals((long)1L, (long)this.settings.initialWindowSize().intValue());
        Assert.assertEquals((long)2L, (long)this.settings.maxConcurrentStreams());
        Assert.assertTrue((boolean)this.settings.pushEnabled());
        Assert.assertEquals((long)3L, (long)this.settings.headerTableSize());
        Assert.assertEquals((long)0xFFFFFFL, (long)this.settings.maxFrameSize().intValue());
        Assert.assertEquals((long)4L, (long)this.settings.maxHeaderListSize());
    }

    @Test
    public void nonStandardSettingsShouldBeSet() {
        char key = '\u0000';
        this.settings.put(key, Long.valueOf(123L));
        Assert.assertEquals((long)123L, (long)((Long)this.settings.get(key)));
    }

    @Test
    public void settingsShouldSupportUnsignedShort() {
        char key = '\u8000';
        this.settings.put(key, Long.valueOf(123L));
        Assert.assertEquals((long)123L, (long)((Long)this.settings.get(key)));
    }

    @Test
    public void headerListSizeUnsignedInt() {
        this.settings.maxHeaderListSize(0xFFFFFFFFL);
        Assert.assertEquals((long)0xFFFFFFFFL, (long)this.settings.maxHeaderListSize());
    }

    @Test(expected=IllegalArgumentException.class)
    public void headerListSizeBoundCheck() {
        this.settings.maxHeaderListSize(Long.MAX_VALUE);
    }

    @Test
    public void headerTableSizeUnsignedInt() {
        this.settings.put('\u0001', Long.valueOf(0xFFFFFFFFL));
        Assert.assertEquals((long)0xFFFFFFFFL, (long)((Long)this.settings.get('\u0001')));
    }

    @Test(expected=IllegalArgumentException.class)
    public void headerTableSizeBoundCheck() {
        this.settings.put('\u0001', Long.valueOf(Long.MAX_VALUE));
    }

    @Test(expected=IllegalArgumentException.class)
    public void headerTableSizeBoundCheck2() {
        this.settings.put('\u0001', Long.valueOf(-1L));
    }
}

