/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersDecoder;
import io.netty.handler.codec.http2.DefaultHttp2HeadersEncoder;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2TestUtil;
import io.netty.util.AsciiString;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Http2HeaderBlockIOTest {
    private DefaultHttp2HeadersDecoder decoder;
    private DefaultHttp2HeadersEncoder encoder;
    private ByteBuf buffer;

    @Before
    public void setup() {
        this.encoder = new DefaultHttp2HeadersEncoder();
        this.decoder = new DefaultHttp2HeadersDecoder(false);
        this.buffer = Unpooled.buffer();
    }

    @After
    public void teardown() {
        this.buffer.release();
    }

    @Test
    public void roundtripShouldBeSuccessful() throws Http2Exception {
        Http2Headers in = Http2HeaderBlockIOTest.headers();
        this.assertRoundtripSuccessful(in);
    }

    @Test
    public void successiveCallsShouldSucceed() throws Http2Exception {
        Http2Headers in = (Http2Headers)new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"GET")).scheme((CharSequence)new AsciiString((CharSequence)"https")).authority((CharSequence)new AsciiString((CharSequence)"example.org")).path((CharSequence)new AsciiString((CharSequence)"/some/path")).add((Object)new AsciiString((CharSequence)"accept"), (Object)new AsciiString((CharSequence)"*/*"));
        this.assertRoundtripSuccessful(in);
        in = (Http2Headers)((Http2Headers)new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"GET")).scheme((CharSequence)new AsciiString((CharSequence)"https")).authority((CharSequence)new AsciiString((CharSequence)"example.org")).path((CharSequence)new AsciiString((CharSequence)"/some/path/resource1")).add((Object)new AsciiString((CharSequence)"accept"), (Object)new AsciiString((CharSequence)"image/jpeg"))).add((Object)new AsciiString((CharSequence)"cache-control"), (Object)new AsciiString((CharSequence)"no-cache"));
        this.assertRoundtripSuccessful(in);
        in = (Http2Headers)((Http2Headers)new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"GET")).scheme((CharSequence)new AsciiString((CharSequence)"https")).authority((CharSequence)new AsciiString((CharSequence)"example.org")).path((CharSequence)new AsciiString((CharSequence)"/some/path/resource2")).add((Object)new AsciiString((CharSequence)"accept"), (Object)new AsciiString((CharSequence)"image/png"))).add((Object)new AsciiString((CharSequence)"cache-control"), (Object)new AsciiString((CharSequence)"no-cache"));
        this.assertRoundtripSuccessful(in);
    }

    @Test
    public void setMaxHeaderSizeShouldBeSuccessful() throws Http2Exception {
        this.encoder.maxHeaderTableSize(10L);
        Http2Headers in = Http2HeaderBlockIOTest.headers();
        this.assertRoundtripSuccessful(in);
        Assert.assertEquals((long)10L, (long)this.decoder.maxHeaderTableSize());
    }

    private void assertRoundtripSuccessful(Http2Headers in) throws Http2Exception {
        this.encoder.encodeHeaders(3, in, this.buffer);
        Http2Headers out = this.decoder.decodeHeaders(0, this.buffer);
        Assert.assertEquals((Object)in, (Object)out);
    }

    private static Http2Headers headers() {
        return (Http2Headers)((Http2Headers)((Http2Headers)((Http2Headers)((Http2Headers)((Http2Headers)((Http2Headers)new DefaultHttp2Headers(false).method((CharSequence)new AsciiString((CharSequence)"GET")).scheme((CharSequence)new AsciiString((CharSequence)"https")).authority((CharSequence)new AsciiString((CharSequence)"example.org")).path((CharSequence)new AsciiString((CharSequence)"/some/path/resource2")).add((Object)new AsciiString((CharSequence)"accept"), (Object)new AsciiString((CharSequence)"image/png"))).add((Object)new AsciiString((CharSequence)"cache-control"), (Object)new AsciiString((CharSequence)"no-cache"))).add((Object)new AsciiString((CharSequence)"custom"), (Object)new AsciiString((CharSequence)"value1"))).add((Object)new AsciiString((CharSequence)"custom"), (Object)new AsciiString((CharSequence)"value2"))).add((Object)new AsciiString((CharSequence)"custom"), (Object)new AsciiString((CharSequence)"value3"))).add((Object)new AsciiString((CharSequence)"custom"), (Object)new AsciiString((CharSequence)"custom4"))).add((Object)Http2TestUtil.randomString(), (Object)Http2TestUtil.randomString());
    }
}

