/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2EmptyDataFrameConnectionDecoder;
import io.netty.handler.codec.http2.Http2EmptyDataFrameListener;
import io.netty.handler.codec.http2.Http2FrameListener;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class Http2EmptyDataFrameConnectionDecoderTest {
    @Test
    public void testDecoration() {
        Http2ConnectionDecoder delegate = (Http2ConnectionDecoder)Mockito.mock(Http2ConnectionDecoder.class);
        final ArgumentCaptor listenerArgumentCaptor = ArgumentCaptor.forClass(Http2FrameListener.class);
        Mockito.when((Object)delegate.frameListener()).then((Answer)new Answer<Http2FrameListener>(){

            public Http2FrameListener answer(InvocationOnMock invocationOnMock) {
                return (Http2FrameListener)listenerArgumentCaptor.getValue();
            }
        });
        Http2FrameListener listener = (Http2FrameListener)Mockito.mock(Http2FrameListener.class);
        Http2EmptyDataFrameConnectionDecoder decoder = new Http2EmptyDataFrameConnectionDecoder(delegate, 2);
        decoder.frameListener(listener);
        ((Http2ConnectionDecoder)Mockito.verify((Object)delegate)).frameListener((Http2FrameListener)listenerArgumentCaptor.capture());
        Assert.assertThat((Object)decoder.frameListener(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(Http2EmptyDataFrameListener.class)));
        Assert.assertThat((Object)decoder.frameListener0(), (Matcher)CoreMatchers.instanceOf(Http2EmptyDataFrameListener.class));
    }

    @Test
    public void testDecorationWithNull() {
        Http2ConnectionDecoder delegate = (Http2ConnectionDecoder)Mockito.mock(Http2ConnectionDecoder.class);
        Http2EmptyDataFrameConnectionDecoder decoder = new Http2EmptyDataFrameConnectionDecoder(delegate, 2);
        decoder.frameListener(null);
        Assert.assertNull((Object)decoder.frameListener());
    }
}

