/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.AbstractWeightedFairQueueByteDistributorDependencyTest;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.StreamByteDistributor;
import io.netty.handler.codec.http2.WeightedFairQueueByteDistributor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class WeightedFairQueueByteDistributorTest
extends AbstractWeightedFairQueueByteDistributorDependencyTest {
    private static final int STREAM_A = 1;
    private static final int STREAM_B = 3;
    private static final int STREAM_C = 5;
    private static final int STREAM_D = 7;
    private static final int STREAM_E = 9;
    private static final int ALLOCATION_QUANTUM = 100;

    @Before
    public void setup() throws Http2Exception {
        MockitoAnnotations.initMocks((Object)this);
        ((StreamByteDistributor.Writer)Mockito.doAnswer(this.writeAnswer(false)).when((Object)this.writer)).write((Http2Stream)Mockito.any(Http2Stream.class), Mockito.anyInt());
        this.setup(-1);
    }

    private void setup(int maxStateOnlySize) throws Http2Exception {
        this.connection = new DefaultHttp2Connection(false);
        this.distributor = maxStateOnlySize >= 0 ? new WeightedFairQueueByteDistributor(this.connection, maxStateOnlySize) : new WeightedFairQueueByteDistributor(this.connection);
        this.distributor.allocationQuantum(100);
        this.connection.local().createStream(1, false);
        this.connection.local().createStream(3, false);
        Http2Stream streamC = this.connection.local().createStream(5, false);
        Http2Stream streamD = this.connection.local().createStream(7, false);
        this.setPriority(streamC.id(), 1, 16, false);
        this.setPriority(streamD.id(), 1, 16, false);
    }

    @Test
    public void writeWithNonActiveStreamShouldNotDobuleAddToPriorityQueue() throws Http2Exception {
        this.initState(1, 400L, true);
        this.initState(3, 500L, true);
        this.initState(5, 600L, true);
        this.initState(7, 700L, true);
        this.setPriority(3, 1, 16, true);
        this.setPriority(7, 5, 16, true);
        this.initState(3, 0L, false);
        Http2Stream streamA = this.stream(1);
        Http2Stream streamB = this.stream(3);
        Http2Stream streamC = this.stream(5);
        Http2Stream streamD = this.stream(7);
        Mockito.reset((Object[])new StreamByteDistributor.Writer[]{this.writer});
        ((StreamByteDistributor.Writer)Mockito.doAnswer(this.writeAnswer(true)).when((Object)this.writer)).write((Http2Stream)Mockito.any(Http2Stream.class), Mockito.anyInt());
        Assert.assertFalse((boolean)this.write(1700));
        Assert.assertEquals((long)400L, (long)this.captureWrites(streamA));
        this.verifyNeverWrite(streamB);
        Assert.assertEquals((long)600L, (long)this.captureWrites(streamC));
        Assert.assertEquals((long)700L, (long)this.captureWrites(streamD));
    }

    @Test
    public void bytesUnassignedAfterProcessing() throws Http2Exception {
        this.initState(1, 1L, true);
        this.initState(3, 2L, true);
        this.initState(5, 3L, true);
        this.initState(7, 4L, true);
        Assert.assertFalse((boolean)this.write(10));
        this.verifyWrite(1, 1);
        this.verifyWrite(3, 2);
        this.verifyWrite(5, 3);
        this.verifyWrite(7, 4);
        Assert.assertFalse((boolean)this.write(10));
        this.verifyAnyWrite(1, 1);
        this.verifyAnyWrite(3, 1);
        this.verifyAnyWrite(5, 1);
        this.verifyAnyWrite(7, 1);
    }

    @Test
    public void connectionErrorForWriterException() throws Http2Exception {
        this.initState(1, 1L, true);
        this.initState(3, 2L, true);
        this.initState(5, 3L, true);
        this.initState(7, 4L, true);
        RuntimeException fakeException = new RuntimeException("Fake exception");
        ((StreamByteDistributor.Writer)Mockito.doThrow((Throwable[])new Throwable[]{fakeException}).when((Object)this.writer)).write((Http2Stream)Mockito.same((Object)this.stream(5)), Mockito.eq((int)3));
        try {
            this.write(10);
            Assert.fail((String)"Expected an exception");
        }
        catch (Http2Exception e) {
            Assert.assertFalse((boolean)Http2Exception.isStreamError((Http2Exception)e));
            Assert.assertEquals((Object)Http2Error.INTERNAL_ERROR, (Object)e.error());
            Assert.assertSame((Object)fakeException, (Object)e.getCause());
        }
        this.verifyWrite(Mockito.atMost((int)1), 1, 1);
        this.verifyWrite(Mockito.atMost((int)1), 3, 2);
        this.verifyWrite(5, 3);
        this.verifyWrite(Mockito.atMost((int)1), 7, 4);
        ((StreamByteDistributor.Writer)Mockito.doAnswer(this.writeAnswer(false)).when((Object)this.writer)).write((Http2Stream)Mockito.same((Object)this.stream(5)), Mockito.eq((int)3));
        Assert.assertFalse((boolean)this.write(10));
        this.verifyWrite(1, 1);
        this.verifyWrite(3, 2);
        this.verifyWrite(Mockito.times((int)2), 5, 3);
        this.verifyWrite(7, 4);
    }

    @Test
    public void minChunkShouldBeAllocatedPerStream() throws Http2Exception {
        this.setPriority(1, 0, 50, false);
        this.setPriority(3, 0, 200, false);
        this.setPriority(5, 1, 100, false);
        this.setPriority(7, 1, 100, false);
        this.initState(1, 100L, true);
        this.initState(3, 100L, true);
        this.initState(5, 100L, true);
        this.initState(7, 100L, true);
        int written = 300;
        Assert.assertTrue((boolean)this.write(written));
        Assert.assertEquals((long)100L, (long)this.captureWrites(1));
        Assert.assertEquals((long)100L, (long)this.captureWrites(3));
        Assert.assertEquals((long)100L, (long)this.captureWrites(5));
        this.verifyWrite(Mockito.atMost((int)1), 7, 0);
        Assert.assertFalse((boolean)this.write(100));
        Assert.assertEquals((long)100L, (long)this.captureWrites(1));
        Assert.assertEquals((long)100L, (long)this.captureWrites(3));
        Assert.assertEquals((long)100L, (long)this.captureWrites(5));
        Assert.assertEquals((long)100L, (long)this.captureWrites(7));
    }

    @Test
    public void emptyFrameAtHeadIsWritten() throws Http2Exception {
        this.initState(1, 0L, true);
        this.initState(3, 0L, true);
        this.initState(5, 0L, true);
        this.initState(7, 10L, true);
        this.setPriority(3, 1, 16, true);
        Assert.assertFalse((boolean)this.write(10));
        this.verifyWrite(1, 0);
        this.verifyWrite(3, 0);
        this.verifyWrite(5, 0);
        this.verifyWrite(7, 10);
    }

    @Test
    public void blockedStreamNoDataShouldSpreadDataToChildren() throws Http2Exception {
        this.blockedStreamShouldSpreadDataToChildren(false);
    }

    @Test
    public void blockedStreamWithDataAndNotAllowedToSendShouldSpreadDataToChildren() throws Http2Exception {
        this.initState(1, 0L, true, false);
        this.blockedStreamShouldSpreadDataToChildren(false);
    }

    @Test
    public void streamWithZeroFlowControlWindowAndDataShouldWriteOnlyOnce() throws Http2Exception {
        this.initState(1, 0L, true, true);
        this.blockedStreamShouldSpreadDataToChildren(true);
        this.initState(1, 0L, true, true);
        Assert.assertFalse((boolean)this.write(1));
        this.verifyWrite(Mockito.times((int)2), 1, 0);
        Assert.assertFalse((boolean)this.write(1));
        this.verifyWrite(Mockito.times((int)2), 1, 0);
    }

    private void blockedStreamShouldSpreadDataToChildren(boolean streamAShouldWriteZero) throws Http2Exception {
        this.initState(3, 10L, true);
        this.initState(5, 10L, true);
        this.initState(7, 10L, true);
        Assert.assertTrue((boolean)this.write(10));
        if (streamAShouldWriteZero) {
            this.verifyWrite(1, 0);
        } else {
            this.verifyNeverWrite(1);
        }
        this.verifyWrite(Mockito.atMost((int)1), 5, 0);
        this.verifyWrite(Mockito.atMost((int)1), 7, 0);
        this.verifyWrite(3, 10);
        Assert.assertTrue((boolean)this.write(5));
        if (streamAShouldWriteZero) {
            this.verifyWrite(Mockito.times((int)1), 1, 0);
        } else {
            this.verifyNeverWrite(1);
        }
        this.verifyWrite(7, 5);
        this.verifyWrite(Mockito.atMost((int)1), 5, 0);
        Assert.assertTrue((boolean)this.write(5));
        if (streamAShouldWriteZero) {
            this.verifyWrite(Mockito.times((int)1), 1, 0);
        } else {
            this.verifyNeverWrite(1);
        }
        Assert.assertEquals((long)10L, (long)(this.captureWrites(5) + this.captureWrites(7)));
        Assert.assertTrue((boolean)this.write(5));
        Assert.assertFalse((boolean)this.write(5));
        if (streamAShouldWriteZero) {
            this.verifyWrite(Mockito.times((int)1), 1, 0);
        } else {
            this.verifyNeverWrite(1);
        }
        this.verifyWrite(Mockito.times((int)2), 5, 5);
        this.verifyWrite(Mockito.times((int)2), 7, 5);
    }

    @Test
    public void childrenShouldNotSendDataUntilParentBlocked() throws Http2Exception {
        this.initState(1, 10L, true);
        this.initState(5, 10L, true);
        this.initState(7, 10L, true);
        Assert.assertTrue((boolean)this.write(10));
        this.verifyWrite(1, 10);
        this.verifyNeverWrite(3);
        this.verifyWrite(Mockito.atMost((int)1), 5, 0);
        this.verifyWrite(Mockito.atMost((int)1), 7, 0);
    }

    @Test
    public void parentShouldWaterFallDataToChildren() throws Http2Exception {
        this.initState(1, 5L, true);
        this.initState(5, 10L, true);
        this.initState(7, 10L, true);
        Assert.assertTrue((boolean)this.write(10));
        this.verifyWrite(1, 5);
        this.verifyNeverWrite(3);
        this.verifyWrite(5, 5);
        this.verifyNeverWrite(7);
        Assert.assertFalse((boolean)this.write(15));
        this.verifyAnyWrite(1, 1);
        this.verifyNeverWrite(3);
        this.verifyWrite(Mockito.times((int)2), 5, 5);
        this.verifyWrite(7, 10);
    }

    @Test
    public void reprioritizeShouldAdjustOutboundFlow() throws Http2Exception {
        this.initState(1, 10L, true);
        this.initState(5, 10L, true);
        this.initState(7, 10L, true);
        this.setPriority(7, 0, 16, false);
        Assert.assertTrue((boolean)this.write(10));
        this.verifyWrite(1, 10);
        this.verifyNeverWrite(3);
        this.verifyNeverWrite(5);
        this.verifyWrite(Mockito.atMost((int)1), 7, 0);
        Assert.assertFalse((boolean)this.write(20));
        this.verifyAnyWrite(1, 1);
        this.verifyNeverWrite(3);
        this.verifyWrite(5, 10);
        this.verifyWrite(7, 10);
    }

    @Test
    public void unstreamableParentsShouldFeedHungryChildren() throws Http2Exception {
        this.setPriority(1, 0, 32, false);
        this.setPriority(3, 0, 16, false);
        this.setPriority(5, 0, 16, false);
        this.setPriority(7, 1, 16, false);
        int writableBytes = 100;
        boolean expectedUnsentAmount = true;
        this.initState(7, 101L, true);
        Assert.assertTrue((boolean)this.write(100));
        this.verifyWrite(7, 100);
        Assert.assertFalse((boolean)this.write(1));
        this.verifyWrite(7, 1);
    }

    @Test
    public void writeShouldPreferHighestWeight() throws Http2Exception {
        this.setPriority(1, 0, 50, false);
        this.setPriority(3, 0, 200, false);
        this.setPriority(5, 0, 100, false);
        this.setPriority(7, 0, 100, false);
        this.initState(1, 1000L, true);
        this.initState(3, 1000L, true);
        this.initState(5, 1000L, true);
        this.initState(7, 1000L, true);
        this.distributor.allocationQuantum(1);
        Assert.assertTrue((boolean)this.write(1000));
        Assert.assertEquals((long)100L, (long)this.captureWrites(1));
        Assert.assertEquals((long)450L, (long)this.captureWrites(3));
        Assert.assertEquals((long)225L, (long)this.captureWrites(5));
        Assert.assertEquals((long)225L, (long)this.captureWrites(7));
    }

    @Test
    public void writeShouldFavorPriority() throws Http2Exception {
        this.setPriority(1, 0, 50, false);
        this.setPriority(3, 0, 200, false);
        this.setPriority(5, 0, 100, false);
        this.setPriority(7, 0, 100, false);
        this.initState(1, 1000L, true);
        this.initState(3, 1000L, true);
        this.initState(5, 1000L, false);
        this.initState(7, 1000L, false);
        this.distributor.allocationQuantum(1);
        Assert.assertTrue((boolean)this.write(100));
        Assert.assertEquals((long)20L, (long)this.captureWrites(1));
        this.verifyWrite(Mockito.times((int)20), 1, 1);
        Assert.assertEquals((long)80L, (long)this.captureWrites(3));
        this.verifyWrite(Mockito.times((int)0), 3, 1);
        this.verifyNeverWrite(5);
        this.verifyNeverWrite(7);
        Assert.assertTrue((boolean)this.write(100));
        Assert.assertEquals((long)40L, (long)this.captureWrites(1));
        this.verifyWrite(Mockito.times((int)40), 1, 1);
        Assert.assertEquals((long)160L, (long)this.captureWrites(3));
        this.verifyWrite(Mockito.atMost((int)1), 3, 1);
        this.verifyNeverWrite(5);
        this.verifyNeverWrite(7);
        Assert.assertTrue((boolean)this.write(1050));
        Assert.assertEquals((long)250L, (long)this.captureWrites(1));
        this.verifyWrite(Mockito.times((int)250), 1, 1);
        Assert.assertEquals((long)1000L, (long)this.captureWrites(3));
        this.verifyWrite(Mockito.atMost((int)2), 3, 1);
        this.verifyNeverWrite(5);
        this.verifyNeverWrite(7);
        Assert.assertFalse((boolean)this.write(750));
        Assert.assertEquals((long)1000L, (long)this.captureWrites(1));
        this.verifyWrite(Mockito.times((int)1), 1, 750);
        Assert.assertEquals((long)1000L, (long)this.captureWrites(3));
        this.verifyWrite(Mockito.times((int)0), 3, 0);
        this.verifyNeverWrite(5);
        this.verifyNeverWrite(7);
    }

    @Test
    public void samePriorityShouldDistributeBasedOnData() throws Http2Exception {
        this.setPriority(1, 0, 16, false);
        this.setPriority(3, 0, 16, false);
        this.setPriority(5, 0, 16, false);
        this.setPriority(7, 0, 16, false);
        this.initState(1, 400L, true);
        this.initState(3, 500L, true);
        this.initState(5, 0L, true);
        this.initState(7, 700L, true);
        this.distributor.allocationQuantum(1);
        Assert.assertTrue((boolean)this.write(999));
        Assert.assertEquals((long)333L, (long)this.captureWrites(1));
        Assert.assertEquals((long)333L, (long)this.captureWrites(3));
        this.verifyWrite(Mockito.times((int)1), 5, 0);
        Assert.assertEquals((long)333L, (long)this.captureWrites(7));
    }

    @Test
    public void zeroDistributeShouldWriteAllZeroFrames() throws Http2Exception {
        this.initState(1, 400L, false);
        this.initState(3, 0L, true);
        this.initState(5, 0L, true);
        this.initState(7, 0L, true);
        this.setPriority(3, 1, 16, true);
        Assert.assertFalse((boolean)this.write(0));
        this.verifyNeverWrite(1);
        this.verifyWrite(3, 0);
        this.verifyAnyWrite(3, 1);
        this.verifyWrite(5, 0);
        this.verifyAnyWrite(5, 1);
        this.verifyWrite(7, 0);
        this.verifyAnyWrite(7, 1);
    }

    @Test
    public void nonZeroDistributeShouldWriteAllZeroFramesIfAllEligibleDataIsWritten() throws Http2Exception {
        this.initState(1, 400L, false);
        this.initState(3, 100L, true);
        this.initState(5, 0L, true);
        this.initState(7, 0L, true);
        this.setPriority(3, 1, 16, true);
        Assert.assertFalse((boolean)this.write(100));
        this.verifyNeverWrite(1);
        this.verifyWrite(3, 100);
        this.verifyAnyWrite(3, 1);
        this.verifyWrite(5, 0);
        this.verifyAnyWrite(5, 1);
        this.verifyWrite(7, 0);
        this.verifyAnyWrite(7, 1);
    }

    @Test
    public void bytesDistributedWithRestructureShouldBeCorrect() throws Http2Exception {
        this.initState(1, 400L, true);
        this.initState(3, 500L, true);
        this.initState(5, 600L, true);
        this.initState(7, 700L, true);
        this.setPriority(3, 1, 16, true);
        Assert.assertTrue((boolean)this.write(500));
        Assert.assertEquals((long)400L, (long)this.captureWrites(1));
        this.verifyWrite(3, 100);
        this.verifyNeverWrite(5);
        this.verifyNeverWrite(7);
        Assert.assertTrue((boolean)this.write(400));
        Assert.assertEquals((long)400L, (long)this.captureWrites(1));
        Assert.assertEquals((long)500L, (long)this.captureWrites(3));
        this.verifyWrite(Mockito.atMost((int)1), 5, 0);
        this.verifyWrite(Mockito.atMost((int)1), 7, 0);
        Assert.assertFalse((boolean)this.write(1300));
        Assert.assertEquals((long)400L, (long)this.captureWrites(1));
        Assert.assertEquals((long)500L, (long)this.captureWrites(3));
        Assert.assertEquals((long)600L, (long)this.captureWrites(5));
        Assert.assertEquals((long)700L, (long)this.captureWrites(7));
    }

    @Test
    public void bytesDistributedWithAdditionShouldBeCorrect() throws Http2Exception {
        Http2Stream streamE = this.connection.local().createStream(9, false);
        this.setPriority(streamE.id(), 1, 16, true);
        this.initState(1, 400L, true);
        this.initState(3, 500L, true);
        this.initState(5, 600L, true);
        this.initState(7, 700L, true);
        this.initState(9, 900L, true);
        Assert.assertTrue((boolean)this.write(900));
        Assert.assertEquals((long)400L, (long)this.captureWrites(1));
        Assert.assertEquals((long)500L, (long)this.captureWrites(3));
        this.verifyNeverWrite(5);
        this.verifyNeverWrite(7);
        this.verifyWrite(Mockito.atMost((int)1), 9, 0);
        Assert.assertTrue((boolean)this.write(900));
        Assert.assertEquals((long)400L, (long)this.captureWrites(1));
        Assert.assertEquals((long)500L, (long)this.captureWrites(3));
        this.verifyWrite(Mockito.atMost((int)1), 5, 0);
        this.verifyWrite(Mockito.atMost((int)1), 7, 0);
        Assert.assertEquals((long)900L, (long)this.captureWrites(9));
        Assert.assertFalse((boolean)this.write(1301));
        Assert.assertEquals((long)400L, (long)this.captureWrites(1));
        Assert.assertEquals((long)500L, (long)this.captureWrites(3));
        Assert.assertEquals((long)600L, (long)this.captureWrites(5));
        Assert.assertEquals((long)700L, (long)this.captureWrites(7));
        Assert.assertEquals((long)900L, (long)this.captureWrites(9));
    }

    @Test
    public void bytesDistributedShouldBeCorrectWithInternalStreamClose() throws Http2Exception {
        this.initState(1, 400L, true);
        this.initState(3, 500L, true);
        this.initState(5, 600L, true);
        this.initState(7, 700L, true);
        this.stream(1).close();
        Assert.assertTrue((boolean)this.write(500));
        this.verifyNeverWrite(1);
        Assert.assertEquals((long)500L, (long)(this.captureWrites(3) + this.captureWrites(5) + this.captureWrites(7)));
        Assert.assertFalse((boolean)this.write(1300));
        this.verifyNeverWrite(1);
        Assert.assertEquals((long)500L, (long)this.captureWrites(3));
        Assert.assertEquals((long)600L, (long)this.captureWrites(5));
        Assert.assertEquals((long)700L, (long)this.captureWrites(7));
    }

    @Test
    public void bytesDistributedShouldBeCorrectWithLeafStreamClose() throws Http2Exception {
        this.initState(1, 400L, true);
        this.initState(3, 500L, true);
        this.initState(5, 600L, true);
        this.initState(7, 700L, true);
        this.stream(5).close();
        Assert.assertTrue((boolean)this.write(900));
        Assert.assertEquals((long)400L, (long)this.captureWrites(1));
        Assert.assertEquals((long)500L, (long)this.captureWrites(3));
        this.verifyNeverWrite(5);
        this.verifyWrite(Mockito.atMost((int)1), 7, 0);
        Assert.assertFalse((boolean)this.write(700));
        Assert.assertEquals((long)400L, (long)this.captureWrites(1));
        Assert.assertEquals((long)500L, (long)this.captureWrites(3));
        this.verifyNeverWrite(5);
        Assert.assertEquals((long)700L, (long)this.captureWrites(7));
    }

    @Test
    public void activeStreamDependentOnNewNonActiveStreamGetsQuantum() throws Http2Exception {
        this.setup(0);
        this.initState(7, 700L, true);
        this.setPriority(7, 9, 16, true);
        Assert.assertFalse((boolean)this.write(700));
        Assert.assertEquals((long)700L, (long)this.captureWrites(7));
    }

    @Test
    public void streamWindowLargerThanIntDoesNotInfiniteLoop() throws Http2Exception {
        this.initState(1, 0x80000000L, true, true);
        Assert.assertTrue((boolean)this.write(Integer.MAX_VALUE));
        this.verifyWrite(1, Integer.MAX_VALUE);
        Assert.assertFalse((boolean)this.write(1));
        this.verifyWrite(1, 1);
    }

    private boolean write(int numBytes) throws Http2Exception {
        return this.distributor.distribute(numBytes, this.writer);
    }

    private void verifyWrite(int streamId, int numBytes) {
        ((StreamByteDistributor.Writer)Mockito.verify((Object)this.writer)).write((Http2Stream)Mockito.same((Object)this.stream(streamId)), Mockito.eq((int)numBytes));
    }

    private void verifyWrite(VerificationMode mode, int streamId, int numBytes) {
        ((StreamByteDistributor.Writer)Mockito.verify((Object)this.writer, (VerificationMode)mode)).write((Http2Stream)Mockito.same((Object)this.stream(streamId)), Mockito.eq((int)numBytes));
    }

    private void verifyAnyWrite(int streamId, int times) {
        ((StreamByteDistributor.Writer)Mockito.verify((Object)this.writer, (VerificationMode)Mockito.times((int)times))).write((Http2Stream)Mockito.same((Object)this.stream(streamId)), Mockito.anyInt());
    }

    private void verifyNeverWrite(int streamId) {
        this.verifyNeverWrite(this.stream(streamId));
    }

    private void verifyNeverWrite(Http2Stream stream) {
        ((StreamByteDistributor.Writer)Mockito.verify((Object)this.writer, (VerificationMode)Mockito.never())).write((Http2Stream)Mockito.same((Object)stream), Mockito.anyInt());
    }

    private int captureWrites(int streamId) {
        return this.captureWrites(this.stream(streamId));
    }

    private int captureWrites(Http2Stream stream) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Integer.class);
        ((StreamByteDistributor.Writer)Mockito.verify((Object)this.writer, (VerificationMode)Mockito.atLeastOnce())).write((Http2Stream)Mockito.same((Object)stream), ((Integer)captor.capture()).intValue());
        int total = 0;
        for (Integer x : captor.getAllValues()) {
            total += x.intValue();
        }
        return total;
    }
}

