/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.AbstractWeightedFairQueueByteDistributorDependencyTest;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import io.netty.handler.codec.http2.StreamByteDistributor;
import io.netty.handler.codec.http2.WeightedFairQueueByteDistributor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class WeightedFairQueueByteDistributorDependencyTreeTest
extends AbstractWeightedFairQueueByteDistributorDependencyTest {
    private static final int leadersId = 3;
    private static final int unblockedId = 5;
    private static final int backgroundId = 7;
    private static final int speculativeId = 9;
    private static final int followersId = 11;
    private static final short leadersWeight = 201;
    private static final short unblockedWeight = 101;
    private static final short backgroundWeight = 1;
    private static final short speculativeWeight = 1;
    private static final short followersWeight = 1;

    @Before
    public void setup() throws Http2Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.setup(0);
    }

    private void setup(int maxStateOnlySize) {
        this.connection = new DefaultHttp2Connection(false);
        this.distributor = new WeightedFairQueueByteDistributor(this.connection, maxStateOnlySize);
        ((StreamByteDistributor.Writer)Mockito.doAnswer(this.writeAnswer(false)).when((Object)this.writer)).write((Http2Stream)Mockito.any(Http2Stream.class), Mockito.anyInt());
    }

    @Test
    public void closingStreamWithChildrenDoesNotCauseConcurrentModification() throws Http2Exception {
        Http2Stream streamA = this.connection.local().createStream(1, false);
        int numStreams = WeightedFairQueueByteDistributor.INITIAL_CHILDREN_MAP_SIZE - 1;
        int i = 0;
        int streamId = 3;
        while (i < numStreams) {
            Http2Stream stream = this.connection.local().createStream(streamId, false);
            this.setPriority(stream.id(), streamA.id(), 16, false);
            ++i;
            streamId += WeightedFairQueueByteDistributor.INITIAL_CHILDREN_MAP_SIZE;
        }
        Assert.assertEquals((long)WeightedFairQueueByteDistributor.INITIAL_CHILDREN_MAP_SIZE, (long)this.connection.numActiveStreams());
        streamA.close();
        Assert.assertEquals((long)numStreams, (long)this.connection.numActiveStreams());
    }

    @Test
    public void closeWhileIteratingDoesNotNPE() throws Http2Exception {
        final Http2Stream streamA = this.connection.local().createStream(3, false);
        final Http2Stream streamB = this.connection.local().createStream(5, false);
        final Http2Stream streamC = this.connection.local().createStream(7, false);
        this.setPriority(streamB.id(), streamA.id(), 16, false);
        this.connection.forEachActiveStream(new Http2StreamVisitor(){

            public boolean visit(Http2Stream stream) throws Http2Exception {
                streamA.close();
                WeightedFairQueueByteDistributorDependencyTreeTest.this.setPriority(streamB.id(), streamC.id(), 16, false);
                return true;
            }
        });
    }

    @Test
    public void localStreamCanDependUponIdleStream() throws Http2Exception {
        this.setup(1);
        Http2Stream streamA = this.connection.local().createStream(1, false);
        this.setPriority(3, streamA.id(), 1, true);
        Assert.assertTrue((boolean)this.distributor.isChild(3, streamA.id(), (short)1));
    }

    @Test
    public void remoteStreamCanDependUponIdleStream() throws Http2Exception {
        this.setup(1);
        Http2Stream streamA = this.connection.remote().createStream(2, false);
        this.setPriority(4, streamA.id(), 1, true);
        Assert.assertTrue((boolean)this.distributor.isChild(4, streamA.id(), (short)1));
    }

    @Test
    public void prioritizeShouldUseDefaults() throws Exception {
        Http2Stream stream = this.connection.local().createStream(1, false);
        Assert.assertTrue((boolean)this.distributor.isChild(stream.id(), this.connection.connectionStream().id(), (short)16));
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(stream.id()));
    }

    @Test
    public void reprioritizeWithNoChangeShouldDoNothing() throws Exception {
        Http2Stream stream = this.connection.local().createStream(1, false);
        this.setPriority(stream.id(), this.connection.connectionStream().id(), 16, false);
        Assert.assertTrue((boolean)this.distributor.isChild(stream.id(), this.connection.connectionStream().id(), (short)16));
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(stream.id()));
    }

    @Test
    public void stateOnlyPriorityShouldBePreservedWhenStreamsAreCreatedAndClosed() throws Http2Exception {
        this.setup(3);
        short weight3 = 2;
        short weight5 = (short)(weight3 + 1);
        short weight7 = (short)(weight5 + 1);
        this.setPriority(3, this.connection.connectionStream().id(), weight3, true);
        this.setPriority(5, this.connection.connectionStream().id(), weight5, true);
        this.setPriority(7, this.connection.connectionStream().id(), weight7, true);
        Assert.assertEquals((long)0L, (long)this.connection.numActiveStreams());
        this.verifyStateOnlyPriorityShouldBePreservedWhenStreamsAreCreated(weight3, weight5, weight7);
        Http2Stream streamA = this.connection.local().createStream(3, false);
        Http2Stream streamB = this.connection.local().createStream(5, false);
        Http2Stream streamC = this.connection.local().createStream(7, false);
        Assert.assertEquals((long)3L, (long)this.connection.numActiveStreams());
        this.verifyStateOnlyPriorityShouldBePreservedWhenStreamsAreCreated(weight3, weight5, weight7);
        streamA.close();
        streamB.close();
        streamC.close();
        Assert.assertEquals((long)0L, (long)this.connection.numActiveStreams());
        this.verifyStateOnlyPriorityShouldBePreservedWhenStreamsAreCreated(weight3, weight5, weight7);
    }

    private void verifyStateOnlyPriorityShouldBePreservedWhenStreamsAreCreated(short weight3, short weight5, short weight7) {
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(7, this.connection.connectionStream().id(), weight7));
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(7));
        Assert.assertTrue((boolean)this.distributor.isChild(5, 7, weight5));
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(5));
        Assert.assertTrue((boolean)this.distributor.isChild(3, 5, weight3));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(3));
    }

    @Test
    public void fireFoxQoSStreamsRemainAfterDataStreamsAreClosed() throws Http2Exception {
        this.setup(5);
        this.setPriority(3, this.connection.connectionStream().id(), 201, false);
        this.setPriority(5, this.connection.connectionStream().id(), 101, false);
        this.setPriority(7, this.connection.connectionStream().id(), 1, false);
        this.setPriority(9, 7, 1, false);
        this.setPriority(11, 3, 1, false);
        this.verifyFireFoxQoSStreams();
        short htmlGetStreamWeight = 2;
        Http2Stream htmlGetStream = this.connection.local().createStream(13, false);
        this.setPriority(htmlGetStream.id(), 11, htmlGetStreamWeight, false);
        Http2Stream favIconStream = this.connection.local().createStream(15, false);
        this.setPriority(favIconStream.id(), this.connection.connectionStream().id(), 16, false);
        Http2Stream cssStream = this.connection.local().createStream(17, false);
        this.setPriority(cssStream.id(), 3, 16, false);
        Http2Stream jsStream = this.connection.local().createStream(19, false);
        this.setPriority(jsStream.id(), 3, 16, false);
        Http2Stream imageStream = this.connection.local().createStream(21, false);
        this.setPriority(imageStream.id(), 11, 1, false);
        Assert.assertEquals((long)4L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(3, this.connection.connectionStream().id(), (short)201));
        Assert.assertEquals((long)3L, (long)this.distributor.numChildren(3));
        Assert.assertTrue((boolean)this.distributor.isChild(5, this.connection.connectionStream().id(), (short)101));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(5));
        Assert.assertTrue((boolean)this.distributor.isChild(7, this.connection.connectionStream().id(), (short)1));
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(7));
        Assert.assertTrue((boolean)this.distributor.isChild(favIconStream.id(), this.connection.connectionStream().id(), (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(favIconStream.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(11, 3, (short)1));
        Assert.assertEquals((long)2L, (long)this.distributor.numChildren(11));
        Assert.assertTrue((boolean)this.distributor.isChild(9, 7, (short)1));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(9));
        Assert.assertTrue((boolean)this.distributor.isChild(cssStream.id(), 3, (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(cssStream.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(jsStream.id(), 3, (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(jsStream.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(htmlGetStream.id(), 11, htmlGetStreamWeight));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(htmlGetStream.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(imageStream.id(), 11, (short)1));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(imageStream.id()));
        htmlGetStream.close();
        favIconStream.close();
        cssStream.close();
        jsStream.close();
        imageStream.close();
        this.verifyFireFoxQoSStreams();
    }

    private void verifyFireFoxQoSStreams() {
        Assert.assertEquals((long)3L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(3, this.connection.connectionStream().id(), (short)201));
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(3));
        Assert.assertTrue((boolean)this.distributor.isChild(5, this.connection.connectionStream().id(), (short)101));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(5));
        Assert.assertTrue((boolean)this.distributor.isChild(7, this.connection.connectionStream().id(), (short)1));
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(7));
        Assert.assertTrue((boolean)this.distributor.isChild(11, 3, (short)1));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(11));
        Assert.assertTrue((boolean)this.distributor.isChild(9, 7, (short)1));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(9));
    }

    @Test
    public void lowestPrecedenceStateShouldBeDropped() throws Http2Exception {
        this.setup(3);
        short weight3 = 256;
        short weight5 = (short)(weight3 - 1);
        short weight7 = (short)(weight5 - 1);
        short weight9 = (short)(weight7 - 1);
        this.setPriority(3, this.connection.connectionStream().id(), weight3, true);
        this.setPriority(5, this.connection.connectionStream().id(), weight5, true);
        this.setPriority(7, this.connection.connectionStream().id(), weight7, false);
        Assert.assertEquals((long)0L, (long)this.connection.numActiveStreams());
        this.verifyLowestPrecedenceStateShouldBeDropped1(weight3, weight5, weight7);
        this.setPriority(9, 3, weight9, false);
        Assert.assertEquals((long)0L, (long)this.connection.numActiveStreams());
        this.verifyLowestPrecedenceStateShouldBeDropped1(weight3, weight5, weight7);
        this.setPriority(9, 5, weight9, true);
        this.verifyLowestPrecedenceStateShouldBeDropped2(weight9, weight5, weight7);
        Http2Stream streamA = this.connection.local().createStream(5, false);
        streamA.close();
        this.verifyLowestPrecedenceStateShouldBeDropped2(weight9, weight5, weight7);
        this.setPriority(3, 9, weight3, false);
        this.verifyLowestPrecedenceStateShouldBeDropped3(weight3, weight7, weight9);
        this.setPriority(5, 0, weight5, false);
        this.verifyLowestPrecedenceStateShouldBeDropped4(weight5, weight7, weight9);
        short weight11 = (short)(weight9 - 1);
        this.setPriority(11, 0, weight11, false);
        this.verifyLowestPrecedenceStateShouldBeDropped5(weight7, weight9, weight11);
    }

    private void verifyLowestPrecedenceStateShouldBeDropped1(short weight3, short weight5, short weight7) {
        Assert.assertEquals((long)2L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(7, this.connection.connectionStream().id(), weight7));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(7));
        Assert.assertTrue((boolean)this.distributor.isChild(5, this.connection.connectionStream().id(), weight5));
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(5));
        Assert.assertTrue((boolean)this.distributor.isChild(3, 5, weight3));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(3));
    }

    private void verifyLowestPrecedenceStateShouldBeDropped2(short weight9, short weight5, short weight7) {
        Assert.assertEquals((long)2L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(7, this.connection.connectionStream().id(), weight7));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(7));
        Assert.assertTrue((boolean)this.distributor.isChild(5, this.connection.connectionStream().id(), weight5));
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(5));
        Assert.assertTrue((boolean)this.distributor.isChild(9, 5, weight9));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(9));
    }

    private void verifyLowestPrecedenceStateShouldBeDropped3(short weight3, short weight7, short weight9) {
        Assert.assertEquals((long)2L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(7, this.connection.connectionStream().id(), weight7));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(7));
        Assert.assertTrue((boolean)this.distributor.isChild(9, this.connection.connectionStream().id(), weight9));
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(9));
        Assert.assertTrue((boolean)this.distributor.isChild(3, 9, weight3));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(3));
    }

    private void verifyLowestPrecedenceStateShouldBeDropped4(short weight5, short weight7, short weight9) {
        Assert.assertEquals((long)3L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(5, this.connection.connectionStream().id(), weight5));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(5));
        Assert.assertTrue((boolean)this.distributor.isChild(7, this.connection.connectionStream().id(), weight7));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(7));
        Assert.assertTrue((boolean)this.distributor.isChild(9, this.connection.connectionStream().id(), weight9));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(9));
    }

    private void verifyLowestPrecedenceStateShouldBeDropped5(short weight7, short weight9, short weight11) {
        Assert.assertEquals((long)3L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(11, this.connection.connectionStream().id(), weight11));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(11));
        Assert.assertTrue((boolean)this.distributor.isChild(7, this.connection.connectionStream().id(), weight7));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(7));
        Assert.assertTrue((boolean)this.distributor.isChild(9, this.connection.connectionStream().id(), weight9));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(9));
    }

    @Test
    public void priorityOnlyStreamsArePreservedWhenReservedStreamsAreClosed() throws Http2Exception {
        this.setup(1);
        short weight3 = 1;
        this.setPriority(3, this.connection.connectionStream().id(), weight3, true);
        Http2Stream streamA = this.connection.local().createStream(5, false);
        Http2Stream streamB = this.connection.remote().reservePushStream(4, streamA);
        Assert.assertEquals((long)3L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(3, this.connection.connectionStream().id(), weight3));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(3));
        Assert.assertTrue((boolean)this.distributor.isChild(streamA.id(), this.connection.connectionStream().id(), (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamA.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamB.id(), this.connection.connectionStream().id(), (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamB.id()));
        streamB.close();
        streamA.close();
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(3, this.connection.connectionStream().id(), weight3));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(3));
    }

    @Test
    public void insertExclusiveShouldAddNewLevel() throws Exception {
        Http2Stream streamA = this.connection.local().createStream(1, false);
        Http2Stream streamB = this.connection.local().createStream(3, false);
        Http2Stream streamC = this.connection.local().createStream(5, false);
        Http2Stream streamD = this.connection.local().createStream(7, false);
        this.setPriority(streamB.id(), streamA.id(), 16, false);
        this.setPriority(streamC.id(), streamA.id(), 16, false);
        this.setPriority(streamD.id(), streamA.id(), 16, true);
        Assert.assertEquals((long)4L, (long)this.connection.numActiveStreams());
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamA.id(), this.connection.connectionStream().id(), (short)16));
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(streamA.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamD.id(), streamA.id(), (short)16));
        Assert.assertEquals((long)2L, (long)this.distributor.numChildren(streamD.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamB.id(), streamD.id(), (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamB.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamC.id(), streamD.id(), (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamC.id()));
    }

    @Test
    public void existingChildMadeExclusiveShouldNotCreateTreeCycle() throws Http2Exception {
        Http2Stream streamA = this.connection.local().createStream(1, false);
        Http2Stream streamB = this.connection.local().createStream(3, false);
        Http2Stream streamC = this.connection.local().createStream(5, false);
        Http2Stream streamD = this.connection.local().createStream(7, false);
        this.setPriority(streamB.id(), streamA.id(), 16, false);
        this.setPriority(streamC.id(), streamA.id(), 16, false);
        this.setPriority(streamD.id(), streamC.id(), 16, false);
        this.setPriority(streamC.id(), streamA.id(), 16, true);
        Assert.assertEquals((long)4L, (long)this.connection.numActiveStreams());
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamA.id(), this.connection.connectionStream().id(), (short)16));
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(streamA.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamC.id(), streamA.id(), (short)16));
        Assert.assertEquals((long)2L, (long)this.distributor.numChildren(streamC.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamB.id(), streamC.id(), (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamB.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamD.id(), streamC.id(), (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamD.id()));
    }

    @Test
    public void newExclusiveChildShouldUpdateOldParentCorrectly() throws Http2Exception {
        Http2Stream streamA = this.connection.local().createStream(1, false);
        Http2Stream streamB = this.connection.local().createStream(3, false);
        Http2Stream streamC = this.connection.local().createStream(5, false);
        Http2Stream streamD = this.connection.local().createStream(7, false);
        Http2Stream streamE = this.connection.local().createStream(9, false);
        Http2Stream streamF = this.connection.local().createStream(11, false);
        this.setPriority(streamB.id(), streamA.id(), 16, false);
        this.setPriority(streamC.id(), streamA.id(), 16, false);
        this.setPriority(streamD.id(), streamC.id(), 16, false);
        this.setPriority(streamF.id(), streamE.id(), 16, false);
        this.setPriority(streamF.id(), streamA.id(), 16, true);
        Assert.assertEquals((long)6L, (long)this.connection.numActiveStreams());
        Assert.assertEquals((long)2L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamE.id(), this.connection.connectionStream().id(), (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamE.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamA.id(), this.connection.connectionStream().id(), (short)16));
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(streamA.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamF.id(), streamA.id(), (short)16));
        Assert.assertEquals((long)2L, (long)this.distributor.numChildren(streamF.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamB.id(), streamF.id(), (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamB.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamC.id(), streamF.id(), (short)16));
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(streamC.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamD.id(), streamC.id(), (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamD.id()));
    }

    @Test
    public void weightChangeWithNoTreeChangeShouldBeRespected() throws Http2Exception {
        Http2Stream streamA = this.connection.local().createStream(1, false);
        Http2Stream streamB = this.connection.local().createStream(3, false);
        Http2Stream streamC = this.connection.local().createStream(5, false);
        Http2Stream streamD = this.connection.local().createStream(7, false);
        this.setPriority(streamB.id(), streamA.id(), 16, false);
        this.setPriority(streamC.id(), streamA.id(), 16, false);
        this.setPriority(streamD.id(), streamA.id(), 16, true);
        Assert.assertEquals((long)4L, (long)this.connection.numActiveStreams());
        short newWeight = 17;
        this.setPriority(streamD.id(), streamA.id(), newWeight, false);
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamA.id(), this.connection.connectionStream().id(), (short)16));
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(streamA.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamD.id(), streamA.id(), newWeight));
        Assert.assertEquals((long)2L, (long)this.distributor.numChildren(streamD.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamB.id(), streamD.id(), (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamB.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamC.id(), streamD.id(), (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamC.id()));
    }

    @Test
    public void sameNodeDependentShouldNotStackOverflowNorChangePrioritizableForTree() throws Http2Exception {
        Http2Stream streamA = this.connection.local().createStream(1, false);
        Http2Stream streamB = this.connection.local().createStream(3, false);
        Http2Stream streamC = this.connection.local().createStream(5, false);
        Http2Stream streamD = this.connection.local().createStream(7, false);
        this.setPriority(streamB.id(), streamA.id(), 16, false);
        this.setPriority(streamC.id(), streamA.id(), 16, false);
        this.setPriority(streamD.id(), streamA.id(), 16, true);
        boolean[] exclusives = new boolean[]{true, false};
        short[] weights = new short[]{16, 100, 200, 16};
        Assert.assertEquals((long)4L, (long)this.connection.numActiveStreams());
        for (short weight : weights) {
            for (boolean exclusive : exclusives) {
                this.setPriority(streamD.id(), streamA.id(), weight, exclusive);
                Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamB.id()));
                Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamC.id()));
                Assert.assertEquals((long)1L, (long)this.distributor.numChildren(streamA.id()));
                Assert.assertEquals((long)2L, (long)this.distributor.numChildren(streamD.id()));
                Assert.assertFalse((boolean)this.distributor.isChild(streamB.id(), streamA.id(), (short)16));
                Assert.assertFalse((boolean)this.distributor.isChild(streamC.id(), streamA.id(), (short)16));
                Assert.assertTrue((boolean)this.distributor.isChild(streamB.id(), streamD.id(), (short)16));
                Assert.assertTrue((boolean)this.distributor.isChild(streamC.id(), streamD.id(), (short)16));
                Assert.assertTrue((boolean)this.distributor.isChild(streamD.id(), streamA.id(), weight));
            }
        }
    }

    @Test
    public void multipleCircularDependencyShouldUpdatePrioritizable() throws Http2Exception {
        Http2Stream streamA = this.connection.local().createStream(1, false);
        Http2Stream streamB = this.connection.local().createStream(3, false);
        Http2Stream streamC = this.connection.local().createStream(5, false);
        Http2Stream streamD = this.connection.local().createStream(7, false);
        this.setPriority(streamB.id(), streamA.id(), 16, false);
        this.setPriority(streamC.id(), streamA.id(), 16, false);
        this.setPriority(streamD.id(), streamA.id(), 16, true);
        Assert.assertEquals((long)4L, (long)this.connection.numActiveStreams());
        this.setPriority(streamA.id(), streamB.id(), 16, true);
        this.setPriority(streamC.id(), streamB.id(), 16, false);
        this.setPriority(streamD.id(), streamB.id(), 16, false);
        this.setPriority(streamB.id(), streamA.id(), 16, true);
        this.setPriority(streamC.id(), streamA.id(), 16, false);
        this.setPriority(streamD.id(), streamA.id(), 16, false);
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamA.id(), this.connection.connectionStream().id(), (short)16));
        Assert.assertEquals((long)3L, (long)this.distributor.numChildren(streamA.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamB.id(), streamA.id(), (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamB.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamC.id(), streamA.id(), (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamC.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamD.id(), streamA.id(), (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamD.id()));
    }

    @Test
    public void removeWithPrioritizableDependentsShouldNotRestructureTree() throws Exception {
        Http2Stream streamA = this.connection.local().createStream(1, false);
        Http2Stream streamB = this.connection.local().createStream(3, false);
        Http2Stream streamC = this.connection.local().createStream(5, false);
        Http2Stream streamD = this.connection.local().createStream(7, false);
        this.setPriority(streamB.id(), streamA.id(), 16, false);
        this.setPriority(streamC.id(), streamB.id(), 16, false);
        this.setPriority(streamD.id(), streamB.id(), 16, false);
        streamB.close();
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamA.id(), this.connection.connectionStream().id(), (short)16));
        Assert.assertEquals((long)2L, (long)this.distributor.numChildren(streamA.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamC.id(), streamA.id(), (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamC.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamD.id(), streamA.id(), (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamD.id()));
    }

    @Test
    public void closeWithNoPrioritizableDependentsShouldRestructureTree() throws Exception {
        Http2Stream streamA = this.connection.local().createStream(1, false);
        Http2Stream streamB = this.connection.local().createStream(3, false);
        Http2Stream streamC = this.connection.local().createStream(5, false);
        Http2Stream streamD = this.connection.local().createStream(7, false);
        Http2Stream streamE = this.connection.local().createStream(9, false);
        Http2Stream streamF = this.connection.local().createStream(11, false);
        this.setPriority(streamB.id(), streamA.id(), 16, false);
        this.setPriority(streamC.id(), streamB.id(), 16, false);
        this.setPriority(streamD.id(), streamB.id(), 16, false);
        this.setPriority(streamE.id(), streamC.id(), 16, false);
        this.setPriority(streamF.id(), streamD.id(), 16, false);
        streamA.close();
        streamB.close();
        streamC.close();
        streamD.close();
        streamF.close();
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamE.id(), this.connection.connectionStream().id(), (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamE.id()));
    }

    @Test
    public void priorityChangeWithNoPrioritizableDependentsShouldRestructureTree() throws Exception {
        Http2Stream streamA = this.connection.local().createStream(1, false);
        Http2Stream streamB = this.connection.local().createStream(3, false);
        Http2Stream streamC = this.connection.local().createStream(5, false);
        Http2Stream streamD = this.connection.local().createStream(7, false);
        Http2Stream streamE = this.connection.local().createStream(9, false);
        Http2Stream streamF = this.connection.local().createStream(11, false);
        this.setPriority(streamB.id(), streamA.id(), 16, false);
        this.setPriority(streamC.id(), streamB.id(), 16, false);
        this.setPriority(streamD.id(), streamB.id(), 16, false);
        this.setPriority(streamF.id(), streamD.id(), 16, false);
        this.setPriority(streamE.id(), streamC.id(), 16, false);
        streamA.close();
        streamB.close();
        streamC.close();
        streamD.close();
        this.setPriority(streamF.id(), streamC.id(), 16, false);
        Assert.assertEquals((long)2L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamE.id(), this.connection.connectionStream().id(), (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamE.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamF.id(), this.connection.connectionStream().id(), (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamF.id()));
    }

    @Test
    public void circularDependencyShouldRestructureTree() throws Exception {
        Http2Stream streamA = this.connection.local().createStream(1, false);
        Http2Stream streamB = this.connection.local().createStream(3, false);
        Http2Stream streamC = this.connection.local().createStream(5, false);
        Http2Stream streamD = this.connection.local().createStream(7, false);
        Http2Stream streamE = this.connection.local().createStream(9, false);
        Http2Stream streamF = this.connection.local().createStream(11, false);
        Assert.assertEquals((long)6L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamA.id()));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamB.id()));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamC.id()));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamD.id()));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamE.id()));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamF.id()));
        this.setPriority(streamB.id(), streamA.id(), 16, false);
        Assert.assertEquals((long)5L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamB.id(), streamA.id(), (short)16));
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(streamA.id()));
        this.setPriority(streamC.id(), streamA.id(), 16, false);
        Assert.assertEquals((long)4L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamC.id(), streamA.id(), (short)16));
        Assert.assertEquals((long)2L, (long)this.distributor.numChildren(streamA.id()));
        this.setPriority(streamD.id(), streamC.id(), 16, false);
        Assert.assertEquals((long)3L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamD.id(), streamC.id(), (short)16));
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(streamC.id()));
        this.setPriority(streamE.id(), streamC.id(), 16, false);
        Assert.assertEquals((long)2L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamE.id(), streamC.id(), (short)16));
        Assert.assertEquals((long)2L, (long)this.distributor.numChildren(streamC.id()));
        this.setPriority(streamF.id(), streamD.id(), 16, false);
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamF.id(), streamD.id(), (short)16));
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(streamD.id()));
        Assert.assertEquals((long)6L, (long)this.connection.numActiveStreams());
        this.setPriority(streamA.id(), streamD.id(), 16, false);
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamD.id(), this.connection.connectionStream().id(), (short)16));
        Assert.assertEquals((long)2L, (long)this.distributor.numChildren(streamD.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamF.id(), streamD.id(), (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamF.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamA.id(), streamD.id(), (short)16));
        Assert.assertEquals((long)2L, (long)this.distributor.numChildren(streamA.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamB.id(), streamA.id(), (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamB.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamC.id(), streamA.id(), (short)16));
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(streamC.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamE.id(), streamC.id(), (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamE.id()));
    }

    @Test
    public void circularDependencyWithExclusiveShouldRestructureTree() throws Exception {
        Http2Stream streamA = this.connection.local().createStream(1, false);
        Http2Stream streamB = this.connection.local().createStream(3, false);
        Http2Stream streamC = this.connection.local().createStream(5, false);
        Http2Stream streamD = this.connection.local().createStream(7, false);
        Http2Stream streamE = this.connection.local().createStream(9, false);
        Http2Stream streamF = this.connection.local().createStream(11, false);
        Assert.assertEquals((long)6L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamA.id()));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamB.id()));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamC.id()));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamD.id()));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamE.id()));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamF.id()));
        this.setPriority(streamB.id(), streamA.id(), 16, false);
        Assert.assertEquals((long)5L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamB.id(), streamA.id(), (short)16));
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(streamA.id()));
        this.setPriority(streamC.id(), streamA.id(), 16, false);
        Assert.assertEquals((long)4L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamC.id(), streamA.id(), (short)16));
        Assert.assertEquals((long)2L, (long)this.distributor.numChildren(streamA.id()));
        this.setPriority(streamD.id(), streamC.id(), 16, false);
        Assert.assertEquals((long)3L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamD.id(), streamC.id(), (short)16));
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(streamC.id()));
        this.setPriority(streamE.id(), streamC.id(), 16, false);
        Assert.assertEquals((long)2L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamE.id(), streamC.id(), (short)16));
        Assert.assertEquals((long)2L, (long)this.distributor.numChildren(streamC.id()));
        this.setPriority(streamF.id(), streamD.id(), 16, false);
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamF.id(), streamD.id(), (short)16));
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(streamD.id()));
        Assert.assertEquals((long)6L, (long)this.connection.numActiveStreams());
        this.setPriority(streamA.id(), streamD.id(), 16, true);
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamD.id(), this.connection.connectionStream().id(), (short)16));
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(streamD.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamA.id(), streamD.id(), (short)16));
        Assert.assertEquals((long)3L, (long)this.distributor.numChildren(streamA.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamB.id(), streamA.id(), (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamB.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamF.id(), streamA.id(), (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamF.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamC.id(), streamA.id(), (short)16));
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(streamC.id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamE.id(), streamC.id(), (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamE.id()));
    }

    @Test
    public void unknownParentShouldBeCreatedUnderConnection() throws Exception {
        this.setup(5);
        int streamAId = 1;
        Http2Stream streamB = this.connection.local().createStream(3, false);
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamB.id()));
        this.setPriority(streamB.id(), streamAId, 16, false);
        Assert.assertEquals((long)1L, (long)this.connection.numActiveStreams());
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(this.connection.connectionStream().id()));
        Assert.assertTrue((boolean)this.distributor.isChild(streamAId, this.connection.connectionStream().id(), (short)16));
        Assert.assertEquals((long)1L, (long)this.distributor.numChildren(streamAId));
        Assert.assertTrue((boolean)this.distributor.isChild(streamB.id(), streamAId, (short)16));
        Assert.assertEquals((long)0L, (long)this.distributor.numChildren(streamB.id()));
    }
}

