/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2TestUtil;
import io.netty.handler.codec.http2.StreamByteDistributor;
import io.netty.handler.codec.http2.UniformStreamByteDistributor;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class UniformStreamByteDistributorTest {
    private static final int CHUNK_SIZE = 1024;
    private static final int STREAM_A = 1;
    private static final int STREAM_B = 3;
    private static final int STREAM_C = 5;
    private static final int STREAM_D = 7;
    private Http2Connection connection;
    private UniformStreamByteDistributor distributor;
    private IntObjectMap<Http2TestUtil.TestStreamByteDistributorStreamState> stateMap;
    @Mock
    private StreamByteDistributor.Writer writer;

    @Before
    public void setup() throws Http2Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.stateMap = new IntObjectHashMap();
        this.connection = new DefaultHttp2Connection(false);
        this.distributor = new UniformStreamByteDistributor(this.connection);
        this.resetWriter();
        this.connection.local().createStream(1, false);
        this.connection.local().createStream(3, false);
        Http2Stream streamC = this.connection.local().createStream(5, false);
        Http2Stream streamD = this.connection.local().createStream(7, false);
        this.setPriority(streamC.id(), 1, 16, false);
        this.setPriority(streamD.id(), 1, 16, false);
    }

    private Answer<Void> writeAnswer() {
        return new Answer<Void>(){

            public Void answer(InvocationOnMock in) throws Throwable {
                Http2Stream stream = (Http2Stream)in.getArgument(0);
                int numBytes = (Integer)in.getArgument(1);
                Http2TestUtil.TestStreamByteDistributorStreamState state = (Http2TestUtil.TestStreamByteDistributorStreamState)UniformStreamByteDistributorTest.this.stateMap.get(stream.id());
                state.pendingBytes -= (long)numBytes;
                state.hasFrame = state.pendingBytes > 0L;
                UniformStreamByteDistributorTest.this.distributor.updateStreamableBytes((StreamByteDistributor.StreamState)state);
                return null;
            }
        };
    }

    private void resetWriter() {
        Mockito.reset((Object[])new StreamByteDistributor.Writer[]{this.writer});
        ((StreamByteDistributor.Writer)Mockito.doAnswer(this.writeAnswer()).when((Object)this.writer)).write((Http2Stream)Mockito.any(Http2Stream.class), Mockito.anyInt());
    }

    @Test
    public void bytesUnassignedAfterProcessing() throws Http2Exception {
        this.initState(1, 1L, true);
        this.initState(3, 2L, true);
        this.initState(5, 3L, true);
        this.initState(7, 4L, true);
        Assert.assertFalse((boolean)this.write(10));
        this.verifyWrite(1, 1);
        this.verifyWrite(3, 2);
        this.verifyWrite(5, 3);
        this.verifyWrite(7, 4);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.writer});
        Assert.assertFalse((boolean)this.write(10));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.writer});
    }

    @Test
    public void connectionErrorForWriterException() throws Http2Exception {
        this.initState(1, 1L, true);
        this.initState(3, 2L, true);
        this.initState(5, 3L, true);
        this.initState(7, 4L, true);
        RuntimeException fakeException = new RuntimeException("Fake exception");
        ((StreamByteDistributor.Writer)Mockito.doThrow((Throwable[])new Throwable[]{fakeException}).when((Object)this.writer)).write((Http2Stream)Mockito.same((Object)this.stream(5)), Mockito.eq((int)3));
        try {
            this.write(10);
            Assert.fail((String)"Expected an exception");
        }
        catch (Http2Exception e) {
            Assert.assertFalse((boolean)Http2Exception.isStreamError((Http2Exception)e));
            Assert.assertEquals((Object)Http2Error.INTERNAL_ERROR, (Object)e.error());
            Assert.assertSame((Object)fakeException, (Object)e.getCause());
        }
        this.verifyWrite(Mockito.atMost((int)1), 1, 1);
        this.verifyWrite(Mockito.atMost((int)1), 3, 2);
        this.verifyWrite(5, 3);
        this.verifyWrite(Mockito.atMost((int)1), 7, 4);
        ((StreamByteDistributor.Writer)Mockito.doNothing().when((Object)this.writer)).write((Http2Stream)Mockito.same((Object)this.stream(5)), Mockito.eq((int)3));
        this.write(10);
        this.verifyWrite(1, 1);
        this.verifyWrite(3, 2);
        this.verifyWrite(5, 3);
        this.verifyWrite(7, 4);
    }

    @Test
    public void minChunkShouldBeAllocatedPerStream() throws Http2Exception {
        this.setPriority(1, 0, 50, false);
        this.setPriority(3, 0, 200, false);
        this.setPriority(5, 1, 100, false);
        this.setPriority(7, 1, 100, false);
        this.initState(1, 1024L, true);
        this.initState(3, 1024L, true);
        this.initState(5, 1024L, true);
        this.initState(7, 1024L, true);
        int written = 3072;
        Assert.assertTrue((boolean)this.write(written));
        Assert.assertEquals((long)1024L, (long)this.captureWrite(1));
        Assert.assertEquals((long)1024L, (long)this.captureWrite(3));
        Assert.assertEquals((long)1024L, (long)this.captureWrite(5));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.writer});
        this.resetWriter();
        Assert.assertFalse((boolean)this.write(1024));
        Assert.assertEquals((long)1024L, (long)this.captureWrite(7));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.writer});
    }

    @Test
    public void streamWithMoreDataShouldBeEnqueuedAfterWrite() throws Http2Exception {
        this.initState(1, 2048L, true);
        Assert.assertTrue((boolean)this.write(1024));
        Assert.assertEquals((long)1024L, (long)this.captureWrite(1));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.writer});
        this.resetWriter();
        Assert.assertFalse((boolean)this.write(1024));
        Assert.assertEquals((long)1024L, (long)this.captureWrite(1));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.writer});
    }

    @Test
    public void emptyFrameAtHeadIsWritten() throws Http2Exception {
        this.initState(1, 10L, true);
        this.initState(3, 0L, true);
        this.initState(5, 0L, true);
        this.initState(7, 10L, true);
        Assert.assertTrue((boolean)this.write(10));
        this.verifyWrite(1, 10);
        this.verifyWrite(3, 0);
        this.verifyWrite(5, 0);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.writer});
    }

    @Test
    public void streamWindowExhaustedDoesNotWrite() throws Http2Exception {
        this.initState(1, 0L, true, false);
        this.initState(3, 0L, true);
        this.initState(5, 0L, true);
        this.initState(7, 0L, true, false);
        Assert.assertFalse((boolean)this.write(10));
        this.verifyWrite(3, 0);
        this.verifyWrite(5, 0);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.writer});
    }

    @Test
    public void streamWindowLargerThanIntDoesNotInfiniteLoop() throws Http2Exception {
        this.initState(1, 0x80000000L, true, true);
        Assert.assertTrue((boolean)this.write(Integer.MAX_VALUE));
        this.verifyWrite(1, Integer.MAX_VALUE);
        Assert.assertFalse((boolean)this.write(1));
        this.verifyWrite(1, 1);
    }

    private Http2Stream stream(int streamId) {
        return this.connection.stream(streamId);
    }

    private void initState(int streamId, long streamableBytes, boolean hasFrame) {
        this.initState(streamId, streamableBytes, hasFrame, hasFrame);
    }

    private void initState(int streamId, long pendingBytes, boolean hasFrame, boolean isWriteAllowed) {
        Http2Stream stream = this.stream(streamId);
        Http2TestUtil.TestStreamByteDistributorStreamState state = new Http2TestUtil.TestStreamByteDistributorStreamState(stream, pendingBytes, hasFrame, isWriteAllowed);
        this.stateMap.put(streamId, (Object)state);
        this.distributor.updateStreamableBytes((StreamByteDistributor.StreamState)state);
    }

    private void setPriority(int streamId, int parent, int weight, boolean exclusive) {
        this.distributor.updateDependencyTree(streamId, parent, (short)weight, exclusive);
    }

    private boolean write(int numBytes) throws Http2Exception {
        return this.distributor.distribute(numBytes, this.writer);
    }

    private void verifyWrite(int streamId, int numBytes) {
        ((StreamByteDistributor.Writer)Mockito.verify((Object)this.writer)).write((Http2Stream)Mockito.same((Object)this.stream(streamId)), Mockito.eq((int)numBytes));
    }

    private void verifyWrite(VerificationMode mode, int streamId, int numBytes) {
        ((StreamByteDistributor.Writer)Mockito.verify((Object)this.writer, (VerificationMode)mode)).write((Http2Stream)Mockito.same((Object)this.stream(streamId)), Mockito.eq((int)numBytes));
    }

    private int captureWrite(int streamId) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Integer.class);
        ((StreamByteDistributor.Writer)Mockito.verify((Object)this.writer)).write((Http2Stream)Mockito.same((Object)this.stream(streamId)), ((Integer)captor.capture()).intValue());
        return (Integer)captor.getValue();
    }
}

