/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.DefaultMessageSizeEstimator;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2LocalFlowController;
import io.netty.handler.codec.http2.DefaultHttp2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.Http2ControlFrameLimitEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2FlowController;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameSizePolicy;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.util.ArrayDeque;
import java.util.Queue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class Http2ControlFrameLimitEncoderTest {
    private Http2ControlFrameLimitEncoder encoder;
    @Mock
    private Http2FrameWriter writer;
    @Mock
    private ChannelHandlerContext ctx;
    @Mock
    private Channel channel;
    @Mock
    private Channel.Unsafe unsafe;
    @Mock
    private ChannelConfig config;
    @Mock
    private EventExecutor executor;
    private int numWrites;
    private Queue<ChannelPromise> goAwayPromises = new ArrayDeque<ChannelPromise>();

    @Before
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.numWrites = 0;
        Http2FrameWriter.Configuration configuration = (Http2FrameWriter.Configuration)Mockito.mock(Http2FrameWriter.Configuration.class);
        Http2FrameSizePolicy frameSizePolicy = (Http2FrameSizePolicy)Mockito.mock(Http2FrameSizePolicy.class);
        Mockito.when((Object)this.writer.configuration()).thenReturn((Object)configuration);
        Mockito.when((Object)configuration.frameSizePolicy()).thenReturn((Object)frameSizePolicy);
        Mockito.when((Object)frameSizePolicy.maxFrameSize()).thenReturn((Object)16384);
        Mockito.when((Object)this.writer.writeRstStream((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), Mockito.anyLong(), (ChannelPromise)Mockito.any(ChannelPromise.class))).thenAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocationOnMock) {
                return Http2ControlFrameLimitEncoderTest.this.handlePromise(invocationOnMock, 3);
            }
        });
        Mockito.when((Object)this.writer.writeSettingsAck((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), (ChannelPromise)Mockito.any(ChannelPromise.class))).thenAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocationOnMock) {
                return Http2ControlFrameLimitEncoderTest.this.handlePromise(invocationOnMock, 1);
            }
        });
        Mockito.when((Object)this.writer.writePing((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyBoolean(), Mockito.anyLong(), (ChannelPromise)Mockito.any(ChannelPromise.class))).thenAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocationOnMock) {
                ChannelPromise promise = Http2ControlFrameLimitEncoderTest.this.handlePromise(invocationOnMock, 3);
                if (invocationOnMock.getArgument(1) == Boolean.FALSE) {
                    promise.trySuccess();
                }
                return promise;
            }
        });
        Mockito.when((Object)this.writer.writeGoAway((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class), (ChannelPromise)Mockito.any(ChannelPromise.class))).thenAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocationOnMock) {
                ReferenceCountUtil.release((Object)invocationOnMock.getArgument(3));
                ChannelPromise promise = (ChannelPromise)invocationOnMock.getArgument(4);
                Http2ControlFrameLimitEncoderTest.this.goAwayPromises.offer(promise);
                return promise;
            }
        });
        DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
        connection.remote().flowController((Http2FlowController)new DefaultHttp2RemoteFlowController((Http2Connection)connection));
        connection.local().flowController((Http2FlowController)new DefaultHttp2LocalFlowController((Http2Connection)connection).frameWriter(this.writer));
        DefaultHttp2ConnectionEncoder defaultEncoder = new DefaultHttp2ConnectionEncoder((Http2Connection)connection, this.writer);
        this.encoder = new Http2ControlFrameLimitEncoder((Http2ConnectionEncoder)defaultEncoder, 2);
        DefaultHttp2ConnectionDecoder decoder = new DefaultHttp2ConnectionDecoder((Http2Connection)connection, (Http2ConnectionEncoder)this.encoder, (Http2FrameReader)Mockito.mock(Http2FrameReader.class));
        Http2ConnectionHandler handler = new Http2ConnectionHandlerBuilder().frameListener((Http2FrameListener)Mockito.mock(Http2FrameListener.class)).codec((Http2ConnectionDecoder)decoder, (Http2ConnectionEncoder)this.encoder).build();
        Mockito.when((Object)this.ctx.channel()).thenReturn((Object)this.channel);
        Mockito.when((Object)this.ctx.alloc()).thenReturn((Object)UnpooledByteBufAllocator.DEFAULT);
        Mockito.when((Object)this.channel.alloc()).thenReturn((Object)UnpooledByteBufAllocator.DEFAULT);
        Mockito.when((Object)this.executor.inEventLoop()).thenReturn((Object)true);
        ((ChannelHandlerContext)Mockito.doAnswer((Answer)new Answer<ChannelPromise>(){

            public ChannelPromise answer(InvocationOnMock invocation) throws Throwable {
                return Http2ControlFrameLimitEncoderTest.this.newPromise();
            }
        }).when((Object)this.ctx)).newPromise();
        Mockito.when((Object)this.ctx.executor()).thenReturn((Object)this.executor);
        Mockito.when((Object)this.channel.isActive()).thenReturn((Object)false);
        Mockito.when((Object)this.channel.config()).thenReturn((Object)this.config);
        Mockito.when((Object)this.channel.isWritable()).thenReturn((Object)true);
        Mockito.when((Object)this.channel.bytesBeforeUnwritable()).thenReturn((Object)Long.MAX_VALUE);
        Mockito.when((Object)this.config.getWriteBufferHighWaterMark()).thenReturn((Object)Integer.MAX_VALUE);
        Mockito.when((Object)this.config.getMessageSizeEstimator()).thenReturn((Object)DefaultMessageSizeEstimator.DEFAULT);
        ChannelMetadata metadata = new ChannelMetadata(false, 16);
        Mockito.when((Object)this.channel.metadata()).thenReturn((Object)metadata);
        Mockito.when((Object)this.channel.unsafe()).thenReturn((Object)this.unsafe);
        handler.handlerAdded(this.ctx);
    }

    private ChannelPromise handlePromise(InvocationOnMock invocationOnMock, int promiseIdx) {
        ChannelPromise promise = (ChannelPromise)invocationOnMock.getArgument(promiseIdx);
        if (++this.numWrites == 2) {
            promise.setSuccess();
        }
        return promise;
    }

    @After
    public void teardown() {
        ChannelPromise promise;
        this.encoder.close();
        while ((promise = this.goAwayPromises.poll()) != null) {
            promise.setSuccess();
        }
    }

    @Test
    public void testLimitSettingsAck() {
        Assert.assertFalse((boolean)this.encoder.writeSettingsAck(this.ctx, this.newPromise()).isDone());
        Assert.assertTrue((boolean)this.encoder.writeSettingsAck(this.ctx, this.newPromise()).isSuccess());
        Assert.assertFalse((boolean)this.encoder.writeSettingsAck(this.ctx, this.newPromise()).isDone());
        this.verifyFlushAndClose(0, false);
        Assert.assertFalse((boolean)this.encoder.writeSettingsAck(this.ctx, this.newPromise()).isDone());
        Assert.assertFalse((boolean)this.encoder.writeSettingsAck(this.ctx, this.newPromise()).isDone());
        this.verifyFlushAndClose(1, true);
    }

    @Test
    public void testLimitPingAck() {
        Assert.assertFalse((boolean)this.encoder.writePing(this.ctx, true, 8L, this.newPromise()).isDone());
        Assert.assertTrue((boolean)this.encoder.writePing(this.ctx, true, 8L, this.newPromise()).isSuccess());
        Assert.assertFalse((boolean)this.encoder.writePing(this.ctx, true, 8L, this.newPromise()).isDone());
        this.verifyFlushAndClose(0, false);
        Assert.assertFalse((boolean)this.encoder.writePing(this.ctx, true, 8L, this.newPromise()).isDone());
        Assert.assertFalse((boolean)this.encoder.writePing(this.ctx, true, 8L, this.newPromise()).isDone());
        this.verifyFlushAndClose(1, true);
    }

    @Test
    public void testNotLimitPing() {
        Assert.assertTrue((boolean)this.encoder.writePing(this.ctx, false, 8L, this.newPromise()).isSuccess());
        Assert.assertTrue((boolean)this.encoder.writePing(this.ctx, false, 8L, this.newPromise()).isSuccess());
        Assert.assertTrue((boolean)this.encoder.writePing(this.ctx, false, 8L, this.newPromise()).isSuccess());
        Assert.assertTrue((boolean)this.encoder.writePing(this.ctx, false, 8L, this.newPromise()).isSuccess());
        this.verifyFlushAndClose(0, false);
    }

    @Test
    public void testLimitRst() {
        Assert.assertFalse((boolean)this.encoder.writeRstStream(this.ctx, 1, Http2Error.CANCEL.code(), this.newPromise()).isDone());
        Assert.assertTrue((boolean)this.encoder.writeRstStream(this.ctx, 1, Http2Error.CANCEL.code(), this.newPromise()).isSuccess());
        Assert.assertFalse((boolean)this.encoder.writeRstStream(this.ctx, 1, Http2Error.CANCEL.code(), this.newPromise()).isDone());
        this.verifyFlushAndClose(0, false);
        Assert.assertFalse((boolean)this.encoder.writeRstStream(this.ctx, 1, Http2Error.CANCEL.code(), this.newPromise()).isDone());
        Assert.assertFalse((boolean)this.encoder.writeRstStream(this.ctx, 1, Http2Error.CANCEL.code(), this.newPromise()).isDone());
        this.verifyFlushAndClose(1, true);
    }

    @Test
    public void testLimit() {
        Assert.assertFalse((boolean)this.encoder.writeRstStream(this.ctx, 1, Http2Error.CANCEL.code(), this.newPromise()).isDone());
        Assert.assertTrue((boolean)this.encoder.writePing(this.ctx, false, 8L, this.newPromise()).isSuccess());
        Assert.assertFalse((boolean)this.encoder.writePing(this.ctx, true, 8L, this.newPromise()).isSuccess());
        this.verifyFlushAndClose(0, false);
        Assert.assertFalse((boolean)this.encoder.writeSettingsAck(this.ctx, this.newPromise()).isDone());
        Assert.assertFalse((boolean)this.encoder.writeRstStream(this.ctx, 1, Http2Error.CANCEL.code(), this.newPromise()).isDone());
        Assert.assertFalse((boolean)this.encoder.writePing(this.ctx, true, 8L, this.newPromise()).isSuccess());
        this.verifyFlushAndClose(1, true);
    }

    private void verifyFlushAndClose(int invocations, boolean failed) {
        ((ChannelHandlerContext)Mockito.verify((Object)this.ctx, (VerificationMode)Mockito.atLeast((int)invocations))).flush();
        ((ChannelHandlerContext)Mockito.verify((Object)this.ctx, (VerificationMode)Mockito.times((int)invocations))).close();
        if (failed) {
            ((Http2FrameWriter)Mockito.verify((Object)this.writer, (VerificationMode)Mockito.times((int)1))).writeGoAway((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)0), Mockito.eq((long)Http2Error.ENHANCE_YOUR_CALM.code()), (ByteBuf)Mockito.any(ByteBuf.class), (ChannelPromise)Mockito.any(ChannelPromise.class));
        }
    }

    private ChannelPromise newPromise() {
        return new DefaultChannelPromise(this.channel, (EventExecutor)ImmediateEventExecutor.INSTANCE);
    }
}

