/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import io.netty.util.internal.PlatformDependent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.Ignore;

@Ignore
public final class HashCollisionTest {
    private HashCollisionTest() {
    }

    public static void main(String[] args) throws IllegalAccessException, IOException, URISyntaxException {
        ArrayList<CharSequence> strings = new ArrayList<CharSequence>(350000);
        HashCollisionTest.addHttpHeaderNames(strings);
        HashCollisionTest.addHttpHeaderValues(strings);
        HashCollisionTest.addHttp2HeaderNames(strings);
        HashCollisionTest.addWordsFromFile(new File("/usr/share/dict/words"), strings);
        Map<Integer, List<CharSequence>> dups = HashCollisionTest.calculateDuplicates(strings, new Function<CharSequence, Integer>(){

            @Override
            public Integer apply(CharSequence string) {
                int h = 0;
                for (int i = 0; i < string.length(); ++i) {
                    h = h * 31 + (string.charAt(i) & 0x1F);
                }
                return h;
            }
        });
        PrintStream writer = System.out;
        writer.println("==Old Duplicates==");
        HashCollisionTest.printResults(writer, dups);
        dups = HashCollisionTest.calculateDuplicates(strings, new Function<CharSequence, Integer>(){

            @Override
            public Integer apply(CharSequence string) {
                return PlatformDependent.hashCodeAscii((CharSequence)string);
            }
        });
        writer.println();
        writer.println("==New Duplicates==");
        HashCollisionTest.printResults(writer, dups);
    }

    private static void addHttpHeaderNames(List<CharSequence> values) throws IllegalAccessException {
        for (Field f : HttpHeaderNames.class.getFields()) {
            if (f.getType() != AsciiString.class) continue;
            values.add((CharSequence)((AsciiString)f.get(null)));
        }
    }

    private static void addHttpHeaderValues(List<CharSequence> values) throws IllegalAccessException {
        for (Field f : HttpHeaderValues.class.getFields()) {
            if (f.getType() != AsciiString.class) continue;
            values.add((CharSequence)((AsciiString)f.get(null)));
        }
    }

    private static void addHttp2HeaderNames(List<CharSequence> values) throws IllegalAccessException {
        for (Http2Headers.PseudoHeaderName name : Http2Headers.PseudoHeaderName.values()) {
            values.add((CharSequence)name.value());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addWordsFromFile(File file, List<CharSequence> values) throws IllegalAccessException, IOException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (line.indexOf(39) >= 0) continue;
                values.add(line);
            }
        }
        finally {
            br.close();
        }
    }

    private static Map<Integer, List<CharSequence>> calculateDuplicates(List<CharSequence> strings, Function<CharSequence, Integer> hasher) {
        HashMap hashResults = new HashMap();
        HashSet<Integer> duplicateHashCodes = new HashSet<Integer>();
        for (CharSequence str : strings) {
            Integer hash = hasher.apply(str);
            ArrayList<CharSequence> results = (ArrayList<CharSequence>)hashResults.get(hash);
            if (results == null) {
                results = new ArrayList<CharSequence>(1);
                hashResults.put(hash, results);
            } else {
                duplicateHashCodes.add(hash);
            }
            results.add(str);
        }
        if (duplicateHashCodes.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Integer, List<CharSequence>> duplicates = new HashMap<Integer, List<CharSequence>>(duplicateHashCodes.size());
        for (Integer duplicateHashCode : duplicateHashCodes) {
            ArrayList realDups = new ArrayList(2);
            Iterator itr = ((List)hashResults.get(duplicateHashCode)).iterator();
            realDups.add(itr.next());
            block2: do {
                CharSequence next = (CharSequence)itr.next();
                for (CharSequence potentialDup : realDups) {
                    if (AsciiString.contentEqualsIgnoreCase((CharSequence)next, (CharSequence)potentialDup)) continue;
                    realDups.add(next);
                    break block2;
                }
            } while (itr.hasNext());
            if (realDups.size() <= 1) continue;
            duplicates.put(duplicateHashCode, realDups);
        }
        return duplicates;
    }

    private static void printResults(PrintStream stream, Map<Integer, List<CharSequence>> dups) {
        stream.println("Number duplicates: " + dups.size());
        for (Map.Entry<Integer, List<CharSequence>> entry : dups.entrySet()) {
            stream.print(entry.getValue().size() + " duplicates for hash: " + entry.getKey() + " values: ");
            for (CharSequence str : entry.getValue()) {
                stream.print("[" + str + "] ");
            }
            stream.println();
        }
    }

    private static interface Function<P, R> {
        public R apply(P var1);
    }
}

