/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2TestUtil;
import io.netty.handler.codec.http2.StreamByteDistributor;
import io.netty.handler.codec.http2.WeightedFairQueueByteDistributor;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import org.mockito.Mock;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

abstract class AbstractWeightedFairQueueByteDistributorDependencyTest {
    Http2Connection connection;
    WeightedFairQueueByteDistributor distributor;
    private IntObjectMap<Http2TestUtil.TestStreamByteDistributorStreamState> stateMap = new IntObjectHashMap();
    @Mock
    StreamByteDistributor.Writer writer;

    AbstractWeightedFairQueueByteDistributorDependencyTest() {
    }

    Http2Stream stream(int streamId) {
        return this.connection.stream(streamId);
    }

    Answer<Void> writeAnswer(final boolean closeIfNoFrame) {
        return new Answer<Void>(){

            public Void answer(InvocationOnMock in) throws Throwable {
                Http2Stream stream = (Http2Stream)in.getArgument(0);
                int numBytes = (Integer)in.getArgument(1);
                Http2TestUtil.TestStreamByteDistributorStreamState state = (Http2TestUtil.TestStreamByteDistributorStreamState)AbstractWeightedFairQueueByteDistributorDependencyTest.this.stateMap.get(stream.id());
                state.pendingBytes -= (long)numBytes;
                state.isWriteAllowed = state.hasFrame = state.pendingBytes > 0L;
                if (closeIfNoFrame && !state.hasFrame) {
                    stream.close();
                }
                AbstractWeightedFairQueueByteDistributorDependencyTest.this.distributor.updateStreamableBytes((StreamByteDistributor.StreamState)state);
                return null;
            }
        };
    }

    void initState(int streamId, long streamableBytes, boolean hasFrame) {
        this.initState(streamId, streamableBytes, hasFrame, hasFrame);
    }

    void initState(int streamId, long pendingBytes, boolean hasFrame, boolean isWriteAllowed) {
        Http2Stream stream = this.stream(streamId);
        Http2TestUtil.TestStreamByteDistributorStreamState state = new Http2TestUtil.TestStreamByteDistributorStreamState(stream, pendingBytes, hasFrame, isWriteAllowed);
        this.stateMap.put(streamId, (Object)state);
        this.distributor.updateStreamableBytes((StreamByteDistributor.StreamState)state);
    }

    void setPriority(int streamId, int parent, int weight, boolean exclusive) throws Http2Exception {
        this.distributor.updateDependencyTree(streamId, parent, (short)weight, exclusive);
    }
}

