/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelHandlerInvoker;
import io.netty.channel.ChannelHandlerInvokerUtil;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.AbstractHttp2StreamChannel;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.DefaultHttp2ResetFrame;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.handler.codec.http2.Http2FrameAdapter;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2InboundFrameLogger;
import io.netty.handler.codec.http2.Http2OutboundFrameLogger;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamFrame;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.codec.http2.InboundHttpToHttp2Adapter;
import io.netty.handler.logging.LogLevel;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.internal.OneTimeTask;
import java.util.ArrayList;
import java.util.List;

public final class Http2MultiplexCodec
extends ChannelDuplexHandler {
    private static final Http2FrameLogger HTTP2_FRAME_LOGGER = new Http2FrameLogger(LogLevel.INFO, Http2MultiplexCodec.class);
    private final ChannelHandler streamHandler;
    private final EventLoopGroup streamGroup;
    private final Http2ConnectionHandler http2Handler;
    private final Http2Connection.PropertyKey streamInfoKey;
    private final List<StreamInfo> streamsToFireChildReadComplete = new ArrayList<StreamInfo>();
    private ChannelHandlerContext ctx;
    private ChannelHandlerContext http2HandlerCtx;

    public Http2MultiplexCodec(boolean server, ChannelHandler streamHandler) {
        this(server, streamHandler, null);
    }

    public Http2MultiplexCodec(boolean server, ChannelHandler streamHandler, EventLoopGroup streamGroup) {
        this(server, streamHandler, streamGroup, new DefaultHttp2FrameWriter());
    }

    Http2MultiplexCodec(boolean server, ChannelHandler streamHandler, EventLoopGroup streamGroup, Http2FrameWriter frameWriter) {
        if (!streamHandler.getClass().isAnnotationPresent(ChannelHandler.Sharable.class)) {
            throw new IllegalArgumentException("streamHandler must be Sharable");
        }
        this.streamHandler = streamHandler;
        this.streamGroup = streamGroup;
        DefaultHttp2Connection connection = new DefaultHttp2Connection(server);
        frameWriter = new Http2OutboundFrameLogger(frameWriter, HTTP2_FRAME_LOGGER);
        DefaultHttp2ConnectionEncoder encoder = new DefaultHttp2ConnectionEncoder(connection, frameWriter);
        Http2InboundFrameLogger reader = new Http2InboundFrameLogger(new DefaultHttp2FrameReader(), HTTP2_FRAME_LOGGER);
        DefaultHttp2ConnectionDecoder decoder = new DefaultHttp2ConnectionDecoder(connection, encoder, reader);
        decoder.frameListener(new FrameListener());
        this.http2Handler = new InternalHttp2ConnectionHandler(decoder, encoder, new Http2Settings());
        this.http2Handler.connection().addListener(new ConnectionListener());
        this.streamInfoKey = this.http2Handler.connection().newKey();
    }

    Http2ConnectionHandler connectionHandler() {
        return this.http2Handler;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        ctx.pipeline().addBefore((EventExecutorGroup)ctx.executor(), ctx.name(), null, (ChannelHandler)this.http2Handler);
        this.http2HandlerCtx = ctx.pipeline().context((ChannelHandler)this.http2Handler);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        ctx.pipeline().remove((ChannelHandler)this.http2Handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (!(evt instanceof HttpServerUpgradeHandler.UpgradeEvent)) {
            super.userEventTriggered(ctx, evt);
            return;
        }
        HttpServerUpgradeHandler.UpgradeEvent upgrade = (HttpServerUpgradeHandler.UpgradeEvent)evt;
        ctx.fireUserEventTriggered((Object)upgrade.retain());
        try {
            Http2Stream stream = this.http2Handler.connection().stream(1);
            new ConnectionListener().onStreamActive(stream);
            upgrade.upgradeRequest().headers().setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 1);
            new InboundHttpToHttp2Adapter(this.http2Handler.connection(), this.http2Handler.decoder().frameListener()).channelRead(ctx, upgrade.upgradeRequest().retain());
        }
        finally {
            upgrade.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        block9: {
            if (!(msg instanceof Http2Frame)) {
                super.write(ctx, msg, promise);
                return;
            }
            try {
                if (msg instanceof Http2StreamFrame) {
                    Object streamObject = ((Http2StreamFrame)msg).stream();
                    int streamId = ((Http2StreamChannel)((Object)streamObject)).stream.id();
                    if (msg instanceof Http2DataFrame) {
                        Http2DataFrame frame = (Http2DataFrame)msg;
                        this.http2Handler.encoder().writeData(this.http2HandlerCtx, streamId, frame.content().retain(), frame.padding(), frame.isEndStream(), promise);
                        break block9;
                    }
                    if (msg instanceof Http2HeadersFrame) {
                        Http2HeadersFrame frame = (Http2HeadersFrame)msg;
                        this.http2Handler.encoder().writeHeaders(this.http2HandlerCtx, streamId, frame.headers(), frame.padding(), frame.isEndStream(), promise);
                        break block9;
                    }
                    if (msg instanceof Http2ResetFrame) {
                        Http2ResetFrame frame = (Http2ResetFrame)msg;
                        this.http2Handler.resetStream(this.http2HandlerCtx, streamId, frame.errorCode(), promise);
                        break block9;
                    }
                    throw new UnsupportedMessageTypeException(msg, new Class[0]);
                }
                if (msg instanceof Http2GoAwayFrame) {
                    Http2GoAwayFrame frame = (Http2GoAwayFrame)msg;
                    int lastStreamId = this.http2Handler.connection().remote().lastStreamCreated() + frame.extraStreamIds() * 2;
                    this.http2Handler.goAway(this.http2HandlerCtx, lastStreamId, frame.errorCode(), frame.content().retain(), promise);
                    break block9;
                }
                throw new UnsupportedMessageTypeException(msg, new Class[0]);
            }
            finally {
                ReferenceCountUtil.release((Object)msg);
            }
        }
    }

    ChannelFuture createStreamChannel(ChannelHandlerContext ctx, Http2Stream stream, ChannelHandler handler) {
        EventLoopGroup group = this.streamGroup != null ? this.streamGroup : ctx.channel().eventLoop();
        Http2StreamChannel channel = new Http2StreamChannel(stream);
        channel.pipeline().addLast(new ChannelHandler[]{handler});
        ChannelFuture future = group.register((Channel)channel);
        if (future.cause() != null) {
            if (channel.isRegistered()) {
                channel.close();
            } else {
                channel.unsafe().closeForcibly();
            }
        }
        return future;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        for (int i = 0; i < this.streamsToFireChildReadComplete.size(); ++i) {
            StreamInfo streamInfo = this.streamsToFireChildReadComplete.get(i);
            streamInfo.inStreamsToFireChildReadComplete = false;
            streamInfo.childChannel.fireChildReadComplete();
        }
        this.streamsToFireChildReadComplete.clear();
    }

    void fireChildReadAndRegister(StreamInfo streamInfo, Object msg) {
        streamInfo.childChannel.fireChildRead(msg);
        if (!streamInfo.inStreamsToFireChildReadComplete) {
            this.streamsToFireChildReadComplete.add(streamInfo);
            streamInfo.inStreamsToFireChildReadComplete = true;
        }
    }

    final class Http2StreamChannel
    extends AbstractHttp2StreamChannel {
        private final Http2Stream stream;
        boolean onStreamClosedFired;

        Http2StreamChannel(Http2Stream stream) {
            super(Http2MultiplexCodec.this.ctx.channel());
            this.stream = stream;
        }

        @Override
        protected void doClose() throws Exception {
            if (!this.onStreamClosedFired) {
                DefaultHttp2ResetFrame resetFrame = new DefaultHttp2ResetFrame(Http2Error.CANCEL).setStream((Object)this);
                ChannelHandlerInvoker invoker = Http2MultiplexCodec.this.ctx.invoker();
                invoker.invokeWrite(Http2MultiplexCodec.this.ctx, (Object)resetFrame, Http2MultiplexCodec.this.ctx.newPromise());
                invoker.invokeFlush(Http2MultiplexCodec.this.ctx);
            }
            super.doClose();
        }

        @Override
        protected void doWrite(Object msg) {
            if (!(msg instanceof Http2StreamFrame)) {
                ReferenceCountUtil.release((Object)msg);
                throw new IllegalArgumentException("Message must be an Http2StreamFrame: " + msg);
            }
            Http2StreamFrame frame = (Http2StreamFrame)msg;
            if (frame.stream() != null) {
                ReferenceCountUtil.release((Object)frame);
                throw new IllegalArgumentException("Stream must be null on the frame");
            }
            frame.setStream((Object)this);
            Http2MultiplexCodec.this.ctx.invoker().invokeWrite(Http2MultiplexCodec.this.ctx, (Object)frame, Http2MultiplexCodec.this.ctx.newPromise());
        }

        @Override
        protected void doWriteComplete() {
            Http2MultiplexCodec.this.ctx.invoker().invokeFlush(Http2MultiplexCodec.this.ctx);
        }

        @Override
        protected EventExecutor preferredEventExecutor() {
            return Http2MultiplexCodec.this.ctx.executor();
        }

        @Override
        protected void bytesConsumed(final int bytes) {
            EventExecutor executor = Http2MultiplexCodec.this.ctx.executor();
            if (executor.inEventLoop()) {
                this.bytesConsumed0(bytes);
            } else {
                executor.execute((Runnable)new OneTimeTask(){

                    public void run() {
                        Http2StreamChannel.this.bytesConsumed0(bytes);
                    }
                });
            }
        }

        private void bytesConsumed0(int bytes) {
            try {
                Http2MultiplexCodec.this.http2Handler.connection().local().flowController().consumeBytes(this.stream, bytes);
            }
            catch (Throwable t) {
                ChannelHandlerInvokerUtil.invokeExceptionCaughtNow((ChannelHandlerContext)Http2MultiplexCodec.this.ctx, (Throwable)t);
            }
        }
    }

    static final class StreamInfo {
        final Http2StreamChannel childChannel;
        boolean inStreamsToFireChildReadComplete;

        StreamInfo(Http2StreamChannel childChannel) {
            this.childChannel = childChannel;
        }
    }

    class FrameListener
    extends Http2FrameAdapter {
        FrameListener() {
        }

        @Override
        public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
            Http2Stream stream = Http2MultiplexCodec.this.http2Handler.connection().stream(streamId);
            StreamInfo streamInfo = (StreamInfo)stream.getProperty(Http2MultiplexCodec.this.streamInfoKey);
            streamInfo.childChannel.pipeline().fireUserEventTriggered((Object)new DefaultHttp2ResetFrame(errorCode));
        }

        @Override
        public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
            this.onHeadersRead(ctx, streamId, headers, padding, endStream);
        }

        @Override
        public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
            Http2Stream stream = Http2MultiplexCodec.this.http2Handler.connection().stream(streamId);
            StreamInfo streamInfo = (StreamInfo)stream.getProperty(Http2MultiplexCodec.this.streamInfoKey);
            Http2MultiplexCodec.this.fireChildReadAndRegister(streamInfo, new DefaultHttp2HeadersFrame(headers, endOfStream, padding));
        }

        @Override
        public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
            Http2Stream stream = Http2MultiplexCodec.this.http2Handler.connection().stream(streamId);
            StreamInfo streamInfo = (StreamInfo)stream.getProperty(Http2MultiplexCodec.this.streamInfoKey);
            Http2MultiplexCodec.this.fireChildReadAndRegister(streamInfo, new DefaultHttp2DataFrame(data.retain(), endOfStream, padding));
            return 0;
        }
    }

    class InternalHttp2ConnectionHandler
    extends Http2ConnectionHandler {
        public InternalHttp2ConnectionHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
            super(decoder, encoder, initialSettings);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onStreamError(ChannelHandlerContext ctx, Throwable cause, Http2Exception.StreamException http2Ex) {
            try {
                Http2Stream stream = Http2MultiplexCodec.this.http2Handler.connection().stream(http2Ex.streamId());
                if (stream == null) {
                    return;
                }
                StreamInfo streamInfo = (StreamInfo)stream.getProperty(Http2MultiplexCodec.this.streamInfoKey);
                if (streamInfo == null) {
                    return;
                }
                streamInfo.childChannel.pipeline().fireExceptionCaught((Throwable)http2Ex);
            }
            finally {
                super.onStreamError(ctx, cause, http2Ex);
            }
        }
    }

    final class ConnectionListener
    extends Http2ConnectionAdapter {
        ConnectionListener() {
        }

        @Override
        public void onStreamActive(Http2Stream stream) {
            if (Http2MultiplexCodec.this.ctx == null) {
                return;
            }
            if (stream.getProperty(Http2MultiplexCodec.this.streamInfoKey) != null) {
                return;
            }
            ChannelFuture future = Http2MultiplexCodec.this.createStreamChannel(Http2MultiplexCodec.this.ctx, stream, Http2MultiplexCodec.this.streamHandler);
            stream.setProperty(Http2MultiplexCodec.this.streamInfoKey, new StreamInfo((Http2StreamChannel)future.channel()));
        }

        @Override
        public void onStreamClosed(Http2Stream stream) {
            final StreamInfo streamInfo = (StreamInfo)stream.getProperty(Http2MultiplexCodec.this.streamInfoKey);
            if (streamInfo != null) {
                EventLoop eventLoop = streamInfo.childChannel.eventLoop();
                if (eventLoop.inEventLoop()) {
                    this.onStreamClosed0(streamInfo);
                } else {
                    eventLoop.execute((Runnable)new OneTimeTask(){

                        public void run() {
                            ConnectionListener.this.onStreamClosed0(streamInfo);
                        }
                    });
                }
            }
        }

        private void onStreamClosed0(StreamInfo streamInfo) {
            streamInfo.childChannel.onStreamClosedFired = true;
            streamInfo.childChannel.fireChildRead(AbstractHttp2StreamChannel.CLOSE_MESSAGE);
        }

        @Override
        public void onGoAwayReceived(final int lastStreamId, long errorCode, ByteBuf debugData) {
            final DefaultHttp2GoAwayFrame goAway = new DefaultHttp2GoAwayFrame(errorCode, debugData);
            try {
                Http2MultiplexCodec.this.http2Handler.connection().forEachActiveStream(new Http2StreamVisitor(){

                    @Override
                    public boolean visit(Http2Stream stream) {
                        if (stream.id() > lastStreamId && Http2MultiplexCodec.this.http2Handler.connection().local().isValidStreamId(stream.id())) {
                            StreamInfo streamInfo = (StreamInfo)stream.getProperty(Http2MultiplexCodec.this.streamInfoKey);
                            streamInfo.childChannel.pipeline().fireUserEventTriggered((Object)goAway.duplicate().retain());
                        }
                        return true;
                    }
                });
            }
            catch (Throwable t) {
                Http2MultiplexCodec.this.ctx.invoker().invokeExceptionCaught(Http2MultiplexCodec.this.ctx, t);
            }
            Http2MultiplexCodec.this.ctx.fireUserEventTriggered((Object)goAway.duplicate().retain());
        }
    }
}

